/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.rmi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.RemoteObject;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import mx4j.adaptor.interceptor.AdaptorInterceptor;
import mx4j.adaptor.interceptor.ContextClassLoaderAdaptorInterceptor;
import mx4j.adaptor.interceptor.Interceptor;
import mx4j.adaptor.interceptor.Invocation;
import mx4j.adaptor.interceptor.InvocationResult;
import mx4j.adaptor.interceptor.InvokerAdaptorInterceptor;
import mx4j.adaptor.interceptor.LoggerAdaptorInterceptor;
import mx4j.adaptor.rmi.RMIAdaptorMBean;
import mx4j.adaptor.rmi.RemoteAdaptor;
import mx4j.connector.JMXAddress;
import mx4j.connector.MalformedJMXAddressException;
import mx4j.log.Log;
import mx4j.log.Logger;

public abstract class RMIAdaptor
extends RemoteObject
implements RMIAdaptorMBean,
MBeanRegistration,
RemoteAdaptor {
    private MBeanServer m_server;
    private ObjectName m_objectName;
    private ArrayList m_interceptors = new ArrayList();
    private ArrayList m_interceptorNames = new ArrayList();
    private JMXAddress m_address;
    private Interceptor m_headInterceptor;

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.m_server = server;
        this.m_objectName = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract boolean isRunning();

    public abstract String getProtocol();

    public String getJNDIName() {
        return this.m_address == null ? null : this.m_address.getPath();
    }

    public void setJNDIName(String name) {
        block8: {
            if (name == null) {
                throw new IllegalArgumentException("JNDI name cannnot be null");
            }
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException("JNDI name cannnot be empty");
            }
            if (!this.isRunning()) {
                try {
                    if (this.m_address == null) {
                        this.m_address = new JMXAddress("rmi", "localhost", 1099, name);
                        break block8;
                    }
                    JMXAddress address = new JMXAddress(this.m_address.getProtocol(), this.m_address.getHost(), this.m_address.getPort(), name);
                    Map properties = this.m_address.getProperties();
                    Iterator i = properties.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        address.putProperty((String)entry.getKey(), entry.getValue());
                    }
                    this.m_address = address;
                }
                catch (MalformedJMXAddressException ignored) {}
            } else {
                throw new IllegalStateException("Cannot perform this operation while running");
            }
        }
    }

    public void putJNDIProperty(Object property, Object value) {
        this.putNamingProperty(property, value);
    }

    public void putNamingProperty(Object property, Object value) {
        block10: {
            if (!this.isRunning()) {
                try {
                    if ("java.naming.provider.url".equals(property)) {
                        if (this.m_address == null) {
                            this.m_address = new JMXAddress("jmx:" + value);
                        } else {
                            Map properties = this.m_address.getProperties();
                            String path = this.m_address.getPath();
                            String val = String.valueOf(value);
                            if (path != null) {
                                val = val + "/" + path;
                            }
                            JMXAddress address = new JMXAddress("jmx:" + val);
                            Iterator i = properties.entrySet().iterator();
                            while (i.hasNext()) {
                                Map.Entry entry = i.next();
                                address.putProperty((String)entry.getKey(), entry.getValue());
                            }
                            this.m_address = address;
                        }
                        break block10;
                    }
                    if (this.m_address == null) {
                        this.m_address = new JMXAddress("jmx:rmi://localhost");
                    }
                    this.m_address.putProperty((String)property, value);
                }
                catch (MalformedJMXAddressException ignored) {}
            } else {
                throw new IllegalStateException("Cannot perform this operation while running");
            }
        }
    }

    public void clearJNDIProperties() {
        this.clearNamingProperties();
    }

    public void clearNamingProperties() {
        if (!this.isRunning()) {
            try {
                if (this.m_address != null) {
                    this.m_address = new JMXAddress(this.m_address.getProtocol(), this.m_address.getHost(), this.m_address.getPort(), this.m_address.getPath());
                }
            }
            catch (MalformedJMXAddressException ignored) {}
        } else {
            throw new IllegalStateException("Cannot perform this operation while running");
        }
    }

    public Properties getJNDIProperties() {
        return this.getNamingProperties();
    }

    public Properties getNamingProperties() {
        Map properties;
        Properties p = new Properties();
        if (this.m_address != null && (properties = this.m_address.getProperties()).size() > 0) {
            StringBuffer buffer = new StringBuffer(this.m_address.getProtocol());
            buffer.append("://");
            buffer.append(this.m_address.getHost());
            int port = this.m_address.getPort();
            if (port > 0) {
                buffer.append(":").append(port);
            }
            p.put("java.naming.provider.url", buffer.toString());
            Iterator i = properties.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                p.put(entry.getKey(), entry.getValue());
            }
        }
        return p;
    }

    private JMXAddress getJMXAddress() {
        return this.m_address == null ? null : (JMXAddress)this.m_address.clone();
    }

    private void setJMXAddress(JMXAddress address) {
        this.m_address = (JMXAddress)address.clone();
    }

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ignored) {
            return "localhost";
        }
    }

    public String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ignored) {
            return "127.0.0.1";
        }
    }

    public InvocationResult invoke(Invocation invocation) throws Exception {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Incoming RMI call, heading to interceptor chain");
        }
        return this.m_headInterceptor.invoke(invocation);
    }

    public void addInterceptor(Interceptor interceptor) {
        if (interceptor != null) {
            this.m_interceptors.add(interceptor);
        }
    }

    protected void installInterceptors() {
        MBeanServer server = this.getMBeanServer();
        if (server == null) {
            throw new IllegalStateException("Target MBeanServer is not set. Either call setMBeanServer or register this MBean");
        }
        List interceptors = this.getInterceptors();
        LoggerAdaptorInterceptor head = new LoggerAdaptorInterceptor();
        head.setMBeanServer(server);
        this.registerInterceptor(head);
        ContextClassLoaderAdaptorInterceptor neck = new ContextClassLoaderAdaptorInterceptor();
        head.setNext(neck);
        neck.setMBeanServer(server);
        this.registerInterceptor(neck);
        Interceptor previous = neck;
        int i = 0;
        while (i < interceptors.size()) {
            Interceptor next = (Interceptor)interceptors.get(i);
            previous.setNext(next);
            if (next instanceof AdaptorInterceptor) {
                ((AdaptorInterceptor)next).setMBeanServer(server);
            }
            this.registerInterceptor(next);
            previous = next;
            ++i;
        }
        InvokerAdaptorInterceptor last = new InvokerAdaptorInterceptor();
        previous.setNext(last);
        last.setMBeanServer(server);
        this.registerInterceptor(last);
        this.m_headInterceptor = head;
    }

    private void registerInterceptor(Interceptor interceptor) {
        block8: {
            ObjectName name = this.getObjectName();
            if (name == null) {
                return;
            }
            Logger logger = this.getLogger();
            try {
                ObjectName interceptorObjectName = null;
                if (interceptor instanceof AdaptorInterceptor) {
                    AdaptorInterceptor i = (AdaptorInterceptor)interceptor;
                    interceptorObjectName = i.getObjectName();
                }
                if (interceptorObjectName == null) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Adaptor ObjectName: " + name);
                    }
                    String domain = name.getDomain();
                    Hashtable<String, String> props = name.getKeyPropertyList();
                    props.put("interceptor", interceptor.getType());
                    interceptorObjectName = new ObjectName(domain, props);
                }
                if (logger.isEnabledFor(10)) {
                    logger.debug("Adaptor interceptor ObjectName: " + interceptorObjectName);
                }
                this.m_server.registerMBean(interceptor, interceptorObjectName);
                this.m_interceptorNames.add(interceptorObjectName);
                if (logger.isEnabledFor(0)) {
                    logger.trace("Adaptor interceptor registered successfully");
                }
            }
            catch (Exception x) {
                if (!logger.isEnabledFor(0)) break block8;
                logger.trace("Cannot register interceptor", x);
            }
        }
    }

    protected void uninstallInterceptors() {
        Logger logger = this.getLogger();
        int i = 0;
        while (i < this.m_interceptorNames.size()) {
            block5: {
                ObjectName name = (ObjectName)this.m_interceptorNames.get(i);
                if (logger.isEnabledFor(10)) {
                    logger.debug("Unregistering adaptor interceptor with ObjectName: " + name);
                }
                try {
                    this.m_server.unregisterMBean(name);
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Adaptor interceptor unregistered successfully");
                    }
                }
                catch (Exception x) {
                    if (!logger.isEnabledFor(0)) break block5;
                    logger.trace("Cannot unregister interceptor", x);
                }
            }
            ++i;
        }
    }

    private List getInterceptors() {
        return this.m_interceptors;
    }

    public void setMBeanServer(MBeanServer server) {
        this.m_server = server;
    }

    protected MBeanServer getMBeanServer() {
        return this.m_server;
    }

    protected ObjectName getObjectName() {
        return this.m_objectName;
    }

    protected void bind(Object adaptor) throws NamingException {
        Logger logger = this.getLogger();
        String jndiName = this.getJNDIName();
        if (logger.isEnabledFor(10)) {
            logger.debug("Binding " + this + " in JNDI, name is: " + jndiName);
        }
        if (jndiName == null) {
            throw new NamingException("Invalid JNDI name");
        }
        InitialContext context = null;
        Properties properties = this.getNamingProperties();
        if (logger.isEnabledFor(10)) {
            logger.debug("Binding " + this + " in JNDI, properties are: " + properties);
        }
        context = properties.size() > 0 ? new InitialContext(properties) : new InitialContext();
        context.bind(jndiName, adaptor);
        if (logger.isEnabledFor(10)) {
            logger.debug("Bound " + this + " in JNDI");
        }
    }

    protected void unbind() throws NamingException {
        String jndiName = this.getJNDIName();
        if (jndiName == null) {
            throw new NamingException("Invalid JNDI name");
        }
        InitialContext context = null;
        Properties properties = this.getNamingProperties();
        context = properties.size() != 0 ? new InitialContext(properties) : new InitialContext();
        context.unbind(jndiName);
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }
}

