/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.serial;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.wan.GatewayQueueEvent;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderEventCallbackArgument;
import org.apache.geode.internal.cache.wan.GatewaySenderEventCallbackDispatcher;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.internal.cache.wan.serial.BatchDestroyOperation;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderQueue;
import org.apache.geode.internal.cache.wan.serial.SerialSecondaryGatewayListener;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class SerialGatewaySenderEventProcessor
extends AbstractGatewaySenderEventProcessor {
    private static final Logger logger = LogService.getLogger();
    private final Object unprocessedEventsLock = new Object();
    protected static final int RANDOM_SLEEP_TIME = 1000;
    private Map<EventID, AbstractGatewaySender.EventWrapper> unprocessedEvents;
    protected Map<EventID, Long> unprocessedTokens;
    private ExecutorService executor;
    private Object listenerObjectLock = new Object();
    private boolean failoverCompleted = false;
    private final Object failoverCompletedLock = new Object();
    protected static final int REAP_THRESHOLD = 1000;
    private int uncheckedCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialGatewaySenderEventProcessor(AbstractGatewaySender sender, String id, ThreadsMonitoring tMonitoring, boolean cleanQueues) {
        super("Event Processor for GatewaySender_" + id, sender, tMonitoring);
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            this.initializeMessageQueue(id, cleanQueues);
            this.unprocessedEvents = new LinkedHashMap<EventID, AbstractGatewaySender.EventWrapper>();
            this.unprocessedTokens = new LinkedHashMap<EventID, Long>();
        }
    }

    @Override
    protected void initializeMessageQueue(String id, boolean cleanQueues) {
        StringBuffer regionNameBuffer = new StringBuffer();
        regionNameBuffer.append(id).append("_SERIAL_GATEWAY_SENDER_QUEUE");
        String regionName = regionNameBuffer.toString();
        SerialSecondaryGatewayListener listener = null;
        if (!this.sender.isPrimary()) {
            listener = new SerialSecondaryGatewayListener(this);
            this.initializeListenerExecutor();
        }
        this.queue = new SerialGatewaySenderQueue(this.sender, regionName, listener, cleanQueues);
        if (logger.isDebugEnabled()) {
            logger.debug("Created queue: {}", (Object)this.queue);
        }
    }

    protected boolean waitForPrimary() {
        block13: {
            try {
                this.sender.getSenderAdvisor().waitToBecomePrimary(this);
            }
            catch (InterruptedException e) {
                if (!this.stopped()) {
                    logger.fatal("An InterruptedException occurred. The thread will exit.", (Throwable)e);
                }
                this.shutdownListenerExecutor();
                return false;
            }
            try {
                this.shutdownListenerExecutor();
                DistributedSystem.setThreadsSocketPolicy(true);
                if (!this.stopped()) {
                    this.handleFailover();
                    break block13;
                }
                boolean e = false;
                return e;
            }
            catch (RegionDestroyedException e) {
                if (!this.stopped()) {
                    logger.debug("Terminating due to {}", (Object)e.getMessage(), (Object)e);
                }
                boolean bl = false;
                return bl;
            }
            catch (CancelException e) {
                if (!this.stopped()) {
                    logger.debug("Terminating due to {}", (Object)e.getMessage(), (Object)e);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.completeFailover();
            }
        }
        return true;
    }

    @Override
    public void run() {
        try {
            this.setRunningStatus();
            if (!this.sender.isPrimary()) {
                if (!this.waitForPrimary()) {
                    return;
                }
            } else {
                this.completeFailover();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Beginning to process the message queue");
            }
            if (!this.sender.isPrimary()) {
                logger.warn("About to process the message queue but not the primary.");
            }
            try {
                Thread.sleep(new Random().nextInt(1000));
            }
            catch (InterruptedException e) {
                return;
            }
            this.processQueue();
        }
        catch (CancelException e) {
            if (!this.isStopped()) {
                logger.info("A cancellation occurred. Stopping the dispatcher.");
                this.setIsStopped(true);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            logger.fatal("Message dispatch failed due to unexpected exception..", e);
        }
    }

    @Override
    protected void rebalance() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFailover() {
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            GatewaySenderEventImpl ge;
            Object o;
            Iterator<Object> it;
            this.queue.removeCacheListener();
            this.unprocessedTokens = null;
            logger.info("Gateway Failover Initiated: Processing {} unprocessed events.", (Object)this.unprocessedEvents.size());
            GatewaySenderStats statistics = this.sender.getStatistics();
            if (!this.unprocessedEvents.isEmpty()) {
                this.reapOld(statistics, true);
                it = this.queue.getRegion().values().iterator();
                while (it.hasNext() && !this.stopped()) {
                    AbstractGatewaySender.EventWrapper unprocessedEvent;
                    o = it.next();
                    if (o == null || !(o instanceof GatewaySenderEventImpl) || (unprocessedEvent = this.unprocessedEvents.remove((ge = (GatewaySenderEventImpl)o).getEventId())) == null) continue;
                    unprocessedEvent.event.release();
                    if (!this.unprocessedEvents.isEmpty()) continue;
                    break;
                }
                it = this.unprocessedEvents.entrySet().iterator();
                while (it.hasNext() && !this.stopped()) {
                    Map.Entry me = (Map.Entry)it.next();
                    AbstractGatewaySender.EventWrapper ew = (AbstractGatewaySender.EventWrapper)me.getValue();
                    GatewaySenderEventImpl gatewayEvent = ew.event;
                    gatewayEvent.initialize();
                    GatewaySenderEventCallbackArgument seca = gatewayEvent.getSenderCallbackArgument();
                    if (seca.getOriginatingDSId() == -1) {
                        seca.setOriginatingDSId(this.sender.getMyDSId());
                        seca.initializeReceipientDSIds(Collections.singletonList(this.sender.getRemoteDSId()));
                    }
                    it.remove();
                    boolean queuedEvent = false;
                    try {
                        queuedEvent = this.queuePrimaryEvent(gatewayEvent);
                    }
                    catch (IOException ex) {
                        if (this.stopped()) continue;
                        logger.warn(String.format("Event dropped during failover: %s", gatewayEvent), (Throwable)ex);
                    }
                    catch (CacheException ex) {
                        if (this.stopped()) continue;
                        logger.warn(String.format("Event dropped during failover: %s", gatewayEvent), (Throwable)ex);
                    }
                    finally {
                        if (queuedEvent) continue;
                        gatewayEvent.release();
                    }
                }
                statistics.clearUnprocessedMaps();
            }
            logger.info("{} : Marking  {}  events as possible duplicates", (Object)this.getSender(), (Object)this.queue.size());
            it = this.queue.getRegion().values().iterator();
            while (it.hasNext() && !this.stopped()) {
                o = it.next();
                if (o == null || !(o instanceof GatewaySenderEventImpl)) continue;
                ge = (GatewaySenderEventImpl)o;
                ge.setPossibleDuplicate(true);
            }
            this.releaseUnprocessedEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseUnprocessedEvents() {
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            Map<EventID, AbstractGatewaySender.EventWrapper> m = this.unprocessedEvents;
            if (m != null) {
                for (AbstractGatewaySender.EventWrapper ew : m.values()) {
                    GatewaySenderEventImpl gatewayEvent = ew.event;
                    if (logger.isDebugEnabled()) {
                        logger.debug("releaseUnprocessedEvents:" + gatewayEvent);
                    }
                    gatewayEvent.release();
                }
                this.unprocessedEvents = null;
            }
        }
    }

    @Override
    public void closeProcessor() {
        try {
            super.closeProcessor();
        }
        finally {
            this.releaseUnprocessedEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent event, Object substituteValue, boolean isLastEventInTransaction) throws IOException, CacheException {
        GatewaySenderEventImpl senderEvent = null;
        boolean isPrimary = this.sender.isPrimary();
        if (!isPrimary) {
            Object object = this.unprocessedEventsLock;
            synchronized (object) {
                if (this.sender.isPrimary()) {
                    isPrimary = true;
                } else {
                    boolean isCME_And_NotOriginRemote;
                    boolean isUpdateVersionStamp = event.getOperation().equals(Operation.UPDATE_VERSION_STAMP);
                    boolean bl = isCME_And_NotOriginRemote = ((EntryEventImpl)event).isConcurrencyConflict() && !event.isOriginRemote();
                    if (!isUpdateVersionStamp && !isCME_And_NotOriginRemote) {
                        senderEvent = new GatewaySenderEventImpl(operation, event, substituteValue, false, isLastEventInTransaction);
                        this.handleSecondaryEvent(senderEvent);
                    }
                }
            }
        }
        if (isPrimary) {
            boolean isPDXRegion;
            Region region = event.getRegion();
            boolean bl = isPDXRegion = region instanceof DistributedRegion && region.getName().equals("PdxTypes");
            if (!isPDXRegion) {
                this.waitForFailoverCompletion();
            }
            senderEvent = new GatewaySenderEventImpl(operation, event, substituteValue, isLastEventInTransaction);
            boolean queuedEvent = false;
            try {
                queuedEvent = this.queuePrimaryEvent(senderEvent);
            }
            finally {
                if (!queuedEvent) {
                    GatewaySenderEventImpl.release(senderEvent);
                }
            }
        }
    }

    private boolean queuePrimaryEvent(GatewaySenderEventImpl gatewayEvent) throws IOException, CacheException {
        GatewaySenderStats statistics = this.sender.getStatistics();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Queueing event ({}): {}", (Object)this.sender.getId(), (Object)(statistics.getEventsQueued() + 1), (Object)gatewayEvent);
        }
        if (!this.sender.beforeEnqueue(gatewayEvent)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Event {} is not added to queue.", (Object)gatewayEvent);
            }
            statistics.incEventsFiltered();
            return false;
        }
        long start = statistics.startTime();
        boolean putDone = false;
        try {
            putDone = this.queue.put(gatewayEvent);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getSender().getCancelCriterion().checkCancelInProgress(e);
        }
        statistics.endPut(start);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Queued event ({}): {}", (Object)this.sender.getId(), (Object)statistics.getEventsQueued(), (Object)gatewayEvent);
        }
        int queueSize = this.eventQueueSize();
        statistics.incQueueSize(1);
        if (!this.eventQueueSizeWarning && queueSize >= AbstractGatewaySender.QUEUE_SIZE_THRESHOLD) {
            logger.warn("{}: The event queue has reached {} events. Processing will continue.", (Object)this.sender.getId(), (Object)AbstractGatewaySender.QUEUE_SIZE_THRESHOLD);
            this.eventQueueSizeWarning = true;
        }
        return putDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForFailoverCompletion() {
        Object object = this.failoverCompletedLock;
        synchronized (object) {
            if (this.failoverCompleted) {
                return;
            }
            logger.info("{} : Waiting for failover completion", (Object)this);
            try {
                while (!this.failoverCompleted) {
                    this.failoverCompletedLock.wait();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.sender.getCache().getCancelCriterion().checkCancelInProgress(ex);
                logger.info("{}: did not wait for failover completion due to interruption.", (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeFailover() {
        Object object = this.failoverCompletedLock;
        synchronized (object) {
            this.failoverCompleted = true;
            this.failoverCompletedLock.notifyAll();
        }
    }

    protected void handleSecondaryEvent(GatewaySenderEventImpl senderEvent) {
        this.basicHandleSecondaryEvent(senderEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePrimaryEvent(final GatewaySenderEventImpl gatewayEvent) {
        ExecutorService my_executor = this.executor;
        Object object = this.listenerObjectLock;
        synchronized (object) {
            if (my_executor == null) {
                return;
            }
            my_executor.execute(new Runnable(){

                @Override
                public void run() {
                    SerialGatewaySenderEventProcessor.this.basicHandlePrimaryEvent(gatewayEvent);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePrimaryDestroy(final GatewaySenderEventImpl gatewayEvent) {
        ExecutorService my_executor = this.executor;
        Object object = this.listenerObjectLock;
        synchronized (object) {
            if (my_executor == null) {
                return;
            }
            my_executor.execute(new Runnable(){

                @Override
                public void run() {
                    SerialGatewaySenderEventProcessor.this.basicHandlePrimaryDestroy(gatewayEvent.getEventId(), false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean basicHandlePrimaryDestroy(EventID eventId, boolean addToUnprocessedTokens) {
        if (this.sender.isPrimary()) {
            return false;
        }
        GatewaySenderStats statistics = this.sender.getStatistics();
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            if (this.sender.isPrimary()) {
                return false;
            }
            if (this.unprocessedEvents == null) {
                return false;
            }
            AbstractGatewaySender.EventWrapper ew = this.unprocessedEvents.remove(eventId);
            if (ew != null) {
                ew.event.release();
                statistics.incUnprocessedEventsRemovedByPrimary();
                return true;
            }
            if (addToUnprocessedTokens) {
                Long mapValue;
                Long oldv;
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: fromPrimary destroy event {} : added to unprocessed token map", (Object)this.sender.getId(), (Object)eventId);
                }
                if ((oldv = this.unprocessedTokens.put(eventId, mapValue = Long.valueOf(System.currentTimeMillis() + (long)AbstractGatewaySender.TOKEN_TIMEOUT))) == null) {
                    statistics.incUnprocessedTokensAddedByPrimary();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicHandlePrimaryEvent(GatewaySenderEventImpl gatewayEvent) {
        if (this.sender.isPrimary()) {
            return;
        }
        GatewaySenderStats statistics = this.sender.getStatistics();
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            if (this.sender.isPrimary()) {
                return;
            }
            if (this.unprocessedEvents == null) {
                return;
            }
            AbstractGatewaySender.EventWrapper ew = this.unprocessedEvents.remove(gatewayEvent.getEventId());
            if (ew == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: fromPrimary event {} : {}->{} added to unprocessed token map", (Object)this.sender.getId(), (Object)gatewayEvent.getEventId(), gatewayEvent.getKey(), (Object)gatewayEvent.getValueAsString(true));
                }
                Long mapValue = System.currentTimeMillis() + (long)AbstractGatewaySender.TOKEN_TIMEOUT;
                Long oldv = this.unprocessedTokens.put(gatewayEvent.getEventId(), mapValue);
                if (oldv == null) {
                    statistics.incUnprocessedTokensAddedByPrimary();
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Primary create/update event {}:{}->{} remove from unprocessed events map", (Object)this.sender.getId(), (Object)gatewayEvent.getEventId(), gatewayEvent.getKey(), (Object)gatewayEvent.getValueAsString(true));
                }
                ew.event.release();
                statistics.incUnprocessedEventsRemovedByPrimary();
            }
            this.reapOld(statistics, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicHandleSecondaryEvent(GatewaySenderEventImpl gatewayEvent) {
        boolean freeGatewayEvent = true;
        try {
            GatewaySenderStats statistics = this.sender.getStatistics();
            if (!this.getSender().getGatewayEventFilters().isEmpty()) {
                try {
                    gatewayEvent.initialize();
                }
                catch (Exception e) {
                    logger.warn(String.format("Event failed to be initialized: %s", gatewayEvent), (Throwable)e);
                }
                if (!this.sender.beforeEnqueue(gatewayEvent)) {
                    statistics.incEventsFiltered();
                    return;
                }
            }
            Assert.assertHoldsLock(this.unprocessedEventsLock, true);
            Assert.assertTrue(this.unprocessedEvents != null);
            Long v = this.unprocessedTokens.remove(gatewayEvent.getEventId());
            if (v == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: fromSecondary event {}:{}->{} added from unprocessed events map", (Object)this.sender.getId(), (Object)gatewayEvent.getEventId(), gatewayEvent.getKey(), (Object)gatewayEvent.getValueAsString(true));
                }
                AbstractGatewaySender.EventWrapper mapValue = new AbstractGatewaySender.EventWrapper(gatewayEvent);
                AbstractGatewaySender.EventWrapper oldv = this.unprocessedEvents.put(gatewayEvent.getEventId(), mapValue);
                if (oldv == null) {
                    freeGatewayEvent = false;
                    statistics.incUnprocessedEventsAddedBySecondary();
                } else {
                    this.unprocessedEvents.put(gatewayEvent.getEventId(), oldv);
                    logger.warn("{}: The secondary map already contained an event from hub {} so ignoring new event {}.", (Object)this.sender.getId(), (Object)v, (Object)gatewayEvent);
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Secondary created event {}:{}->{} removed from unprocessed events map", (Object)this.sender.getId(), (Object)gatewayEvent.getEventId(), gatewayEvent.getKey(), (Object)gatewayEvent.getValueAsString(true));
                }
                statistics.incUnprocessedTokensRemovedBySecondary();
            }
            this.reapOld(statistics, false);
        }
        finally {
            if (freeGatewayEvent) {
                gatewayEvent.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reapOld(GatewaySenderStats statistics, boolean forceEventReap) {
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            if (this.uncheckedCount > 1000) {
                Map.Entry<EventID, Object> me;
                int count;
                Iterator<Map.Entry<EventID, Object>> it;
                this.uncheckedCount = 0;
                long now = System.currentTimeMillis();
                if (!forceEventReap && this.unprocessedTokens.size() > 1000) {
                    long meValue;
                    it = this.unprocessedTokens.entrySet().iterator();
                    count = 0;
                    while (it.hasNext() && (meValue = ((Long)(me = it.next()).getValue()).longValue()) <= now) {
                        it.remove();
                        ++count;
                    }
                    if (count > 0) {
                        // empty if block
                    }
                }
                if (!forceEventReap && this.unprocessedEvents.size() <= 1000) return;
                it = this.unprocessedEvents.entrySet().iterator();
                count = 0;
                while (it.hasNext()) {
                    me = it.next();
                    AbstractGatewaySender.EventWrapper ew = (AbstractGatewaySender.EventWrapper)me.getValue();
                    if (ew.timeout > now) break;
                    it.remove();
                    ew.event.release();
                    ++count;
                }
                if (count <= 0) return;
            } else {
                ++this.uncheckedCount;
                // empty if block
            }
            return;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GatewayEventProcessor[").append("gatewaySenderId=").append(this.sender.getId()).append(";remoteDSId=").append(this.getSender().getRemoteDSId()).append(";batchSize=").append(this.getSender().getBatchSize());
        buffer.append("]");
        return buffer.toString();
    }

    private void initializeListenerExecutor() {
        this.executor = LoggingExecutors.newFixedThreadPoolWithTimeout((int)1, (int)120, (TimeUnit)TimeUnit.SECONDS, (String)"Queued Gateway Listener Thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownListenerExecutor() {
        Object object = this.listenerObjectLock;
        synchronized (object) {
            if (this.executor != null) {
                this.executor.shutdown();
                this.executor = null;
            }
        }
    }

    @Override
    public void removeCacheListener() {
        this.queue.removeCacheListener();
    }

    @Override
    public void initializeEventDispatcher() {
        if (logger.isDebugEnabled()) {
            logger.debug(" Creating the GatewayEventCallbackDispatcher");
        }
        this.dispatcher = new GatewaySenderEventCallbackDispatcher(this);
    }

    @Override
    protected void enqueueEvent(GatewayQueueEvent event) {
        throw new UnsupportedOperationException();
    }

    public void sendBatchDestroyOperationForDroppedEvent(EntryEventImpl dropEvent, int index) {
        block4: {
            EntryEventImpl destroyEvent = EntryEventImpl.create((InternalRegion)((LocalRegion)this.queue.getRegion()), Operation.DESTROY, (Object)index, null, null, false, this.sender.getCache().getMyId());
            destroyEvent.setEventId(dropEvent.getEventId());
            destroyEvent.disallowOffHeapValues();
            destroyEvent.setTailKey(-1L);
            if (logger.isDebugEnabled()) {
                logger.debug("SerialGatewaySenderEventProcessor sends BatchDestroyOperation to secondary for event {}", (Object)destroyEvent);
            }
            try {
                BatchDestroyOperation op = new BatchDestroyOperation(destroyEvent);
                op.distribute();
                if (logger.isDebugEnabled()) {
                    logger.debug("BatchRemovalThread completed destroy of dropped event {}", (Object)dropEvent);
                }
            }
            catch (Exception ignore) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Exception in sending dropped event could be ignored in order not to interrupt sender starting", (Throwable)ignore);
            }
        }
    }

    @Override
    protected void registerEventDroppedInPrimaryQueue(EntryEventImpl droppedEvent) {
        this.sendBatchDestroyOperationForDroppedEvent(droppedEvent, -1);
    }

    private String printEventIdList(Set<EventID> eventIds) {
        StringBuffer sb = new StringBuffer().append("[").append(eventIds.stream().map(entry -> entry.expensiveToString()).collect(Collectors.joining(", "))).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String printUnprocessedEvents() {
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            return this.printEventIdList(this.unprocessedEvents.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String printUnprocessedTokens() {
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            return this.printEventIdList(this.unprocessedTokens.keySet());
        }
    }

    public int numUnprocessedEventTokens() {
        return this.unprocessedTokens.entrySet().size();
    }
}

