/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Map;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.cache.VersionException;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.CommandInitializer;
import org.apache.geode.internal.cache.tier.sockets.ServerSideHandshakeImpl;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.internal.serialization.VersioningIO;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class ServerSideHandshakeFactory {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    static final KnownVersion currentServerVersion = KnownVersion.CURRENT;

    ServerSideHandshakeFactory() {
    }

    ServerSideHandshake readHandshake(Socket socket, int timeout, CommunicationMode communicationMode, DistributedSystem system, SecurityService securityService) throws Exception {
        KnownVersion clientVersion = this.readClientVersion(socket, timeout, communicationMode.isWAN());
        if (logger.isDebugEnabled()) {
            logger.debug("Client version: {}", (Object)clientVersion);
        }
        if (clientVersion.isOlderThan((Version)KnownVersion.OLDEST)) {
            throw new UnsupportedVersionException("Unsupported version " + clientVersion + "Server's current version " + currentServerVersion);
        }
        return new ServerSideHandshakeImpl(socket, timeout, system, clientVersion, communicationMode, securityService);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KnownVersion readClientVersion(Socket socket, int timeout, boolean isWan) throws IOException, VersionException {
        int soTimeout = -1;
        try {
            Map<Integer, Command> commands;
            soTimeout = socket.getSoTimeout();
            socket.setSoTimeout(timeout);
            InputStream is = socket.getInputStream();
            short clientVersionOrdinal = VersioningIO.readOrdinalFromInputStream((InputStream)is);
            if (clientVersionOrdinal == -1) {
                throw new EOFException("HandShakeReader: EOF reached before client version could be read");
            }
            if (isWan) {
                KnownVersion knownVersion = currentServerVersion;
                return knownVersion;
            }
            KnownVersion clientVersion = Versioning.getKnownVersionOrDefault((Version)Versioning.getVersion((short)clientVersionOrdinal), (KnownVersion)KnownVersion.TEST_VERSION);
            if (clientVersion != KnownVersion.TEST_VERSION && (commands = CommandInitializer.getDefaultInstance().get(clientVersion)) != null) {
                KnownVersion knownVersion = clientVersion;
                return knownVersion;
            }
            SocketAddress sa = socket.getRemoteSocketAddress();
            String sInfo = "";
            if (sa == null) throw new UnsupportedVersionException(KnownVersion.unsupportedVersionMessage((short)clientVersionOrdinal) + sInfo);
            sInfo = " Client: " + sa.toString() + ".";
            throw new UnsupportedVersionException(KnownVersion.unsupportedVersionMessage((short)clientVersionOrdinal) + sInfo);
        }
        finally {
            if (soTimeout != -1) {
                try {
                    socket.setSoTimeout(soTimeout);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

