/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance;

import org.apache.geode.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import org.apache.geode.internal.cache.partitioned.rebalance.model.BucketRollup;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Move;
import org.apache.geode.internal.cache.partitioned.rebalance.model.PartitionedRegionLoadModel;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class SatisfyRedundancy
extends RebalanceDirectorAdapter {
    private static final Logger logger = LogService.getLogger();
    private PartitionedRegionLoadModel model;

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        this.model = model;
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.initialize(model);
    }

    @Override
    public boolean nextStep() {
        if (this.satisfyRedundancy()) {
            return true;
        }
        this.model.waitForOperations();
        return this.satisfyRedundancy();
    }

    private boolean satisfyRedundancy() {
        Move bestMove = null;
        BucketRollup first = null;
        while (bestMove == null) {
            if (this.model.getLowRedundancyBuckets().isEmpty()) {
                return false;
            }
            first = this.model.getLowRedundancyBuckets().first();
            bestMove = this.model.findBestTarget(first, true);
            if (bestMove == null && !this.model.enforceUniqueZones()) {
                bestMove = this.model.findBestTarget(first, false);
            }
            if (bestMove != null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping low redundancy bucket {} because no member will accept it", (Object)first);
            }
            this.model.ignoreLowRedundancyBucket(first);
        }
        this.model.createRedundantBucket(first, bestMove.getTarget());
        return true;
    }
}

