/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class MoveBucketMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private volatile int bucketId;
    private volatile InternalDistributedMember source;

    public MoveBucketMessage() {
    }

    private MoveBucketMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId, InternalDistributedMember source) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
        this.source = source;
    }

    public static MoveBucketResponse send(InternalDistributedMember recipient, PartitionedRegion region, int bucketId, InternalDistributedMember source) {
        Assert.assertTrue(recipient != null, "MoveBucketMessage NULL recipient");
        MoveBucketResponse response = new MoveBucketResponse(region.getSystem(), recipient, region);
        MoveBucketMessage msg = new MoveBucketMessage(recipient, region.getPRId(), response, bucketId, source);
        msg.setTransactionDistributed(region.getCache().getTxManager().isDistributed());
        Set<InternalDistributedMember> failures = region.getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            return null;
        }
        region.getPrStats().incPartitionMessagesSent();
        return response;
    }

    public MoveBucketMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in, InternalDataSerializer.createDeserializationContext(in));
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion region, long startTime) throws ForceReattemptException {
        PartitionedRegionDataStore dataStore = region.getDataStore();
        boolean moved = dataStore.moveBucket(this.bucketId, this.source, true);
        region.getPrStats().endPartitionMessagesProcessing(startTime);
        MoveBucketReplyMessage.send(this.getSender(), this.getProcessorId(), dm, null, moved);
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
        buff.append("; source=").append(this.source);
    }

    public int getDSFID() {
        return 136;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.bucketId = in.readInt();
        this.source = (InternalDistributedMember)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.bucketId);
        DataSerializer.writeObject(this.source, out);
    }

    public static class MoveBucketResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean moved = false;

        public MoveBucketResponse(InternalDistributedSystem ds, InternalDistributedMember recipient, PartitionedRegion theRegion) {
            super(ds, recipient);
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof MoveBucketReplyMessage) {
                    MoveBucketReplyMessage reply = (MoveBucketReplyMessage)msg;
                    this.moved = reply.moved();
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "MoveBucketResponse is {}", (Object)this.moved);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        @Override
        protected synchronized void processException(ReplyException ex) {
            logger.debug("MoveBucketMessage ignoring exception: {}", (Object)ex.getMessage(), (Object)ex);
        }

        public boolean waitForResponse() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    String msg = "MoveBucketMessage got remote cancellation,";
                    logger.debug(msg, t);
                    return false;
                }
                if (t instanceof PRLocallyDestroyedException) {
                    String msg = "MoveBucketMessage got local destroy on the PartitionRegion ";
                    logger.debug(msg, t);
                    return false;
                }
                if (t instanceof ForceReattemptException) {
                    String msg = "MoveBucketMessage got ForceReattemptException due to local destroy on the PartitionRegion";
                    logger.debug(msg, t);
                    return false;
                }
                e.handleCause();
            }
            return this.moved;
        }
    }

    public static class MoveBucketReplyMessage
    extends ReplyMessage {
        private boolean moved;

        public MoveBucketReplyMessage() {
        }

        public MoveBucketReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in, InternalDataSerializer.createDeserializationContext(in));
        }

        private MoveBucketReplyMessage(int processorId, ReplyException re, boolean moved) {
            this.processorId = processorId;
            this.moved = moved;
            this.setException(re);
        }

        public static void send(InternalDistributedMember recipient, int processorId, DistributionManager dm, ReplyException re, boolean moved) {
            Assert.assertTrue(recipient != null, "MoveBucketReplyMessage NULL recipient");
            MoveBucketReplyMessage m = new MoveBucketReplyMessage(processorId, re, moved);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        boolean moved() {
            return this.moved;
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "MoveBucketReplyMessage process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "MoveBucketReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeBoolean(this.moved);
        }

        @Override
        public int getDSFID() {
            return 137;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.moved = in.readBoolean();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("MoveBucketReplyMessage ").append("processorid=").append(this.processorId).append(" moved=").append(this.moved).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }
    }
}

