/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.distributed.internal.DistributedSystemService;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InputStreamFilter;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ObjectInputStreamFilterWrapper
implements InputStreamFilter {
    private static final Logger logger = LogService.getLogger();
    private boolean usingJava8;
    private Object serializationFilter;
    private Class configClass;
    private Method setObjectInputFilterMethod;
    private Method createFilterMethod;
    private Class filterClass;
    private Object ALLOWED;
    private Object REJECTED;
    private Method checkInputMethod;
    private Class filterInfoClass;
    private Method serialClassMethod;

    public ObjectInputStreamFilterWrapper(String serializationFilterSpec, Collection<DistributedSystemService> services) {
        HashSet<String> sanctionedClasses = new HashSet<String>(500);
        for (DistributedSystemService service : services) {
            try {
                Collection<String> classNames = service.getSerializationAcceptlist();
                logger.info("loaded {} sanctioned serializables from {}", (Object)classNames.size(), (Object)service.getClass().getSimpleName());
                sanctionedClasses.addAll(classNames);
            }
            catch (IOException e) {
                throw new InternalGemFireException("error initializing serialization filter for " + service, e);
            }
        }
        try {
            URL sanctionedSerializables = ClassPathLoader.getLatest().getResource(InternalDataSerializer.class, "sanctioned-geode-core-serializables.txt");
            Collection<String> coreClassNames = InternalDataSerializer.loadClassNames(sanctionedSerializables);
            URL sanctionedManagementSerializables = ClassPathLoader.getLatest().getResource(InternalDataSerializer.class, "sanctioned-geode-management-serializables.txt");
            Collection<String> managmentClassNames = InternalDataSerializer.loadClassNames(sanctionedManagementSerializables);
            sanctionedClasses.addAll(coreClassNames);
            sanctionedClasses.addAll(managmentClassNames);
        }
        catch (IOException e) {
            throw new InternalGemFireException("unable to read sanctionedSerializables.txt to form a serialization acceptlist", e);
        }
        logger.info("setting a serialization filter containing {}", (Object)serializationFilterSpec);
        if (this.createJava8Filter(serializationFilterSpec, sanctionedClasses)) {
            return;
        }
        this.createJava9Filter(serializationFilterSpec, sanctionedClasses);
    }

    @Override
    public void setFilterOn(ObjectInputStream objectInputStream) {
        try {
            if (this.usingJava8) {
                this.setObjectInputFilterMethod.invoke((Object)this.configClass, objectInputStream, this.serializationFilter);
            } else {
                this.setObjectInputFilterMethod.invoke((Object)objectInputStream, this.serializationFilter);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InternalGemFireError("Unable to filter serialization", e);
        }
    }

    private boolean createJava8Filter(String serializationFilterSpec, Collection<String> sanctionedClasses) {
        ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
        try {
            this.filterInfoClass = classPathLoader.forName("sun.misc.ObjectInputFilter$FilterInfo");
            this.serialClassMethod = this.filterInfoClass.getDeclaredMethod("serialClass", new Class[0]);
            this.filterClass = classPathLoader.forName("sun.misc.ObjectInputFilter");
            this.checkInputMethod = this.filterClass.getDeclaredMethod("checkInput", this.filterInfoClass);
            Class<?> statusClass = classPathLoader.forName("sun.misc.ObjectInputFilter$Status");
            this.ALLOWED = statusClass.getEnumConstants()[1];
            this.REJECTED = statusClass.getEnumConstants()[2];
            if (!this.ALLOWED.toString().equals("ALLOWED") || !this.REJECTED.toString().equals("REJECTED")) {
                throw new GemFireConfigException("ObjectInputFilter$Status enumeration in this JDK is not as expected");
            }
            this.configClass = classPathLoader.forName("sun.misc.ObjectInputFilter$Config");
            this.setObjectInputFilterMethod = this.configClass.getDeclaredMethod("setObjectInputFilter", ObjectInputStream.class, this.filterClass);
            this.createFilterMethod = this.configClass.getDeclaredMethod("createFilter", String.class);
            this.serializationFilter = this.createSerializationFilter(serializationFilterSpec, sanctionedClasses);
            this.usingJava8 = true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (this.filterInfoClass != null) {
                throw new GemFireConfigException("A serialization filter has been specified but Geode was unable to configure a filter", e);
            }
            return false;
        }
        return true;
    }

    private void createJava9Filter(String serializationFilterSpec, Collection<String> sanctionedClasses) {
        try {
            ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
            this.filterInfoClass = classPathLoader.forName("java.io.ObjectInputFilter$FilterInfo");
            this.serialClassMethod = this.filterInfoClass.getDeclaredMethod("serialClass", new Class[0]);
            this.filterClass = classPathLoader.forName("java.io.ObjectInputFilter");
            this.checkInputMethod = this.filterClass.getDeclaredMethod("checkInput", this.filterInfoClass);
            Class<?> statusClass = classPathLoader.forName("java.io.ObjectInputFilter$Status");
            this.ALLOWED = statusClass.getEnumConstants()[1];
            this.REJECTED = statusClass.getEnumConstants()[2];
            if (!this.ALLOWED.toString().equals("ALLOWED") || !this.REJECTED.toString().equals("REJECTED")) {
                throw new GemFireConfigException("ObjectInputFilter$Status enumeration in this JDK is not as expected");
            }
            this.configClass = classPathLoader.forName("java.io.ObjectInputFilter$Config");
            this.setObjectInputFilterMethod = ObjectInputStream.class.getDeclaredMethod("setObjectInputFilter", this.filterClass);
            this.createFilterMethod = this.configClass.getDeclaredMethod("createFilter", String.class);
            this.serializationFilter = this.createSerializationFilter(serializationFilterSpec, sanctionedClasses);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new GemFireConfigException("A serialization filter has been specified but Geode was unable to configure a filter", e);
        }
    }

    private Object createSerializationFilter(String serializationFilterSpec, Collection<String> sanctionedClasses) throws InvocationTargetException, IllegalAccessException {
        Object userFilter = this.createFilterMethod.invoke(null, serializationFilterSpec);
        InvocationHandler handler = (proxy, method, args) -> {
            switch (method.getName()) {
                case "checkInput": {
                    Object filterInfo = args[0];
                    Class serialClass = (Class)this.serialClassMethod.invoke(filterInfo, new Object[0]);
                    if (serialClass == null) {
                        return this.checkInputMethod.invoke(userFilter, filterInfo);
                    }
                    String className = serialClass.getName();
                    if (serialClass.isArray()) {
                        className = serialClass.getComponentType().getName();
                    }
                    if (sanctionedClasses.contains(className)) {
                        return this.ALLOWED;
                    }
                    Object status = this.checkInputMethod.invoke(userFilter, filterInfo);
                    if (status == this.REJECTED) {
                        logger.fatal("Serialization filter is rejecting class {}", (Object)className, (Object)new Exception(""));
                    }
                    return status;
                }
            }
            throw new UnsupportedOperationException("ObjectInputFilter." + method.getName() + " is not implemented");
        };
        ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
        return Proxy.newProxyInstance(classPathLoader.asClassLoader(), new Class[]{this.filterClass}, handler);
    }
}

