/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;

public final class ServerLoad
implements DataSerializable {
    private static final long serialVersionUID = -4498005291184650907L;
    private float connectionLoad;
    private float subscriberLoad;
    private float loadPerConnection;
    private float loadPerSubscriber;

    public ServerLoad(float connectionLoad, float loadPerConnection, float subscriptionConnectionLoad, float loadPerSubscriptionConnection) {
        this.connectionLoad = connectionLoad;
        this.subscriberLoad = subscriptionConnectionLoad;
        this.loadPerConnection = loadPerConnection;
        this.loadPerSubscriber = loadPerSubscriptionConnection;
    }

    public ServerLoad() {
    }

    public float getConnectionLoad() {
        return this.connectionLoad;
    }

    public float getLoadPerConnection() {
        return this.loadPerConnection;
    }

    public float getSubscriptionConnectionLoad() {
        return this.subscriberLoad;
    }

    public float getLoadPerSubscriptionConnection() {
        return this.loadPerSubscriber;
    }

    public void setConnectionLoad(float connectionLoad) {
        this.connectionLoad = connectionLoad;
    }

    public void setSubscriptionConnectionLoad(float subscriberLoad) {
        this.subscriberLoad = subscriberLoad;
    }

    public void setLoadPerConnection(float loadPerConnection) {
        this.loadPerConnection = loadPerConnection;
    }

    public void setLoadPerSubscriptionConnection(float loadPerSubscriber) {
        this.loadPerSubscriber = loadPerSubscriber;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeFloat(this.connectionLoad);
        out.writeFloat(this.loadPerConnection);
        out.writeFloat(this.subscriberLoad);
        out.writeFloat(this.loadPerSubscriber);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.connectionLoad = in.readFloat();
        this.loadPerConnection = in.readFloat();
        this.subscriberLoad = in.readFloat();
        this.loadPerSubscriber = in.readFloat();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.connectionLoad);
        result = 31 * result + Float.floatToIntBits(this.loadPerConnection);
        result = 31 * result + Float.floatToIntBits(this.loadPerSubscriber);
        result = 31 * result + Float.floatToIntBits(this.subscriberLoad);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerLoad other = (ServerLoad)obj;
        if (Float.floatToIntBits(this.connectionLoad) != Float.floatToIntBits(other.connectionLoad)) {
            return false;
        }
        if (Float.floatToIntBits(this.loadPerConnection) != Float.floatToIntBits(other.loadPerConnection)) {
            return false;
        }
        if (Float.floatToIntBits(this.loadPerSubscriber) != Float.floatToIntBits(other.loadPerSubscriber)) {
            return false;
        }
        return Float.floatToIntBits(this.subscriberLoad) == Float.floatToIntBits(other.subscriberLoad);
    }

    public String toString() {
        return "Load(" + this.connectionLoad + ", " + this.loadPerConnection + ", " + this.subscriberLoad + ", " + this.loadPerSubscriber + ")";
    }
}

