/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;

@Experimental
public class KeySetOperationHandler
implements ProtobufOperationHandler<RegionAPI.KeySetRequest, RegionAPI.KeySetResponse> {
    @Override
    public Result<RegionAPI.KeySetResponse> process(ProtobufSerializationService serializationService, RegionAPI.KeySetRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, EncodingException, DecodingException {
        String regionName = request.getRegionName();
        Set keySet = messageExecutionContext.getSecureCache().keySet(regionName);
        RegionAPI.KeySetResponse.Builder builder = RegionAPI.KeySetResponse.newBuilder();
        keySet.stream().map(serializationService::encode).forEach(arg_0 -> ((RegionAPI.KeySetResponse.Builder)builder).addKeys(arg_0));
        return Success.of(builder.build());
    }
}

