/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import java.util.Properties;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.distributed.Locator;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.protobuf.security.NoSecurity;
import org.apache.geode.internal.protocol.protobuf.security.NotLoggedInSecurity;
import org.apache.geode.internal.protocol.protobuf.security.SecureCache;
import org.apache.geode.internal.protocol.protobuf.security.SecureLocator;
import org.apache.geode.internal.protocol.protobuf.security.SecureLocatorImpl;
import org.apache.geode.internal.protocol.protobuf.security.Security;
import org.apache.geode.internal.protocol.protobuf.security.ShiroSecurity;
import org.apache.geode.internal.protocol.protobuf.statistics.ClientStatistics;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.state.TerminateConnection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.protocol.serialization.ValueSerializer;
import org.apache.shiro.subject.Subject;

@Experimental
public class LocatorMessageExecutionContext
extends MessageExecutionContext {
    private final Locator locator;
    private SecureLocator secureLocator;

    public LocatorMessageExecutionContext(Locator locator, ClientStatistics statistics, SecurityService securityService) {
        super(statistics, securityService);
        this.locator = locator;
        Security security = securityService.isIntegratedSecurity() ? new NotLoggedInSecurity() : new NoSecurity();
        this.secureLocator = new SecureLocatorImpl(locator, security);
    }

    @Override
    public SecureCache getSecureCache() throws InvalidExecutionContextException {
        this.setState(new TerminateConnection());
        throw new InvalidExecutionContextException("Operations on the locator should not to try to operate on a server");
    }

    @Override
    public SecureLocator getSecureLocator() throws InvalidExecutionContextException {
        return this.secureLocator;
    }

    @Override
    public void authenticate(Properties properties) {
        Subject subject = this.securityService.login(properties);
        this.secureLocator = new SecureLocatorImpl(this.locator, new ShiroSecurity(this.securityService, subject));
    }

    @Override
    public void setValueSerializer(ValueSerializer valueSerializer) {
    }
}

