/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.geode.ForcedDisconnectException;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.ParameterRequirements.RedisParametersMismatchException;
import org.apache.geode.redis.internal.RedisCommandType;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.data.RedisDataTypeMismatchException;
import org.apache.geode.redis.internal.executor.CommandFunction;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.UnknownExecutor;
import org.apache.geode.redis.internal.netty.Client;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.RedisCommandParserException;
import org.apache.geode.redis.internal.pubsub.PubSub;
import org.apache.geode.redis.internal.statistics.RedisStats;
import org.apache.logging.log4j.Logger;

public class ExecutionHandlerContext
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LogService.getLogger();
    private static final Command TERMINATE_COMMAND = new Command();
    private final Client client;
    private final Channel channel;
    private final RegionProvider regionProvider;
    private final PubSub pubsub;
    private final ByteBufAllocator byteBufAllocator;
    private final byte[] authPassword;
    private final Supplier<Boolean> allowUnsupportedSupplier;
    private final Runnable shutdownInvoker;
    private final RedisStats redisStats;
    private final EventLoopGroup subscriberGroup;
    private BigInteger scanCursor;
    private BigInteger sscanCursor;
    private int hscanCursor;
    private final AtomicBoolean channelInactive = new AtomicBoolean();
    private final int MAX_QUEUED_COMMANDS = Integer.getInteger("geode.redis.commandQueueSize", 1000);
    private final LinkedBlockingQueue<Command> commandQueue = new LinkedBlockingQueue(this.MAX_QUEUED_COMMANDS);
    private final int serverPort;
    private CountDownLatch eventLoopSwitched;
    private boolean isAuthenticated;

    public ExecutionHandlerContext(Channel channel, RegionProvider regionProvider, PubSub pubsub, Supplier<Boolean> allowUnsupportedSupplier, Runnable shutdownInvoker, RedisStats redisStats, ExecutorService backgroundExecutor, EventLoopGroup subscriberGroup, byte[] password, int serverPort) {
        this.channel = channel;
        this.regionProvider = regionProvider;
        this.pubsub = pubsub;
        this.allowUnsupportedSupplier = allowUnsupportedSupplier;
        this.shutdownInvoker = shutdownInvoker;
        this.redisStats = redisStats;
        this.subscriberGroup = subscriberGroup;
        this.client = new Client(channel);
        this.byteBufAllocator = this.channel.alloc();
        this.authPassword = password;
        this.isAuthenticated = password == null;
        this.serverPort = serverPort;
        this.scanCursor = new BigInteger("0");
        this.sscanCursor = new BigInteger("0");
        this.hscanCursor = 0;
        redisStats.addClient();
        backgroundExecutor.submit(this::processCommandQueue);
    }

    public ChannelFuture writeToChannel(RedisResponse response) {
        return this.channel.writeAndFlush(response.encode(this.byteBufAllocator), this.channel.newPromise()).addListener(f -> {
            response.afterWrite();
            this.logResponse(response, this.channel.remoteAddress().toString(), f.cause());
        });
    }

    private void processCommandQueue() {
        Command command;
        while ((command = this.takeCommandFromQueue()) != TERMINATE_COMMAND) {
            try {
                this.executeCommand(command);
                this.redisStats.incCommandsProcessed();
                continue;
            }
            catch (Throwable ex) {
                this.exceptionCaught(command.getChannelHandlerContext(), ex);
                continue;
            }
            break;
        }
        return;
    }

    private Command takeCommandFromQueue() {
        try {
            return this.commandQueue.take();
        }
        catch (InterruptedException e) {
            logger.info("Command queue thread interrupted");
            return TERMINATE_COMMAND;
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Command command = (Command)msg;
        command.setChannelHandlerContext(ctx);
        if (!this.channelInactive.get()) {
            this.commandQueue.put(command);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        RedisResponse exceptionResponse = this.getExceptionResponse(ctx, cause);
        if (exceptionResponse != null) {
            this.writeToChannel(exceptionResponse);
        }
    }

    public EventLoopGroup getSubscriberGroup() {
        return this.subscriberGroup;
    }

    public synchronized void changeChannelEventLoopGroup(EventLoopGroup newGroup, Consumer<Boolean> callback) {
        if (newGroup.equals(this.channel.eventLoop())) {
            callback.accept(true);
            return;
        }
        this.channel.deregister().addListener(future -> {
            boolean registerSuccess = true;
            Channel channel = this.channel;
            synchronized (channel) {
                if (!this.channel.isRegistered()) {
                    try {
                        newGroup.register(this.channel).sync();
                    }
                    catch (Exception e) {
                        logger.warn("Unable to register new EventLoopGroup: {}", (Object)e.getMessage());
                        registerSuccess = false;
                    }
                }
            }
            callback.accept(registerSuccess);
        });
    }

    private RedisResponse getExceptionResponse(ChannelHandlerContext ctx, Throwable cause) {
        RedisResponse response;
        Throwable th;
        if (cause instanceof IOException) {
            this.channelInactive(ctx);
            return null;
        }
        if (cause instanceof FunctionException && !(cause instanceof FunctionInvocationTargetException) && (th = CommandFunction.getInitialCause((FunctionException)cause)) != null) {
            cause = th;
        }
        if (cause instanceof NumberFormatException) {
            response = RedisResponse.error(cause.getMessage());
        } else if (cause instanceof ArithmeticException) {
            response = RedisResponse.error(cause.getMessage());
        } else if (cause instanceof RedisDataTypeMismatchException) {
            response = RedisResponse.wrongType(cause.getMessage());
        } else if (cause instanceof LowMemoryException) {
            response = RedisResponse.oom("command not allowed when used memory > 'maxmemory'");
        } else if (cause instanceof DecoderException && cause.getCause() instanceof RedisCommandParserException) {
            response = RedisResponse.error("The command received by GeodeRedisServer was improperly formatted");
        } else if (cause instanceof InterruptedException || cause instanceof CacheClosedException) {
            response = RedisResponse.error("The server is shutting down");
        } else if (cause instanceof IllegalStateException || cause instanceof RedisParametersMismatchException) {
            response = RedisResponse.error(cause.getMessage());
        } else if (cause instanceof FunctionInvocationTargetException || cause instanceof DistributedSystemDisconnectedException || cause instanceof ForcedDisconnectException) {
            logger.warn("Closing client connection because one of the servers doing this operation departed.");
            this.channelInactive(ctx);
            response = null;
        } else {
            if (logger.isErrorEnabled()) {
                logger.error("GeodeRedisServer-Unexpected error handler for " + ctx.channel(), cause);
            }
            response = RedisResponse.error("The server had an internal error please try again");
        }
        return response;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.channelInactive.compareAndSet(false, true)) {
            if (logger.isDebugEnabled()) {
                logger.debug("GeodeRedisServer-Connection closing with " + ctx.channel().remoteAddress());
            }
            this.commandQueue.clear();
            this.commandQueue.offer(TERMINATE_COMMAND);
            this.redisStats.removeClient();
            ctx.channel().close();
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(Command command) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Redis command: {} - {}", (Object)command, (Object)this.channel.remoteAddress().toString());
            }
            if (command.isUnknown()) {
                this.writeToChannel(command.execute(this));
                return;
            }
            if (!this.isAuthenticated()) {
                this.writeToChannel(this.handleUnAuthenticatedCommand(command));
                return;
            }
            if (command.isUnsupported() && !this.allowUnsupportedCommands()) {
                this.writeToChannel(new UnknownExecutor().executeCommand(command, this));
                return;
            }
            if (!this.getPubSub().findSubscriptionNames(this.getClient()).isEmpty() && !command.getCommandType().isAllowedWhileSubscribed()) {
                this.writeToChannel(RedisResponse.error("only (P)SUBSCRIBE / (P)UNSUBSCRIBE / PING / QUIT allowed in this context"));
            }
            long start = this.redisStats.startCommand();
            try {
                this.writeToChannel(command.execute(this));
            }
            finally {
                this.redisStats.endCommand(command.getCommandType(), start);
            }
            if (command.isOfType(RedisCommandType.QUIT)) {
                this.channelInactive(command.getChannelHandlerContext());
            }
        }
        catch (Exception e) {
            logger.warn("Execution of Redis command {} failed: {}", (Object)command, (Object)e);
            throw e;
        }
    }

    public boolean allowUnsupportedCommands() {
        return this.allowUnsupportedSupplier.get();
    }

    private RedisResponse handleUnAuthenticatedCommand(Command command) {
        RedisResponse response = command.isOfType(RedisCommandType.AUTH) ? command.execute(this) : RedisResponse.customError("NOAUTH Authentication required.");
        return response;
    }

    private void logResponse(RedisResponse response, String extraMessage, Throwable cause) {
        if (logger.isDebugEnabled() && response != null) {
            ByteBuf buf = response.encode(new UnpooledByteBufAllocator(false));
            if (cause == null) {
                logger.debug("Redis command returned: {} - {}", (Object)Command.getHexEncodedString(buf.array(), buf.readableBytes()), (Object)extraMessage);
            } else {
                logger.debug("Redis command FAILED to return: {} - {}", (Object)Command.getHexEncodedString(buf.array(), buf.readableBytes()), (Object)extraMessage, (Object)cause);
            }
        }
    }

    public ByteBufAllocator getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    public RegionProvider getRegionProvider() {
        return this.regionProvider;
    }

    public byte[] getAuthPassword() {
        return this.authPassword;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setAuthenticationVerified() {
        this.isAuthenticated = true;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public Client getClient() {
        return this.client;
    }

    public UUID getClientUUID() {
        return this.getClient().getId();
    }

    public void shutdown() {
        this.shutdownInvoker.run();
    }

    public PubSub getPubSub() {
        return this.pubsub;
    }

    public RedisStats getRedisStats() {
        return this.redisStats;
    }

    public BigInteger getScanCursor() {
        return this.scanCursor;
    }

    public void setScanCursor(BigInteger scanCursor) {
        this.scanCursor = scanCursor;
    }

    public BigInteger getSscanCursor() {
        return this.sscanCursor;
    }

    public void setSscanCursor(BigInteger sscanCursor) {
        this.sscanCursor = sscanCursor;
    }

    public int getHscanCursor() {
        return this.hscanCursor;
    }

    public void setHscanCursor(int hscanCursor) {
        this.hscanCursor = hscanCursor;
    }

    public CountDownLatch getOrCreateEventLoopLatch() {
        if (this.eventLoopSwitched != null) {
            return this.eventLoopSwitched;
        }
        this.eventLoopSwitched = new CountDownLatch(1);
        return this.eventLoopSwitched;
    }

    public void eventLoopReady() {
        if (this.eventLoopSwitched == null) {
            return;
        }
        try {
            this.eventLoopSwitched.await();
        }
        catch (InterruptedException e) {
            logger.info("Event loop interrupted", (Throwable)e);
        }
    }
}

