/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.string.RedisStringCommands;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class SetBitExecutor
extends StringExecutor {
    private static final String ERROR_NOT_INT = "The number provided must be numeric";
    private static final String ERROR_VALUE = "The value is out of range, must be 0 or 1";
    private static final String ERROR_ILLEGAL_OFFSET = "The offset is out of range, must be greater than or equal to 0  and at most 4294967295 (512MB)";

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        int value;
        long offset;
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisStringCommands stringCommands = this.getRedisStringCommands(context);
        RedisKey key = command.getKey();
        try {
            byte[] offAr = commandElems.get(2);
            byte[] valAr = commandElems.get(3);
            offset = Coder.bytesToLong(offAr);
            value = Coder.bytesToInt(valAr);
        }
        catch (NumberFormatException e) {
            return RedisResponse.error(ERROR_NOT_INT);
        }
        if (value != 0 && value != 1) {
            return RedisResponse.error(ERROR_VALUE);
        }
        if (offset < 0L || offset > 0xFFFFFFFFL) {
            return RedisResponse.error(ERROR_ILLEGAL_OFFSET);
        }
        int returnBit = stringCommands.setbit(key, offset, value);
        return RedisResponse.integer(returnBit);
    }
}

