/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.pubsub;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.geode.redis.internal.pubsub.SubscribeResult;

public class PsubscribeExecutor
extends AbstractExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        SubscribeResult result;
        Object patternBytes;
        context.eventLoopReady();
        ArrayList<SubscribeResult> results = new ArrayList<SubscribeResult>();
        for (int i = 1; i < command.getProcessedCommand().size(); ++i) {
            patternBytes = command.getProcessedCommand().get(i);
            result = context.getPubSub().psubscribe((byte[])patternBytes, context, context.getClient());
            results.add(result);
        }
        ArrayList items = new ArrayList();
        patternBytes = results.iterator();
        while (patternBytes.hasNext()) {
            result = (SubscribeResult)patternBytes.next();
            ArrayList<Object> item = new ArrayList<Object>();
            item.add("psubscribe");
            item.add(result.getChannel());
            item.add(result.getChannelCount());
            items.add(item);
        }
        CountDownLatch subscriberLatch = context.getOrCreateEventLoopLatch();
        Runnable callback = () -> {
            Consumer<Boolean> innerCallback = success -> {
                for (SubscribeResult result : results) {
                    if (result.getSubscription() == null) continue;
                    if (success.booleanValue()) {
                        result.getSubscription().readyToPublish();
                        continue;
                    }
                    result.getSubscription().shutdown();
                }
                subscriberLatch.countDown();
            };
            context.changeChannelEventLoopGroup(context.getSubscriberGroup(), innerCallback);
        };
        RedisResponse response = RedisResponse.flattenedArray(items);
        response.setAfterWriteCallback(callback);
        return response;
    }
}

