/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.CoderException;

public class RedisResponse {
    private final Function<ByteBuf, ByteBuf> coderCallback;
    private Runnable afterWriteCallback;

    private RedisResponse(Function<ByteBuf, ByteBuf> coderCallback) {
        this.coderCallback = coderCallback;
    }

    public void setAfterWriteCallback(Runnable callback) {
        this.afterWriteCallback = callback;
    }

    public void afterWrite() {
        if (this.afterWriteCallback != null) {
            this.afterWriteCallback.run();
        }
    }

    public ByteBuf encode(ByteBufAllocator allocator) {
        return this.coderCallback.apply(allocator.buffer());
    }

    public static RedisResponse integer(long numericValue) {
        return new RedisResponse(buffer -> Coder.getIntegerResponse(buffer, numericValue));
    }

    public static RedisResponse integer(boolean exists) {
        return new RedisResponse(buffer -> Coder.getIntegerResponse(buffer, exists ? 1 : 0));
    }

    public static RedisResponse string(String stringValue) {
        return new RedisResponse(buffer -> Coder.getSimpleStringResponse(buffer, stringValue));
    }

    public static RedisResponse string(byte[] byteArray) {
        return new RedisResponse(buffer -> Coder.getSimpleStringResponse(buffer, byteArray));
    }

    public static RedisResponse bulkString(Object value) {
        return new RedisResponse(buffer -> {
            try {
                return Coder.getBulkStringResponse(buffer, value);
            }
            catch (CoderException e) {
                return Coder.getErrorResponse(buffer, "Internal server error: " + e.getMessage());
            }
        });
    }

    public static RedisResponse ok() {
        return new RedisResponse(buffer -> Coder.getSimpleStringResponse(buffer, "OK"));
    }

    public static RedisResponse nil() {
        return new RedisResponse(Coder::getNilResponse);
    }

    public static RedisResponse flattenedArray(Collection<Collection<?>> nestedCollection) {
        return new RedisResponse(buffer -> {
            try {
                return Coder.getFlattenedArrayResponse(buffer, nestedCollection);
            }
            catch (CoderException e) {
                return Coder.getErrorResponse(buffer, "Internal server error: " + e.getMessage());
            }
        });
    }

    public static RedisResponse array(Collection<?> collection) {
        return new RedisResponse(buffer -> {
            try {
                return Coder.getArrayResponse(buffer, collection);
            }
            catch (CoderException e) {
                return Coder.getErrorResponse(buffer, "Internal server error: " + e.getMessage());
            }
        });
    }

    public static RedisResponse emptyArray() {
        return new RedisResponse(Coder::getEmptyArrayResponse);
    }

    public static RedisResponse emptyString() {
        return new RedisResponse(Coder::getEmptyStringResponse);
    }

    public static RedisResponse error(String error) {
        return new RedisResponse(buffer -> Coder.getErrorResponse(buffer, error));
    }

    public static RedisResponse oom(String error) {
        return new RedisResponse(bba -> Coder.getOOMResponse(bba, error));
    }

    public static RedisResponse customError(String error) {
        return new RedisResponse(buffer -> Coder.getCustomErrorResponse(buffer, error));
    }

    public static RedisResponse wrongType(String error) {
        return new RedisResponse(buffer -> Coder.getWrongTypeResponse(buffer, error));
    }

    public static RedisResponse scan(BigInteger cursor, List<Object> scanResult) {
        return new RedisResponse(buffer -> Coder.getScanResponse(buffer, cursor, scanResult));
    }

    public static RedisResponse emptyScan() {
        return RedisResponse.scan(new BigInteger("0"), new ArrayList<Object>());
    }

    public String toString() {
        return this.encode(new UnpooledByteBufAllocator(false)).toString(Charset.defaultCharset());
    }

    public static RedisResponse bigDecimal(BigDecimal numericValue) {
        return new RedisResponse(buffer -> Coder.getBigDecimalResponse(buffer, numericValue));
    }
}

