/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.redis.internal.RedisCommandType;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.CommandHelper;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisHashCommandsFunctionExecutor;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.data.RedisKeyCommandsFunctionExecutor;
import org.apache.geode.redis.internal.data.RedisSetCommandsFunctionExecutor;
import org.apache.geode.redis.internal.data.RedisStringCommandsFunctionExecutor;
import org.apache.geode.redis.internal.executor.SingleResultRedisFunction;
import org.apache.geode.redis.internal.executor.StripedExecutor;
import org.apache.geode.redis.internal.executor.string.SetOptions;
import org.apache.geode.redis.internal.statistics.RedisStats;

public class CommandFunction
extends SingleResultRedisFunction {
    public static final String ID = "REDIS_COMMAND_FUNCTION";
    private static final long serialVersionUID = -1302506316316454732L;
    private final transient RedisKeyCommandsFunctionExecutor keyCommands;
    private final transient RedisHashCommandsFunctionExecutor hashCommands;
    private final transient RedisSetCommandsFunctionExecutor setCommands;
    private final transient RedisStringCommandsFunctionExecutor stringCommands;

    public static void register(Region<RedisKey, RedisData> dataRegion, StripedExecutor stripedExecutor, RedisStats redisStats) {
        FunctionService.registerFunction((Function)new CommandFunction(dataRegion, stripedExecutor, redisStats));
    }

    public static Throwable getInitialCause(FunctionException ex) {
        Throwable result;
        for (result = ex.getCause(); result != null && result.getCause() != null; result = result.getCause()) {
        }
        if (result == null && !ex.getExceptions().isEmpty()) {
            result = (Throwable)ex.getExceptions().get(0);
        }
        return result;
    }

    public CommandFunction(Region<RedisKey, RedisData> dataRegion, StripedExecutor stripedExecutor, RedisStats redisStats) {
        super(dataRegion);
        CommandHelper helper = new CommandHelper(dataRegion, redisStats, stripedExecutor);
        this.keyCommands = new RedisKeyCommandsFunctionExecutor(helper);
        this.hashCommands = new RedisHashCommandsFunctionExecutor(helper);
        this.setCommands = new RedisSetCommandsFunctionExecutor(helper);
        this.stringCommands = new RedisStringCommandsFunctionExecutor(helper);
    }

    public String getId() {
        return ID;
    }

    @Override
    protected Object compute(RedisKey key, Object[] args) {
        RedisCommandType command = (RedisCommandType)((Object)args[0]);
        switch (command) {
            case DEL: {
                return this.keyCommands.del(key);
            }
            case EXISTS: {
                return this.keyCommands.exists(key);
            }
            case TYPE: {
                return this.keyCommands.type(key);
            }
            case INTERNALTYPE: {
                return this.keyCommands.internalType(key);
            }
            case PEXPIREAT: {
                long timestamp = (Long)args[1];
                return this.keyCommands.pexpireat(key, timestamp);
            }
            case PERSIST: {
                return this.keyCommands.persist(key);
            }
            case PTTL: {
                return this.keyCommands.pttl(key);
            }
            case INTERNALPTTL: {
                return this.keyCommands.internalPttl(key);
            }
            case APPEND: {
                ByteArrayWrapper valueToAdd = (ByteArrayWrapper)args[1];
                return this.stringCommands.append(key, valueToAdd);
            }
            case GET: {
                return this.stringCommands.get(key);
            }
            case MGET: {
                return this.stringCommands.mget(key);
            }
            case STRLEN: {
                return this.stringCommands.strlen(key);
            }
            case SET: {
                ByteArrayWrapper value = (ByteArrayWrapper)args[1];
                SetOptions options = (SetOptions)args[2];
                return this.stringCommands.set(key, value, options);
            }
            case GETSET: {
                ByteArrayWrapper value = (ByteArrayWrapper)args[1];
                return this.stringCommands.getset(key, value);
            }
            case GETRANGE: {
                long start = (Long)args[1];
                long end = (Long)args[2];
                return this.stringCommands.getrange(key, start, end);
            }
            case SETRANGE: {
                int offset = (Integer)args[1];
                byte[] value = (byte[])args[2];
                return this.stringCommands.setrange(key, offset, value);
            }
            case BITCOUNT: {
                if (args.length == 1) {
                    return this.stringCommands.bitcount(key);
                }
                int start = (Integer)args[1];
                int end = (Integer)args[2];
                return this.stringCommands.bitcount(key, start, end);
            }
            case BITPOS: {
                int bit = (Integer)args[1];
                int start = (Integer)args[2];
                Integer end = (Integer)args[3];
                return this.stringCommands.bitpos(key, bit, start, end);
            }
            case GETBIT: {
                int offset = (Integer)args[1];
                return this.stringCommands.getbit(key, offset);
            }
            case SETBIT: {
                long offset = (Long)args[1];
                int value = (Integer)args[2];
                return this.stringCommands.setbit(key, offset, value);
            }
            case BITOP: {
                String operation = (String)args[1];
                List sources = (List)args[2];
                return this.stringCommands.bitop(operation, key, sources);
            }
            case INCR: {
                return this.stringCommands.incr(key);
            }
            case DECR: {
                return this.stringCommands.decr(key);
            }
            case INCRBY: {
                long increment = (Long)args[1];
                return this.stringCommands.incrby(key, increment);
            }
            case INCRBYFLOAT: {
                BigDecimal increment = (BigDecimal)args[1];
                return this.stringCommands.incrbyfloat(key, increment);
            }
            case DECRBY: {
                long decrement = (Long)args[1];
                return this.stringCommands.decrby(key, decrement);
            }
            case SADD: {
                ArrayList membersToAdd = (ArrayList)args[1];
                return this.setCommands.sadd(key, membersToAdd);
            }
            case SREM: {
                ArrayList membersToRemove = (ArrayList)args[1];
                return this.setCommands.srem(key, membersToRemove);
            }
            case SMEMBERS: {
                return this.setCommands.smembers(key);
            }
            case INTERNALSMEMBERS: {
                return this.setCommands.internalsmembers(key);
            }
            case SCARD: {
                return this.setCommands.scard(key);
            }
            case SISMEMBER: {
                ByteArrayWrapper member = (ByteArrayWrapper)args[1];
                return this.setCommands.sismember(key, member);
            }
            case SRANDMEMBER: {
                int count = (Integer)args[1];
                return this.setCommands.srandmember(key, count);
            }
            case SPOP: {
                int popCount = (Integer)args[1];
                return this.setCommands.spop(key, popCount);
            }
            case SSCAN: {
                Pattern matchPattern = (Pattern)args[1];
                int count = (Integer)args[2];
                BigInteger cursor = (BigInteger)args[3];
                return this.setCommands.sscan(key, matchPattern, count, cursor);
            }
            case SUNIONSTORE: {
                ArrayList setKeys = (ArrayList)args[1];
                return this.setCommands.sunionstore(key, setKeys);
            }
            case SINTERSTORE: {
                ArrayList setKeys = (ArrayList)args[1];
                return this.setCommands.sinterstore(key, setKeys);
            }
            case SDIFFSTORE: {
                ArrayList setKeys = (ArrayList)args[1];
                return this.setCommands.sdiffstore(key, setKeys);
            }
            case HSET: {
                List fieldsToSet = (List)args[1];
                boolean NX = (Boolean)args[2];
                return this.hashCommands.hset(key, fieldsToSet, NX);
            }
            case HDEL: {
                List fieldsToRemove = (List)args[1];
                return this.hashCommands.hdel(key, fieldsToRemove);
            }
            case HGETALL: {
                return this.hashCommands.hgetall(key);
            }
            case HEXISTS: {
                ByteArrayWrapper field = (ByteArrayWrapper)args[1];
                return this.hashCommands.hexists(key, field);
            }
            case HGET: {
                ByteArrayWrapper field = (ByteArrayWrapper)args[1];
                return this.hashCommands.hget(key, field);
            }
            case HLEN: {
                return this.hashCommands.hlen(key);
            }
            case HSTRLEN: {
                ByteArrayWrapper field = (ByteArrayWrapper)args[1];
                return this.hashCommands.hstrlen(key, field);
            }
            case HMGET: {
                List fields = (List)args[1];
                return this.hashCommands.hmget(key, fields);
            }
            case HVALS: {
                return this.hashCommands.hvals(key);
            }
            case HKEYS: {
                return this.hashCommands.hkeys(key);
            }
            case HSCAN: {
                Pattern pattern = (Pattern)args[1];
                int count = (Integer)args[2];
                int cursor = (Integer)args[3];
                UUID clientID = (UUID)args[4];
                return this.hashCommands.hscan(key, pattern, count, cursor, clientID);
            }
            case HINCRBY: {
                ByteArrayWrapper field = (ByteArrayWrapper)args[1];
                long increment = (Long)args[2];
                return this.hashCommands.hincrby(key, field, increment);
            }
            case HINCRBYFLOAT: {
                ByteArrayWrapper field = (ByteArrayWrapper)args[1];
                BigDecimal increment = (BigDecimal)args[2];
                return this.hashCommands.hincrbyfloat(key, field, increment);
            }
        }
        throw new UnsupportedOperationException("REDIS_COMMAND_FUNCTION does not yet support " + (Object)((Object)command));
    }
}

