/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/storage/file/DataOutputStream.as
 * org.apache.flex.storage.file.DataOutputStream
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.storage.file.DataOutputStream');

goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.storage.events.FileErrorEvent');
goog.require('org.apache.flex.storage.events.FileEvent');
goog.require('org.apache.flex.storage.file.IDataOutput');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 * 
 *  @asparam target The object to as the event dispatch target.
 *  @asparam fileHandle A reference to a platform-specific file object.
 *  @asparam fileWriter A reference to a platform-specific file object.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.storage.file.IDataOutput}
 * @param {org.apache.flex.events.IEventDispatcher} target
 * @param {Object} fileHandle
 * @param {Object} fileWriter
 */
org.apache.flex.storage.file.DataOutputStream = function(target, fileHandle, fileWriter) {
  var self = this;
  var /** @type {Function} */ __localFn0__ = function(e) {
    var /** @type {org.apache.flex.storage.events.FileEvent} */ newEvent = new org.apache.flex.storage.events.FileEvent("WRITE");
    newEvent.stream = self;
    self._target.dispatchEvent(newEvent);
  }
  var /** @type {Function} */ __localFn1__ = function(e) {
    var /** @type {org.apache.flex.storage.events.FileErrorEvent} */ newEvent = new org.apache.flex.storage.events.FileErrorEvent("ERROR");
    newEvent.stream = self;
    newEvent.errorMessage = "Failed to write the file.";
    self._target.dispatchEvent(newEvent);
  }
  org.apache.flex.storage.file.DataOutputStream.base(this, 'constructor');
  this._target = target;
  this._fileHandle = org.apache.flex.utils.Language.as(fileHandle, FileEntry);
  this._fileWriter = org.apache.flex.utils.Language.as(fileWriter, FileWriter);
  var /** @type {org.apache.flex.storage.file.DataOutputStream} */ self = this;
  this._fileWriter.onwriteend = __localFn0__;
  this._fileWriter.onerror = __localFn1__;
  this._fileWriter.truncate(0);
  
};
goog.inherits(org.apache.flex.storage.file.DataOutputStream, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.events.IEventDispatcher}
 */
org.apache.flex.storage.file.DataOutputStream.prototype._target;


/**
 * Writes a chunk of text into the file. When the file is ready to accept the nex
 * chunk, a FileEvent "WRITE" event is dispatched.
 * 
 *  @asparam text The string to write into the file.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} text
 */
org.apache.flex.storage.file.DataOutputStream.prototype.writeText = function(text) {
  var /** @type {Blob} */ blob = new Blob([text], {type:'text/plain'});
  this._fileWriter.write(blob);
  
};


/**
 * Closes the file and dispatches a FileEvent "COMPLETE" event.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.storage.file.DataOutputStream.prototype.close = function() {
  
  var /** @type {org.apache.flex.storage.events.FileEvent} */ newEvent = new org.apache.flex.storage.events.FileEvent("COMPLETE");
  newEvent.stream = this;
  this._target.dispatchEvent(newEvent);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.storage.file.DataOutputStream.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DataOutputStream', qName: 'org.apache.flex.storage.file.DataOutputStream'}], interfaces: [org.apache.flex.storage.file.IDataOutput] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.storage.file.DataOutputStream', org.apache.flex.storage.file.DataOutputStream);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.storage.file.DataOutputStream.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'DataOutputStream': { type: '', declaredBy: 'org.apache.flex.storage.file.DataOutputStream'},
        'writeText': { type: 'void', declaredBy: 'org.apache.flex.storage.file.DataOutputStream'},
        'close': { type: 'void', declaredBy: 'org.apache.flex.storage.file.DataOutputStream'}
      };
    }
  };
};