/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/beads/StackedViewManagerView.as
 * org.apache.flex.mobile.beads.StackedViewManagerView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.beads.StackedViewManagerView');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.beads.layouts.HorizontalLayout');
goog.require('org.apache.flex.mobile.beads.ViewManagerViewBase');
goog.require('org.apache.flex.mobile.chrome.ToolBar');
goog.require('org.apache.flex.mobile.models.ViewManagerModel');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.mobile.beads.ViewManagerViewBase}
 */
org.apache.flex.mobile.beads.StackedViewManagerView = function() {
  org.apache.flex.mobile.beads.StackedViewManagerView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.mobile.beads.StackedViewManagerView, org.apache.flex.mobile.beads.ViewManagerViewBase);


/**
 * @private
 * @type {org.apache.flex.mobile.chrome.ToolBar}
 */
org.apache.flex.mobile.beads.StackedViewManagerView.prototype._toolBar;


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.flex.mobile.beads.StackedViewManagerView.prototype.layoutChromeElements = function() {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this.strand, org.apache.flex.core.UIBase);
  var /** @type {number} */ contentAreaY = 0;
  var /** @type {number} */ contentAreaHeight = host.height;
  var /** @type {number} */ toolbarHeight = this._toolBar == null ? 0 : this._toolBar.height;
  var /** @type {org.apache.flex.mobile.models.ViewManagerModel} */ model = org.apache.flex.utils.Language.as(this.strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.mobile.models.ViewManagerModel);
  if (this.navigationBar) {
    this.navigationBar.x = 0;
    this.navigationBar.y = 0;
    this.navigationBar.width = host.width;
    contentAreaHeight -= this.navigationBar.height;
    contentAreaY = this.navigationBar.height;
    model.navigationBar = this.navigationBar;
  }
  if (this._toolBar) {
    this._toolBar.x = 0;
    this._toolBar.y = host.height - toolbarHeight;
    this._toolBar.width = host.width;
    contentAreaHeight -= toolbarHeight;
    model.toolBar = this._toolBar;
  }
  if (contentAreaY < 0)
    contentAreaY = 0;
  if (contentAreaHeight < 0)
    contentAreaHeight = 0;
  model.contentX = 0;
  model.contentY = contentAreaY;
  model.contentWidth = host.width;
  model.contentHeight = contentAreaHeight;
  this.sizeViewsToFitContentArea();
  org.apache.flex.utils.Language.as(this.strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("contentSizeChanged"));
};


Object.defineProperties(org.apache.flex.mobile.beads.StackedViewManagerView.prototype, /** @lends {org.apache.flex.mobile.beads.StackedViewManagerView.prototype} */ {
/** @export */
strand: {
get: /** @this {org.apache.flex.mobile.beads.StackedViewManagerView} */ function() {
  return org.apache.flex.utils.Language.superGetter(org.apache.flex.mobile.beads.StackedViewManagerView, this, 'strand');
},
set: /** @this {org.apache.flex.mobile.beads.StackedViewManagerView} */ function(value) {
  var /** @type {org.apache.flex.mobile.models.ViewManagerModel} */ model = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.mobile.models.ViewManagerModel);
  if (model.toolBarItems) {
    this._toolBar = new org.apache.flex.mobile.chrome.ToolBar();
    this._toolBar.controls = model.toolBarItems;
    this._toolBar.addBead(new org.apache.flex.html.beads.layouts.HorizontalLayout());
    org.apache.flex.utils.Language.as(value, org.apache.flex.core.UIBase, true).addElement(this._toolBar, false);
  }
  org.apache.flex.utils.Language.superSetter(org.apache.flex.mobile.beads.StackedViewManagerView, this, 'strand', value);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.beads.StackedViewManagerView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'StackedViewManagerView', qName: 'org.apache.flex.mobile.beads.StackedViewManagerView'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.beads.StackedViewManagerView', org.apache.flex.mobile.beads.StackedViewManagerView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.beads.StackedViewManagerView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.mobile.beads.StackedViewManagerView'}
      };
    },
    methods: function () {
      return {
        'StackedViewManagerView': { type: '', declaredBy: 'org.apache.flex.mobile.beads.StackedViewManagerView'}
      };
    }
  };
};