/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/supportClasses/UIItemRendererBase.as
 * org.apache.flex.html.supportClasses.UIItemRendererBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.supportClasses.UIItemRendererBase');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.utils.MXMLDataInterpreter');
goog.require('org.apache.flex.core.ISelectableItemRenderer');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 * @implements {org.apache.flex.core.ISelectableItemRenderer}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase = function() {
  org.apache.flex.html.supportClasses.UIItemRendererBase.base(this, 'constructor');

this.useColor = this.backgroundColor;
};
goog.inherits(org.apache.flex.html.supportClasses.UIItemRendererBase, org.apache.flex.core.UIBase);


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.addedToParent = function() {
  org.apache.flex.html.supportClasses.UIItemRendererBase.base(this, 'addedToParent');
  this.addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.sizeChangeHandler, this, 'sizeChangeHandler'));
  this.addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.sizeChangeHandler, this, 'sizeChangeHandler'));
  this.addEventListener("sizeChanged", org.apache.flex.utils.Language.closure(this.sizeChangeHandler, this, 'sizeChangeHandler'));
  org.apache.flex.core.ValuesManager.valuesImpl.init(this);
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLProperties(this, this.mxmlProperties);
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLInstances(this, this, this.MXMLDescriptor);
  this.dispatchEvent(new org.apache.flex.events.Event("initBindings"));
  this.dispatchEvent(new org.apache.flex.events.Event("initComplete"));
};


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype._itemRendererParent;


/**
 * @export
 * @type {Array}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.mxmlContent;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.mxmlProperties;


/**
 * @asprivate
 * @export
 * @param {Array} data
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.generateMXMLAttributes = function(data) {
  this.mxmlProperties = data;
};


/**
 * @export
 * @type {number}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.backgroundColor = 0xFFFFFF;


/**
 * @export
 * @type {number}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.highlightColor = 0xCEDBEF;


/**
 * @export
 * @type {number}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.selectedColor = 0xA8C6EE;


/**
 * @export
 * @type {number}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.downColor = 0x808080;


/**
 * @protected
 * @type {number}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.useColor;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype._data;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype._listData;


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype._labelField = "label";


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype._index;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype._hovered;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype._selected;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype._down;


/**
 * @asprivate
 * @export
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.updateRenderer = function() {
  if (this.down)
    this.useColor = this.downColor;
  else if (this.hovered)
    this.useColor = this.highlightColor;
  else if (this.selected)
    this.useColor = this.selectedColor;
  else
    this.useColor = this.backgroundColor;
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.sizeChangeHandler = function(event) {
  this.adjustSize();
};


/**
 *  This function is called whenever the itemRenderer changes size. Sub-classes should override
 *  this method an handle the size change.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.adjustSize = function() {
};


Object.defineProperties(org.apache.flex.html.supportClasses.UIItemRendererBase.prototype, /** @lends {org.apache.flex.html.supportClasses.UIItemRendererBase.prototype} */ {
/** @export */
itemRendererParent: {
get: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function() {
  return this._itemRendererParent;
},
set: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function(value) {
  this._itemRendererParent = value;
}},
/** @export */
MXMLDescriptor: {
get: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function() {
  return null;
}},
/** @export */
data: {
get: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function() {
  return this._data;
},
set: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function(value) {
  this._data = value;
}},
/** @export */
listData: {
get: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function() {
  return this._listData;
},
set: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function(value) {
  this._listData = value;
}},
/** @export */
labelField: {
get: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function() {
  return this._labelField;
},
set: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function(value) {
  this._labelField = value;
}},
/** @export */
index: {
get: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function() {
  return this._index;
},
set: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function(value) {
  this._index = value;
}},
/** @export */
hovered: {
get: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function() {
  return this._hovered;
},
set: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function(value) {
  this._hovered = value;
  this.updateRenderer();
}},
/** @export */
selected: {
get: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function() {
  return this._selected;
},
set: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function(value) {
  this._selected = value;
  this.updateRenderer();
}},
/** @export */
down: {
get: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function() {
  return this._down;
},
set: /** @this {org.apache.flex.html.supportClasses.UIItemRendererBase} */ function(value) {
  this._down = value;
  this.updateRenderer();
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'UIItemRendererBase', qName: 'org.apache.flex.html.supportClasses.UIItemRendererBase'}], interfaces: [org.apache.flex.core.ISelectableItemRenderer] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.supportClasses.UIItemRendererBase', org.apache.flex.html.supportClasses.UIItemRendererBase);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.supportClasses.UIItemRendererBase.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'mxmlContent': { type: 'Array'},
        'backgroundColor': { type: 'uint'},
        'highlightColor': { type: 'uint'},
        'selectedColor': { type: 'uint'},
        'downColor': { type: 'uint'}
      };
    },
    accessors: function () {
      return {
        'itemRendererParent': { type: 'Object', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'},
        'MXMLDescriptor': { type: 'Array', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'},
        'data': { type: 'Object', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: '__NoChangeEvent__'}]}]; }},
        'listData': { type: 'Object', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: '__NoChangeEvent__'}]}]; }},
        'labelField': { type: 'String', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'},
        'index': { type: 'int', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'},
        'hovered': { type: 'Boolean', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'},
        'selected': { type: 'Boolean', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'},
        'down': { type: 'Boolean', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'}
      };
    },
    methods: function () {
      return {
        'UIItemRendererBase': { type: '', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'},
        'generateMXMLAttributes': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'},
        'updateRenderer': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'},
        'adjustSize': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.UIItemRendererBase'}
      };
    },
    metadata: function () { return [ ]; }
  };
};