/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/supportClasses/DataGroup.as
 * org.apache.flex.html.supportClasses.DataGroup
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.supportClasses.DataGroup');

goog.require('org.apache.flex.events.ItemAddedEvent');
goog.require('org.apache.flex.events.ItemRemovedEvent');
goog.require('org.apache.flex.html.supportClasses.ContainerContentArea');
goog.require('org.apache.flex.html.supportClasses.DataItemRenderer');
goog.require('org.apache.flex.core.IContentView');
goog.require('org.apache.flex.core.IItemRenderer');
goog.require('org.apache.flex.core.IItemRendererParent');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.supportClasses.ContainerContentArea}
 * @implements {org.apache.flex.core.IItemRendererParent}
 * @implements {org.apache.flex.core.IContentView}
 */
org.apache.flex.html.supportClasses.DataGroup = function() {
  org.apache.flex.html.supportClasses.DataGroup.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.supportClasses.DataGroup, org.apache.flex.html.supportClasses.ContainerContentArea);


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.html.supportClasses.DataGroup.prototype.addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  org.apache.flex.html.supportClasses.DataGroup.base(this, 'addElement', c, dispatchEvent);
  var /** @type {org.apache.flex.events.ItemAddedEvent} */ newEvent = new org.apache.flex.events.ItemAddedEvent("itemAdded");
  newEvent.item = c;
  var /** @type {org.apache.flex.events.IEventDispatcher} */ strand = org.apache.flex.utils.Language.as(this.parent, org.apache.flex.events.IEventDispatcher);
  strand.dispatchEvent(newEvent);
};


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.html.supportClasses.DataGroup.prototype.removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  org.apache.flex.html.supportClasses.DataGroup.base(this, 'removeElement', c, dispatchEvent);
  var /** @type {org.apache.flex.events.ItemRemovedEvent} */ newEvent = new org.apache.flex.events.ItemRemovedEvent("itemRemoved");
  newEvent.item = c;
  var /** @type {org.apache.flex.events.IEventDispatcher} */ strand = org.apache.flex.utils.Language.as(this.parent, org.apache.flex.events.IEventDispatcher);
  strand.dispatchEvent(newEvent);
};


/**
 *  @copy org.apache.flex.core.IItemRendererParent#getItemRendererForIndex()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} index
 * @return {org.apache.flex.core.IItemRenderer}
 */
org.apache.flex.html.supportClasses.DataGroup.prototype.getItemRendererForIndex = function(index) {
  if (index < 0 || index >= this.numElements)
    return null;
  return org.apache.flex.utils.Language.as(this.getElementAt(index), org.apache.flex.core.IItemRenderer);
};


/**
 *  Refreshes the itemRenderers. Useful after a size change by the data group.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.html.supportClasses.DataGroup.prototype.updateAllItemRenderers = function() {
  var /** @type {number} */ n = this.numElements;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.html.supportClasses.DataItemRenderer} */ renderer = org.apache.flex.utils.Language.as(this.getItemRendererForIndex(i), org.apache.flex.html.supportClasses.DataItemRenderer);
    if (renderer) {
      renderer.setWidth(this.width, true);
      renderer.adjustSize();
    }
  }
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.supportClasses.DataGroup.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DataGroup', qName: 'org.apache.flex.html.supportClasses.DataGroup'}], interfaces: [org.apache.flex.core.IItemRendererParent, org.apache.flex.core.IContentView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.supportClasses.DataGroup', org.apache.flex.html.supportClasses.DataGroup);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.supportClasses.DataGroup.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'DataGroup': { type: '', declaredBy: 'org.apache.flex.html.supportClasses.DataGroup'},
        'addElement': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.DataGroup'},
        'removeElement': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.DataGroup'},
        'getItemRendererForIndex': { type: 'IItemRenderer', declaredBy: 'org.apache.flex.html.supportClasses.DataGroup'},
        'updateAllItemRenderers': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.DataGroup'}
      };
    }
  };
};