/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/models/RangeModelExtended.as
 * org.apache.flex.html.beads.models.RangeModelExtended
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.models.RangeModelExtended');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.beads.models.RangeModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.beads.models.RangeModel}
 */
org.apache.flex.html.beads.models.RangeModelExtended = function() {
  org.apache.flex.html.beads.models.RangeModelExtended.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.models.RangeModelExtended, org.apache.flex.html.beads.models.RangeModel);


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.models.RangeModelExtended.prototype._value = 0;


/**
 * @private
 * @type {Function}
 */
org.apache.flex.html.beads.models.RangeModelExtended.prototype._labelFunction;


/**
 *  Returns the label, using the labelFunction (if provided) for the value
 *  at the given index.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} index
 * @return {string}
 */
org.apache.flex.html.beads.models.RangeModelExtended.prototype.getLabelForIndex = function(index) {
  if (this._labelFunction != null) {
    return this._labelFunction(this, index);
  } else {
    return "";
  }
};


Object.defineProperties(org.apache.flex.html.beads.models.RangeModelExtended.prototype, /** @lends {org.apache.flex.html.beads.models.RangeModelExtended.prototype} */ {
/** @export */
value: {
get: /** @this {org.apache.flex.html.beads.models.RangeModelExtended} */ function() {
  return this._value;
},
set: /** @this {org.apache.flex.html.beads.models.RangeModelExtended} */ function(newValue) {
  this._value = newValue;
  this.dispatchEvent(new org.apache.flex.events.Event("valueChange"));
}},
/** @export */
labelFunction: {
get: /** @this {org.apache.flex.html.beads.models.RangeModelExtended} */ function() {
  return this._labelFunction;
},
set: /** @this {org.apache.flex.html.beads.models.RangeModelExtended} */ function(value) {
  this._labelFunction = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.models.RangeModelExtended.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'RangeModelExtended', qName: 'org.apache.flex.html.beads.models.RangeModelExtended'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.models.RangeModelExtended', org.apache.flex.html.beads.models.RangeModelExtended);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.models.RangeModelExtended.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'value': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.models.RangeModelExtended'},
        'labelFunction': { type: 'Function', declaredBy: 'org.apache.flex.html.beads.models.RangeModelExtended'}
      };
    },
    methods: function () {
      return {
        'RangeModelExtended': { type: '', declaredBy: 'org.apache.flex.html.beads.models.RangeModelExtended'},
        'getLabelForIndex': { type: 'String', declaredBy: 'org.apache.flex.html.beads.models.RangeModelExtended'}
      };
    }
  };
};