/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/layouts/VerticalColumnLayout.as
 * org.apache.flex.html.beads.layouts.VerticalColumnLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.layouts.VerticalColumnLayout');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.utils.CSSContainerUtils');
goog.require('org.apache.flex.utils.CSSUtils');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IMeasurementBead');
goog.require('org.apache.flex.core.IStrand');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadLayout}
 */
org.apache.flex.html.beads.layouts.VerticalColumnLayout = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.layouts.VerticalColumnLayout.prototype._strand;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.layouts.VerticalColumnLayout.prototype._numColumns;


/**
 * @copy org.apache.flex.core.IBeadLayout#layout
 * @export
 * @return {boolean}
 */
org.apache.flex.html.beads.layouts.VerticalColumnLayout.prototype.layout = function() {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true);
  var /** @type {org.apache.flex.core.ILayoutHost} */ layoutParent = org.apache.flex.utils.Language.as(host.getBeadByType(org.apache.flex.core.ILayoutHost), org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParent} */ contentView = layoutParent.contentView;
  var /** @type {org.apache.flex.geom.Rectangle} */ padding = org.apache.flex.utils.CSSContainerUtils.getPaddingMetrics(host);
  var /** @type {number} */ sw = host.width;
  var /** @type {number} */ sh = host.height;
  var /** @type {boolean} */ hasWidth = !host.isWidthSizedToContent();
  var /** @type {boolean} */ hasHeight = !host.isHeightSizedToContent();
  var /** @type {org.apache.flex.core.IUIBase} */ e;
  var /** @type {number} */ i;
  var /** @type {number} */ col = 0;
  var /** @type {Array} */ columns = [];
  var /** @type {Array} */ rows = [];
  var /** @type {Array} */ data = [];
  for (i = 0; i < this.numColumns; i++)
    columns[i] = 0;
  var /** @type {Object} */ marginLeft;
  var /** @type {Object} */ marginRight;
  var /** @type {Object} */ marginTop;
  var /** @type {Object} */ marginBottom;
  var /** @type {Object} */ margin;
  var /** @type {number} */ ml;
  var /** @type {number} */ mr;
  var /** @type {number} */ mt;
  var /** @type {number} */ mb;
  var /** @type {number} */ n = contentView.numElements;
  var /** @type {Object} */ rowData = {rowHeight:0};
  for (i = 0; i < n; i++) {
    e = org.apache.flex.utils.Language.as(contentView.getElementAt(i), org.apache.flex.core.IUIBase);
    margin = org.apache.flex.core.ValuesManager.valuesImpl.getValue(e, "margin");
    marginLeft = org.apache.flex.core.ValuesManager.valuesImpl.getValue(e, "margin-left");
    marginTop = org.apache.flex.core.ValuesManager.valuesImpl.getValue(e, "margin-top");
    marginRight = org.apache.flex.core.ValuesManager.valuesImpl.getValue(e, "margin-right");
    marginBottom = org.apache.flex.core.ValuesManager.valuesImpl.getValue(e, "margin-bottom");
    mt = org.apache.flex.utils.CSSUtils.getTopValue(marginTop, margin, sh);
    mb = org.apache.flex.utils.CSSUtils.getBottomValue(marginBottom, margin, sh);
    mr = org.apache.flex.utils.CSSUtils.getRightValue(marginRight, margin, sw);
    ml = org.apache.flex.utils.CSSUtils.getLeftValue(marginLeft, margin, sw);
    data.push({mt:mt, mb:mb, mr:mr, ml:ml});
    var /** @type {number} */ thisPrefWidth = 0;
    if (org.apache.flex.utils.Language.is(e, org.apache.flex.core.IStrand)) {
      var /** @type {org.apache.flex.core.IMeasurementBead} */ measure = org.apache.flex.utils.Language.as(e.getBeadByType(org.apache.flex.core.IMeasurementBead), org.apache.flex.core.IMeasurementBead);
      if (measure)
        thisPrefWidth = measure.measuredWidth + ml + mr;
      else
        thisPrefWidth = e.width + ml + mr;
    }
    else
      thisPrefWidth = e.width + ml + mr;
    rowData.rowHeight = Math.max(rowData.rowHeight, e.height + mt + mb);
    columns[col] = Math.max(columns[col], thisPrefWidth);
    col = col + 1;
    if (col == this.numColumns) {
      rows.push(rowData);
      rowData = {rowHeight:0};
      col = 0;
    }
  }
  var /** @type {number} */ lastmb = 0;
  var /** @type {number} */ curx = padding.left;
  var /** @type {number} */ cury = padding.top;
  var /** @type {number} */ maxHeight = 0;
  var /** @type {number} */ maxWidth = 0;
  col = 0;
  for (i = 0; i < n; i++) {
    e = org.apache.flex.utils.Language.as(contentView.getElementAt(i), org.apache.flex.core.IUIBase);
    e.x = curx + ml;
    e.y = Number(cury + data[i].mt);
    curx += Number(columns[col++]);
    maxHeight = Math.max(maxHeight, e.y + e.height + data[i].mb);
    maxWidth = Math.max(maxWidth, e.x + e.width + data[i].mr);
    if (col == this.numColumns) {
      cury += Number(rows[0].rowHeight);
      rows.shift();
      col = 0;
      curx = padding.left;
    }
  }
  if (!hasWidth && n > 0 && !isNaN(maxWidth)) {
    org.apache.flex.utils.Language.as(contentView, org.apache.flex.core.UIBase, true).setWidth(maxWidth, true);
  }
  if (!hasHeight && n > 0 && !isNaN(maxHeight)) {
    org.apache.flex.utils.Language.as(contentView, org.apache.flex.core.UIBase, true).setHeight(maxHeight, true);
  }
  return true;
};


Object.defineProperties(org.apache.flex.html.beads.layouts.VerticalColumnLayout.prototype, /** @lends {org.apache.flex.html.beads.layouts.VerticalColumnLayout.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.layouts.VerticalColumnLayout} */ function(value) {
  this._strand = value;
}},
/** @export */
numColumns: {
get: /** @this {org.apache.flex.html.beads.layouts.VerticalColumnLayout} */ function() {
  return this._numColumns;
},
set: /** @this {org.apache.flex.html.beads.layouts.VerticalColumnLayout} */ function(value) {
  this._numColumns = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.layouts.VerticalColumnLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'VerticalColumnLayout', qName: 'org.apache.flex.html.beads.layouts.VerticalColumnLayout'}], interfaces: [org.apache.flex.core.IBeadLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.layouts.VerticalColumnLayout', org.apache.flex.html.beads.layouts.VerticalColumnLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.layouts.VerticalColumnLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.layouts.VerticalColumnLayout'},
        'numColumns': { type: 'int', declaredBy: 'org.apache.flex.html.beads.layouts.VerticalColumnLayout'}
      };
    },
    methods: function () {
      return {
        'VerticalColumnLayout': { type: '', declaredBy: 'org.apache.flex.html.beads.layouts.VerticalColumnLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.flex.html.beads.layouts.VerticalColumnLayout'}
      };
    }
  };
};