/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/layouts/OneFlexibleChildVerticalLayout.as
 * org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.utils.CSSContainerUtils');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.core.ILayoutChild');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IParentIUIBase');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadLayout}
 * @implements {org.apache.flex.core.IDocument}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout = function() {
};


/**
 * @export
 * @type {string}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype.flexibleChild;


/**
 * @private
 * @type {org.apache.flex.core.ILayoutChild}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype.actualChild;


/**
 * @private
 * @type {org.apache.flex.core.ILayoutChild}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype.host;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype.document;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype._maxWidth;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype._maxHeight;


/**
 * @copy org.apache.flex.core.IBeadLayout#layout
 * @export
 * @return {boolean}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype.layout = function() {
  var /** @type {org.apache.flex.core.ILayoutHost} */ layoutParent = org.apache.flex.utils.Language.as(this.host.getBeadByType(org.apache.flex.core.ILayoutHost), org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = layoutParent ? layoutParent.contentView : org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.IParentIUIBase, true);
  var /** @type {org.apache.flex.geom.Rectangle} */ padding = org.apache.flex.utils.CSSContainerUtils.getPaddingMetrics(this.host);
  this.actualChild = this.document[this.flexibleChild];
  var /** @type {org.apache.flex.core.ILayoutChild} */ ilc;
  var /** @type {number} */ n = contentView.numElements;
  var /** @type {Object} */ marginLeft;
  var /** @type {Object} */ marginRight;
  var /** @type {Object} */ marginTop;
  var /** @type {Object} */ marginBottom;
  var /** @type {Object} */ margin;
  this.maxWidth = 0;
  var /** @type {number} */ w = contentView.width;
  var /** @type {number} */ hh = contentView.height - padding.bottom;
  var /** @type {number} */ yy = padding.top;
  var /** @type {number} */ flexChildIndex;
  var /** @type {number} */ ml;
  var /** @type {number} */ mr;
  var /** @type {number} */ mt;
  var /** @type {number} */ mb;
  var /** @type {number} */ lastmb;
  var /** @type {number} */ lastmt;
  var /** @type {Object} */ halign;
  var /** @type {number} */ left;
  var /** @type {number} */ right;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.core.IUIBase} */ child = org.apache.flex.utils.Language.as(contentView.getElementAt(i), org.apache.flex.core.IUIBase);
    ilc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.ILayoutChild);
    left = Number(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "left"));
    right = Number(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "right"));
    if (child == this.actualChild) {
      flexChildIndex = i;
      break;
    }
    margin = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin");
    if (org.apache.flex.utils.Language.is(margin, Array)) {
      if (margin.length == 1)
        marginLeft = marginTop = marginRight = marginBottom = margin[0]; else if (margin.length <= 3) {
        marginLeft = marginRight = margin[1];
        marginTop = marginBottom = margin[0];
      } else if (margin.length == 4) {
        marginLeft = margin[3];
        marginBottom = margin[2];
        marginRight = margin[1];
        marginTop = margin[0];
      }
    } else if (margin == null) {
      marginLeft = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-left");
      marginTop = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-top");
      marginRight = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-right");
      marginBottom = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-bottom");
    } else {
      marginLeft = marginTop = marginBottom = marginRight = margin;
    }
    mt = Number(marginTop);
    if (isNaN(mt))
      mt = 0;
    mb = Number(marginBottom);
    if (isNaN(mb))
      mb = 0;
    if (ilc) {
      if (!isNaN(ilc.percentHeight))
        ilc.setHeight(contentView.height * ilc.percentHeight / 100, !isNaN(ilc.percentWidth));
    }
    if (marginLeft == "auto")
      ml = 0; else {
      ml = Number(marginLeft);
      if (isNaN(ml))
        ml = 0;
    }
    if (marginRight == "auto")
      mr = 0; else {
      mr = Number(marginRight);
      if (isNaN(mr))
        mr = 0;
    }
    if (org.apache.flex.utils.Language.is(child, org.apache.flex.core.ILayoutChild)) {
      ilc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.ILayoutChild);
      if (!isNaN(ilc.percentWidth))
        ilc.setWidth(contentView.width * ilc.percentWidth / 100, !isNaN(ilc.percentHeight));
    }
    this.maxWidth = Math.max(this.maxWidth, ml + child.width + mr);
    this.setPositionAndWidth(child, left, ml, padding.left, right, mr, padding.right, w);
    child.y = yy + mt;
    yy += child.height + mt + mb;
    lastmb = mb;
  }
  if (n > 0 && n > flexChildIndex) {
    for (i = n - 1; i > flexChildIndex; i--) {
      child = org.apache.flex.utils.Language.as(contentView.getElementAt(i), org.apache.flex.core.IUIBase);
      ilc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.ILayoutChild);
      left = Number(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "left"));
      right = Number(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "right"));
      margin = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin");
      if (org.apache.flex.utils.Language.is(margin, Array)) {
        if (margin.length == 1)
          marginLeft = marginTop = marginRight = marginBottom = margin[0]; else if (margin.length <= 3) {
          marginLeft = marginRight = margin[1];
          marginTop = marginBottom = margin[0];
        } else if (margin.length == 4) {
          marginLeft = margin[3];
          marginBottom = margin[2];
          marginRight = margin[1];
          marginTop = margin[0];
        }
      } else if (margin == null) {
        marginLeft = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-left");
        marginTop = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-top");
        marginRight = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-right");
        marginBottom = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-bottom");
      } else {
        marginLeft = marginTop = marginBottom = marginRight = margin;
      }
      mt = Number(marginTop);
      if (isNaN(mt))
        mt = 0;
      mb = Number(marginBottom);
      if (isNaN(mb))
        mb = 0;
      if (ilc) {
        if (!isNaN(ilc.percentHeight))
          ilc.setHeight(contentView.height * ilc.percentHeight / 100, !isNaN(ilc.percentWidth));
      }
      if (marginLeft == "auto")
        ml = 0; else {
        ml = Number(marginLeft);
        if (isNaN(ml))
          ml = 0;
      }
      if (marginRight == "auto")
        mr = 0; else {
        mr = Number(marginRight);
        if (isNaN(mr))
          mr = 0;
      }
      if (org.apache.flex.utils.Language.is(child, org.apache.flex.core.ILayoutChild)) {
        ilc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.ILayoutChild);
        if (!isNaN(ilc.percentWidth))
          ilc.setWidth(contentView.width * ilc.percentWidth / 100, !isNaN(ilc.percentHeight));
      }
      this.setPositionAndWidth(child, left, ml, padding.left, right, mr, padding.right, w);
      this.maxWidth = Math.max(this.maxWidth, ml + child.width + mr);
      child.y = hh - child.height - mb;
      hh -= child.height + mt + mb;
      lastmt = mt;
    }
  }
  child = org.apache.flex.utils.Language.as(contentView.getElementAt(flexChildIndex), org.apache.flex.core.IUIBase);
  ilc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.ILayoutChild);
  left = Number(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "left"));
  right = Number(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "right"));
  margin = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin");
  if (org.apache.flex.utils.Language.is(margin, Array)) {
    if (margin.length == 1)
      marginLeft = marginTop = marginRight = marginBottom = margin[0]; else if (margin.length <= 3) {
      marginLeft = marginRight = margin[1];
      marginTop = marginBottom = margin[0];
    } else if (margin.length == 4) {
      marginLeft = margin[3];
      marginBottom = margin[2];
      marginRight = margin[1];
      marginTop = margin[0];
    }
  } else if (margin == null) {
    marginLeft = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-left");
    marginTop = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-top");
    marginRight = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-right");
    marginBottom = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-bottom");
  } else {
    marginLeft = marginTop = marginBottom = marginRight = margin;
  }
  mt = Number(marginTop);
  if (isNaN(mt))
    mt = 0;
  mb = Number(marginBottom);
  if (isNaN(mb))
    mb = 0;
  if (ilc) {
    if (!isNaN(ilc.percentHeight))
      ilc.setHeight(contentView.height * ilc.percentHeight / 100, !isNaN(ilc.percentWidth));
  }
  if (marginLeft == "auto")
    ml = 0; else {
    ml = Number(marginLeft);
    if (isNaN(ml))
      ml = 0;
  }
  if (marginRight == "auto")
    mr = 0; else {
    mr = Number(marginRight);
    if (isNaN(mr))
      mr = 0;
  }
  if (org.apache.flex.utils.Language.is(child, org.apache.flex.core.ILayoutChild)) {
    ilc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.ILayoutChild);
    if (!isNaN(ilc.percentWidth))
      ilc.setWidth(contentView.width * ilc.percentWidth / 100, !isNaN(ilc.percentHeight));
  }
  this.setPositionAndWidth(child, left, ml, padding.left, right, mr, padding.right, w);
  this.maxWidth = Math.max(this.maxWidth, ml + child.width + mr);
  child.y = yy + mt;
  child.height = hh - mb - child.y;
  return true;
};


/**
 * @private
 * @param {org.apache.flex.core.IUIBase} child
 * @param {number} left
 * @param {number} ml
 * @param {number} pl
 * @param {number} right
 * @param {number} mr
 * @param {number} pr
 * @param {number} w
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype.setPositionAndWidth = function(child, left, ml, pl, right, mr, pr, w) {
  var /** @type {boolean} */ widthSet = false;
  var /** @type {number} */ ww = w;
  var /** @type {org.apache.flex.core.ILayoutChild} */ ilc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.ILayoutChild);
  if (!isNaN(left)) {
    child.x = left + ml;
    ww -= left + ml;
  } else {
    if (isNaN(right))
      child.x = ml + pl;
    ww -= ml;
  }
  if (!isNaN(right)) {
    if (!isNaN(left)) {
      if (ilc)
        ilc.setWidth(ww - right - mr, true); else {
        child.width = ww - right - mr;
        widthSet = true;
      }
    }
    else
      child.x = w - right - mr - child.width - 1;
  }
  if (ilc) {
    if (!isNaN(ilc.percentWidth))
      ilc.setWidth(w * ilc.percentWidth / 100, true);
  }
  if (!widthSet)
    child.dispatchEvent(new org.apache.flex.events.Event("sizeChanged"));
};


/**
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


Object.defineProperties(org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype, /** @lends {org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout} */ function(value) {
  this.host = org.apache.flex.utils.Language.as(value, org.apache.flex.core.ILayoutChild);
}},
/** @export */
maxWidth: {
get: /** @this {org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout} */ function() {
  return this._maxWidth;
},
set: /** @this {org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout} */ function(value) {
  this._maxWidth = value;
}},
/** @export */
maxHeight: {
get: /** @this {org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout} */ function() {
  return this._maxHeight;
},
set: /** @this {org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout} */ function(value) {
  this._maxHeight = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'OneFlexibleChildVerticalLayout', qName: 'org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout'}], interfaces: [org.apache.flex.core.IBeadLayout, org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout', org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'flexibleChild': { type: 'String'}
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout'},
        'maxWidth': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout'},
        'maxHeight': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout'}
      };
    },
    methods: function () {
      return {
        'OneFlexibleChildVerticalLayout': { type: '', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildVerticalLayout'}
      };
    }
  };
};