/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/layouts/FlexibleFirstChildHorizontalLayout.as
 * org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.utils.CSSContainerUtils');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.ILayoutChild');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IParentIUIBase');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadLayout}
 */
org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.ILayoutChild}
 */
org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout.prototype.host;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout.prototype._maxWidth;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout.prototype._maxHeight;


/**
 * @copy org.apache.flex.core.IBeadLayout#layout
 * @export
 * @return {boolean}
 */
org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout.prototype.layout = function() {
  var /** @type {org.apache.flex.core.ILayoutHost} */ layoutParent = org.apache.flex.utils.Language.as(this.host.getBeadByType(org.apache.flex.core.ILayoutHost), org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = org.apache.flex.utils.Language.as(layoutParent.contentView, org.apache.flex.core.IParentIUIBase);
  var /** @type {org.apache.flex.geom.Rectangle} */ padding = org.apache.flex.utils.CSSContainerUtils.getPaddingMetrics(this.host);
  var /** @type {boolean} */ hostSizedToContent = this.host.isHeightSizedToContent();
  var /** @type {number} */ n = contentView.numElements;
  var /** @type {Object} */ marginLeft;
  var /** @type {Object} */ marginRight;
  var /** @type {Object} */ marginTop;
  var /** @type {Object} */ marginBottom;
  var /** @type {Object} */ margin;
  this.maxHeight = 0;
  var /** @type {Array} */ verticalMargins = [];
  var /** @type {number} */ xx = contentView.width;
  if (isNaN(xx) || xx <= 0)
    return true;
  xx -= padding.right + 1;
  for (var /** @type {number} */ i = n - 1; i >= 0; i--) {
    var /** @type {org.apache.flex.core.IUIBase} */ child = org.apache.flex.utils.Language.as(contentView.getElementAt(i), org.apache.flex.core.IUIBase);
    margin = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin");
    if (org.apache.flex.utils.Language.is(margin, Array)) {
      if (margin.length == 1)
        marginLeft = marginTop = marginRight = marginBottom = margin[0]; else if (margin.length <= 3) {
        marginLeft = marginRight = margin[1];
        marginTop = marginBottom = margin[0];
      } else if (margin.length == 4) {
        marginLeft = margin[3];
        marginBottom = margin[2];
        marginRight = margin[1];
        marginTop = margin[0];
      }
    } else if (margin == null) {
      marginLeft = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-left");
      marginTop = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-top");
      marginRight = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-right");
      marginBottom = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-bottom");
    } else {
      marginLeft = marginTop = marginBottom = marginRight = margin;
    }
    var /** @type {number} */ ml;
    var /** @type {number} */ mr;
    var /** @type {number} */ mt;
    var /** @type {number} */ mb;
    var /** @type {number} */ lastmr;
    mt = Number(marginTop);
    if (isNaN(mt))
      mt = 0;
    mb = Number(marginBottom);
    if (isNaN(mb))
      mb = 0;
    if (marginLeft == "auto")
      ml = 0; else {
      ml = Number(marginLeft);
      if (isNaN(ml))
        ml = 0;
    }
    if (marginRight == "auto")
      mr = 0; else {
      mr = Number(marginRight);
      if (isNaN(mr))
        mr = 0;
    }
    child.y = mt + padding.top;
    if (i == 0) {
      child.x = ml + padding.left;
      child.width = xx - mr - child.x;
    }
    else
      child.x = xx - child.width - mr;
    this.maxHeight = Math.max(this.maxHeight, mt + child.height + mb);
    xx -= child.width + mr + ml;
    lastmr = mr;
    var /** @type {Object} */ valign = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "vertical-align");
    verticalMargins.push({marginTop:mt, marginBottom:mb, valign:valign});
  }
  for (i = 0; i < n; i++) {
    var /** @type {Object} */ obj = verticalMargins[0];
    child = org.apache.flex.utils.Language.as(contentView.getElementAt(i), org.apache.flex.core.IUIBase);
    if (obj.valign == "middle")
      child.y = (this.maxHeight - child.height) / 2;
    else if (valign == "bottom")
      child.y = this.maxHeight - child.height - obj.marginBottom;
    else
      child.y = Number(obj.marginTop);
  }
  if (hostSizedToContent)
    org.apache.flex.utils.Language.as(contentView, org.apache.flex.core.ILayoutChild, true).setHeight(this.maxHeight + padding.top + padding.bottom, true);
  return true;
};


Object.defineProperties(org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout.prototype, /** @lends {org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout} */ function(value) {
  this.host = org.apache.flex.utils.Language.as(value, org.apache.flex.core.ILayoutChild);
}},
/** @export */
maxWidth: {
get: /** @this {org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout} */ function() {
  return this._maxWidth;
},
set: /** @this {org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout} */ function(value) {
  this._maxWidth = value;
}},
/** @export */
maxHeight: {
get: /** @this {org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout} */ function() {
  return this._maxHeight;
},
set: /** @this {org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout} */ function(value) {
  this._maxHeight = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'FlexibleFirstChildHorizontalLayout', qName: 'org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout'}], interfaces: [org.apache.flex.core.IBeadLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout', org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout'},
        'maxWidth': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout'},
        'maxHeight': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout'}
      };
    },
    methods: function () {
      return {
        'FlexibleFirstChildHorizontalLayout': { type: '', declaredBy: 'org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.flex.html.beads.layouts.FlexibleFirstChildHorizontalLayout'}
      };
    }
  };
};