/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/PanelView.as
 * org.apache.flex.html.beads.PanelView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.PanelView');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.geom.Rectangle');
goog.require('org.apache.flex.html.TitleBar');
goog.require('org.apache.flex.html.beads.ContainerView');
goog.require('org.apache.flex.utils.CSSContainerUtils');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IContentViewHost');
goog.require('org.apache.flex.core.ILayoutChild');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.beads.ContainerView}
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.html.beads.PanelView = function() {
  org.apache.flex.html.beads.PanelView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.PanelView, org.apache.flex.html.beads.ContainerView);


/**
 * @private
 * @type {org.apache.flex.html.TitleBar}
 */
org.apache.flex.html.beads.PanelView.prototype._titleBar;


/**
 * @protected
 * @override
 */
org.apache.flex.html.beads.PanelView.prototype.completeSetup = function() {
  org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.IContentViewHost).strandChildren.addElement(this.titleBar);
  org.apache.flex.html.beads.PanelView.base(this, 'completeSetup');
};


/**
 * Calculate the space taken up by non-content children like a TItleBar in a Panel.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @override
 */
org.apache.flex.html.beads.PanelView.prototype.getChromeMetrics = function() {
  return new org.apache.flex.geom.Rectangle(0, this.titleBar.height, 0, 0 - this.titleBar.height);
};


/**
 * @protected
 * @override
 */
org.apache.flex.html.beads.PanelView.prototype.layoutViewBeforeContentLayout = function() {
  var /** @type {org.apache.flex.core.IViewportModel} */ vm = this.viewportModel;
  var /** @type {org.apache.flex.core.ILayoutChild} */ host = org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.ILayoutChild);
  vm.borderMetrics = org.apache.flex.utils.CSSContainerUtils.getBorderMetrics(host);
  this.titleBar.x = vm.borderMetrics.left;
  this.titleBar.y = vm.borderMetrics.top;
  if (!host.isWidthSizedToContent())
    this.titleBar.width = host.width - vm.borderMetrics.left - vm.borderMetrics.right;
  vm.chromeMetrics = this.getChromeMetrics();
  this.viewport.setPosition(vm.borderMetrics.left + vm.chromeMetrics.left, vm.borderMetrics.top + vm.chromeMetrics.top);
  this.viewport.layoutViewportBeforeContentLayout(!host.isWidthSizedToContent() ? host.width - vm.borderMetrics.left - vm.borderMetrics.right - vm.chromeMetrics.left - vm.chromeMetrics.right : NaN, !host.isHeightSizedToContent() ? host.height - vm.borderMetrics.top - vm.borderMetrics.bottom - vm.chromeMetrics.top - vm.chromeMetrics.bottom : NaN);
};


/**
 * @protected
 * @override
 */
org.apache.flex.html.beads.PanelView.prototype.layoutViewAfterContentLayout = function() {
  var /** @type {org.apache.flex.core.IViewportModel} */ vm = this.viewportModel;
  var /** @type {org.apache.flex.geom.Size} */ viewportSize = this.viewport.layoutViewportAfterContentLayout();
  var /** @type {org.apache.flex.core.ILayoutChild} */ host = org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.ILayoutChild);
  var /** @type {boolean} */ hasWidth = !host.isWidthSizedToContent();
  var /** @type {boolean} */ hasHeight = !host.isHeightSizedToContent();
  if (!hasWidth) {
    this.titleBar.width = viewportSize.width;
    vm.chromeMetrics = this.getChromeMetrics();
    vm.chromeMetrics.top = this.titleBar.height;
  }
  org.apache.flex.html.beads.PanelView.base(this, 'layoutViewAfterContentLayout');
};


Object.defineProperties(org.apache.flex.html.beads.PanelView.prototype, /** @lends {org.apache.flex.html.beads.PanelView.prototype} */ {
/** @export */
titleBar: {
get: /** @this {org.apache.flex.html.beads.PanelView} */ function() {
  return this._titleBar;
},
set: /** @this {org.apache.flex.html.beads.PanelView} */ function(value) {
  this._titleBar = value;
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.PanelView} */ function(value) {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(value, org.apache.flex.core.UIBase, true);
  if (!this._titleBar) {
    this._titleBar = new org.apache.flex.html.TitleBar();
    this._titleBar.id = "panelTitleBar";
    this._titleBar.height = 30;
  }
  this.titleBar.model = host.model;
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.beads.PanelView, this, 'strand', value);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.PanelView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'PanelView', qName: 'org.apache.flex.html.beads.PanelView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.PanelView', org.apache.flex.html.beads.PanelView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.PanelView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'titleBar': { type: 'TitleBar', declaredBy: 'org.apache.flex.html.beads.PanelView'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.PanelView'}
      };
    },
    methods: function () {
      return {
        'PanelView': { type: '', declaredBy: 'org.apache.flex.html.beads.PanelView'}
      };
    }
  };
};