/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/ListView.as
 * org.apache.flex.html.beads.ListView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.ListView');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.beads.ContainerView');
goog.require('org.apache.flex.core.IItemRendererParent');
goog.require('org.apache.flex.core.IRollOverModel');
goog.require('org.apache.flex.core.ISelectableItemRenderer');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.html.beads.IListView');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.html.beads.ContainerView}
 * @implements {org.apache.flex.html.beads.IListView}
 */
org.apache.flex.html.beads.ListView = function() {
  org.apache.flex.html.beads.ListView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.ListView, org.apache.flex.html.beads.ContainerView);


/**
 * @protected
 * @type {org.apache.flex.core.ISelectionModel}
 */
org.apache.flex.html.beads.ListView.prototype.listModel;


/**
 * @private
 * @type {org.apache.flex.html.supportClasses.Border}
 */
org.apache.flex.html.beads.ListView.prototype._border;


/**
 * @protected
 * @override
 */
org.apache.flex.html.beads.ListView.prototype.completeSetup = function() {
  org.apache.flex.html.beads.ListView.base(this, 'completeSetup');
  this.host.removeEventListener("childrenAdded", org.apache.flex.utils.Language.closure(this.childrenChangedHandler, this, 'childrenChangedHandler'));
  this.host.removeEventListener("childrenAdded", org.apache.flex.utils.Language.closure(this.performLayout, this, 'performLayout'));
  this.host.addEventListener("itemsCreated", org.apache.flex.utils.Language.closure(this.itemsCreatedHandler, this, 'itemsCreatedHandler'));
  this.listModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  this.listModel.addEventListener("selectedIndexChanged", org.apache.flex.utils.Language.closure(this.selectionChangeHandler, this, 'selectionChangeHandler'));
  this.listModel.addEventListener("rollOverIndexChanged", org.apache.flex.utils.Language.closure(this.rollOverIndexChangeHandler, this, 'rollOverIndexChangeHandler'));
  this.listModel.addEventListener("dataProviderChanged", org.apache.flex.utils.Language.closure(this.dataProviderChangeHandler, this, 'dataProviderChangeHandler'));
};


/**
 * @protected
 * @type {number}
 */
org.apache.flex.html.beads.ListView.prototype.lastSelectedIndex = -1;


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ListView.prototype.itemsCreatedHandler = function(event) {
  this.performLayout(event);
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ListView.prototype.dataProviderChangeHandler = function(event) {
  this.performLayout(event);
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ListView.prototype.selectionChangeHandler = function(event) {
  if (this.lastSelectedIndex != -1) {
    var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ ir = org.apache.flex.utils.Language.as(this.dataGroup.getItemRendererForIndex(this.lastSelectedIndex), org.apache.flex.core.ISelectableItemRenderer);
    if (ir != null)
      ir.selected = false;
  }
  if (this.listModel.selectedIndex != -1) {
    ir = org.apache.flex.utils.Language.as(this.dataGroup.getItemRendererForIndex(this.listModel.selectedIndex), org.apache.flex.core.ISelectableItemRenderer);
    if (ir != null)
      ir.selected = true;
  }
  this.lastSelectedIndex = this.listModel.selectedIndex;
};


/**
 * @protected
 * @type {number}
 */
org.apache.flex.html.beads.ListView.prototype.lastRollOverIndex = -1;


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ListView.prototype.rollOverIndexChangeHandler = function(event) {
  if (this.lastRollOverIndex != -1) {
    var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ ir = org.apache.flex.utils.Language.as(this.dataGroup.getItemRendererForIndex(this.lastRollOverIndex), org.apache.flex.core.ISelectableItemRenderer);
    ir.hovered = false;
  }
  if (org.apache.flex.utils.Language.as(this.listModel, org.apache.flex.core.IRollOverModel, true).rollOverIndex != -1) {
    ir = org.apache.flex.utils.Language.as(this.dataGroup.getItemRendererForIndex(org.apache.flex.utils.Language.as(this.listModel, org.apache.flex.core.IRollOverModel, true).rollOverIndex), org.apache.flex.core.ISelectableItemRenderer);
    ir.hovered = true;
  }
  this.lastRollOverIndex = org.apache.flex.utils.Language.as(this.listModel, org.apache.flex.core.IRollOverModel, true).rollOverIndex;
};


/**
 *  respond to a change in size or request to re-layout everything
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @override
 */
org.apache.flex.html.beads.ListView.prototype.resizeHandler = function(event) {
  org.apache.flex.html.beads.ListView.base(this, 'resizeHandler', event);
};


Object.defineProperties(org.apache.flex.html.beads.ListView.prototype, /** @lends {org.apache.flex.html.beads.ListView.prototype} */ {
/** @export */
border: {
get: /** @this {org.apache.flex.html.beads.ListView} */ function() {
  return this._border;
}},
/** @export */
dataGroup: {
get: /** @this {org.apache.flex.html.beads.ListView} */ function() {
  org.apache.flex.utils.Language.as(this.contentView, org.apache.flex.core.UIBase).className = "ListDataGroup";
  return org.apache.flex.utils.Language.as(this.contentView, org.apache.flex.core.IItemRendererParent);
}},
/** @export */
resizableView: {
get: /** @this {org.apache.flex.html.beads.ListView} */ function() {
  return org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase);
}},
/** @export */
host: {
get: /** @this {org.apache.flex.html.beads.ListView} */ function() {
  return org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase);
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.ListView} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.beads.ListView, this, 'strand', value);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.ListView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ListView', qName: 'org.apache.flex.html.beads.ListView'}], interfaces: [org.apache.flex.html.beads.IListView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.ListView', org.apache.flex.html.beads.ListView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.ListView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'border': { type: 'Border', declaredBy: 'org.apache.flex.html.beads.ListView'},
        'dataGroup': { type: 'IItemRendererParent', declaredBy: 'org.apache.flex.html.beads.ListView'},
        'resizableView': { type: 'IUIBase', declaredBy: 'org.apache.flex.html.beads.ListView'},
        'host': { type: 'IUIBase', declaredBy: 'org.apache.flex.html.beads.ListView'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.ListView'}
      };
    },
    methods: function () {
      return {
        'ListView': { type: '', declaredBy: 'org.apache.flex.html.beads.ListView'}
      };
    }
  };
};