/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/IncrementButtonView.as
 * org.apache.flex.html.beads.IncrementButtonView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.IncrementButtonView');

goog.require('org.apache.flex.core.BeadViewBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.graphics.SolidColorStroke');
goog.require('org.apache.flex.svg.Path');
goog.require('org.apache.flex.svg.Rect');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.core.BeadViewBase}
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.html.beads.IncrementButtonView = function() {
  org.apache.flex.html.beads.IncrementButtonView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.IncrementButtonView, org.apache.flex.core.BeadViewBase);


/**
 * @private
 * @type {org.apache.flex.svg.Rect}
 */
org.apache.flex.html.beads.IncrementButtonView.prototype._backRect;


/**
 * @private
 * @type {org.apache.flex.svg.Path}
 */
org.apache.flex.html.beads.IncrementButtonView.prototype._arrow;


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.IncrementButtonView.prototype.sizeHandler = function(event) {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  this._backRect.x = 0;
  this._backRect.y = 0;
  this._backRect.setWidthAndHeight(host.width, host.height, true);
  this._backRect.drawRect(0, 0, host.width, host.height);
  var /** @type {number} */ xm = host.width / 2;
  var /** @type {number} */ ym = host.height - 4;
  this._arrow.setWidthAndHeight(xm, ym, true);
  this._arrow.y = 2;
  this._arrow.x = 0;
  this._arrow.drawStringPath(0, 0, "M " + xm + " 2 L " + (xm - 8) + " " + ym + " L " + (xm + 8) + " " + ym + " Z");
};


Object.defineProperties(org.apache.flex.html.beads.IncrementButtonView.prototype, /** @lends {org.apache.flex.html.beads.IncrementButtonView.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.IncrementButtonView} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.beads.IncrementButtonView, this, 'strand', value);
  this._strand = value;
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  this._backRect = new org.apache.flex.svg.Rect();
  this._backRect.fill = new org.apache.flex.graphics.SolidColor();
  org.apache.flex.utils.Language.as(this._backRect.fill, org.apache.flex.graphics.SolidColor).color = 0xFFFFFF;
  this._backRect.stroke = new org.apache.flex.graphics.SolidColorStroke();
  org.apache.flex.utils.Language.as(this._backRect.stroke, org.apache.flex.graphics.SolidColorStroke).color = 0x000000;
  org.apache.flex.utils.Language.as(this._backRect.stroke, org.apache.flex.graphics.SolidColorStroke).weight = 1.0;
  host.addElement(this._backRect);
  this._arrow = new org.apache.flex.svg.Path();
  this._arrow.fill = new org.apache.flex.graphics.SolidColor();
  org.apache.flex.utils.Language.as(this._arrow.fill, org.apache.flex.graphics.SolidColor).color = 0x000000;
  host.addElement(this._arrow);
  host.addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.sizeHandler, this, 'sizeHandler'));
  host.addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.sizeHandler, this, 'sizeHandler'));
  this.sizeHandler(null);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.IncrementButtonView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'IncrementButtonView', qName: 'org.apache.flex.html.beads.IncrementButtonView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.IncrementButtonView', org.apache.flex.html.beads.IncrementButtonView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.IncrementButtonView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.IncrementButtonView'}
      };
    },
    methods: function () {
      return {
        'IncrementButtonView': { type: '', declaredBy: 'org.apache.flex.html.beads.IncrementButtonView'}
      };
    }
  };
};