/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/DateChooserView.as
 * org.apache.flex.html.beads.DateChooserView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.DateChooserView');

goog.require('org.apache.flex.core.BeadViewBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.Container');
goog.require('org.apache.flex.html.beads.layouts.TileLayout');
goog.require('org.apache.flex.html.beads.models.DateChooserModel');
goog.require('org.apache.flex.html.supportClasses.DateChooserButton');
goog.require('org.apache.flex.html.supportClasses.DateHeaderButton');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.BeadViewBase}
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.html.beads.DateChooserView = function() {
  org.apache.flex.html.beads.DateChooserView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.DateChooserView, org.apache.flex.core.BeadViewBase);


/**
 * @private
 * @type {org.apache.flex.html.supportClasses.DateHeaderButton}
 */
org.apache.flex.html.beads.DateChooserView.prototype._prevMonthButton;


/**
 * @private
 * @type {org.apache.flex.html.supportClasses.DateHeaderButton}
 */
org.apache.flex.html.beads.DateChooserView.prototype._nextMonthButton;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.html.beads.DateChooserView.prototype._dayButtons;


/**
 * @private
 * @type {org.apache.flex.html.supportClasses.DateHeaderButton}
 */
org.apache.flex.html.beads.DateChooserView.prototype.monthLabel;


/**
 * @private
 * @type {org.apache.flex.html.Container}
 */
org.apache.flex.html.beads.DateChooserView.prototype.dayContainer;


/**
 * @private
 * @type {org.apache.flex.html.beads.models.DateChooserModel}
 */
org.apache.flex.html.beads.DateChooserView.prototype.model;


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DateChooserView.prototype.handleSizeChange = function(event) {
  this.layoutContents();
};


/**
 * @private
 */
org.apache.flex.html.beads.DateChooserView.prototype.layoutContents = function() {
  var /** @type {number} */ sw = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).width;
  var /** @type {number} */ sh = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).height;
  this._prevMonthButton.x = 0;
  this._prevMonthButton.y = 0;
  this._nextMonthButton.x = sw - this._nextMonthButton.width;
  this._nextMonthButton.y = 0;
  this.monthLabel.x = (sw - this.monthLabel.width) / 2;
  this.monthLabel.y = 0;
  this.dayContainer.x = 0;
  this.dayContainer.y = this.monthLabel.y + this.monthLabel.height + 5;
  this.dayContainer.width = sw;
  this.dayContainer.height = sh - (this.monthLabel.height + 5);
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("layoutNeeded"));
  org.apache.flex.utils.Language.as(this.dayContainer, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("layoutNeeded"));
};


/**
 * @asprivate
 * @private
 */
org.apache.flex.html.beads.DateChooserView.prototype.createChildren = function() {
  this._prevMonthButton = new org.apache.flex.html.supportClasses.DateHeaderButton();
  this._prevMonthButton.width = 40;
  this._prevMonthButton.height = 20;
  this._prevMonthButton.text = "<";
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addElement(this._prevMonthButton);
  this._nextMonthButton = new org.apache.flex.html.supportClasses.DateHeaderButton();
  this._nextMonthButton.width = 40;
  this._nextMonthButton.height = 20;
  this._nextMonthButton.text = ">";
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addElement(this._nextMonthButton);
  this.monthLabel = new org.apache.flex.html.supportClasses.DateHeaderButton();
  this.monthLabel.text = "Month Here";
  this.monthLabel.width = 100;
  this.monthLabel.height = 20;
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addElement(this.monthLabel);
  this.dayContainer = new org.apache.flex.html.Container();
  var /** @type {org.apache.flex.html.beads.layouts.TileLayout} */ tileLayout = new org.apache.flex.html.beads.layouts.TileLayout();
  this.dayContainer.addBead(tileLayout);
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addElement(this.dayContainer, false);
  tileLayout.numColumns = 7;
  for (var /** @type {number} */ i = 0; i < 7; i++) {
    var /** @type {org.apache.flex.html.supportClasses.DateChooserButton} */ dayName = new org.apache.flex.html.supportClasses.DateChooserButton();
    dayName.text = org.apache.flex.utils.Language.string(this.model.dayNames[i]);
    dayName.dayOfMonth = 0;
    this.dayContainer.addElement(dayName, false);
  }
  this._dayButtons = new Array();
  for (i = 0; i < 42; i++) {
    var /** @type {org.apache.flex.html.supportClasses.DateChooserButton} */ date = new org.apache.flex.html.supportClasses.DateChooserButton();
    date.text = String(i + 1);
    this.dayContainer.addElement(date, false);
    this.dayButtons.push(date);
  }
  org.apache.flex.utils.Language.as(this.dayContainer, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("itemsCreated"));
  this.updateCalendar();
};


/**
 * @asprivate
 * @private
 */
org.apache.flex.html.beads.DateChooserView.prototype.updateCalendar = function() {
  this.monthLabel.text = this.model.monthNames[this.model.displayedMonth] + " " + String(this.model.displayedYear);
  var /** @type {Date} */ firstDay = new Date(this.model.displayedYear, this.model.displayedMonth, 1);
  for (var /** @type {number} */ i = 0; i < firstDay.getDay(); i++) {
    var /** @type {org.apache.flex.html.supportClasses.DateChooserButton} */ dateButton = org.apache.flex.utils.Language.as(this.dayButtons[i], org.apache.flex.html.supportClasses.DateChooserButton);
    dateButton.dayOfMonth = -1;
    dateButton.text = "";
  }
  var /** @type {Date} */ today = new Date();
  var /** @type {number} */ dayNumber = 1;
  var /** @type {number} */ numDays = this.numberOfDaysInMonth(this.model.displayedMonth, this.model.displayedYear);
  for (; i < this.dayButtons.length && dayNumber <= numDays; i++) {
    dateButton = org.apache.flex.utils.Language.as(this.dayButtons[i], org.apache.flex.html.supportClasses.DateChooserButton);
    dateButton.dayOfMonth = dayNumber;
    dateButton.text = String(dayNumber++);
    if (this.model.displayedMonth == today.getMonth() && this.model.displayedYear == today.getFullYear() && (dayNumber - 1) == today.getDate()) {
      dateButton.id = "todayDateChooserButton";
    } else {
      dateButton.id = "";
    }
  }
  for (; i < this.dayButtons.length; i++) {
    dateButton = org.apache.flex.utils.Language.as(this.dayButtons[i], org.apache.flex.html.supportClasses.DateChooserButton);
    dateButton.dayOfMonth = -1;
    dateButton.text = "";
  }
};


/**
 * @asprivate
 * @private
 * @param {number} month
 * @param {number} year
 * @return {number}
 */
org.apache.flex.html.beads.DateChooserView.prototype.numberOfDaysInMonth = function(month, year) {
  var /** @type {number} */ n;
  if (month == 1) {
    if (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0))
      n = 29;
    else
      n = 28;
  }
  else if (month == 3 || month == 5 || month == 8 || month == 10)
    n = 30;
  else
    n = 31;
  return n;
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DateChooserView.prototype.handleModelChange = function(event) {
  this.updateCalendar();
};


Object.defineProperties(org.apache.flex.html.beads.DateChooserView.prototype, /** @lends {org.apache.flex.html.beads.DateChooserView.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.DateChooserView} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.beads.DateChooserView, this, 'strand', value);
  
  this.model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.html.beads.models.DateChooserModel);
  if (this.model == null) {
    this.model = org.apache.flex.utils.Language.as(new (org.apache.flex.core.ValuesManager.valuesImpl.getValue(this._strand, "iBeadModel"))(), org.apache.flex.html.beads.models.DateChooserModel);
  }
  this.model.addEventListener("displayedMonthChanged", org.apache.flex.utils.Language.closure(this.handleModelChange, this, 'handleModelChange'));
  this.model.addEventListener("displayedYearChanged", org.apache.flex.utils.Language.closure(this.handleModelChange, this, 'handleModelChange'));
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(value, org.apache.flex.core.UIBase);
  host.addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.handleSizeChange, this, 'handleSizeChange'));
  host.addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.handleSizeChange, this, 'handleSizeChange'));
  this.createChildren();
  this.layoutContents();
}},
/** @export */
prevMonthButton: {
get: /** @this {org.apache.flex.html.beads.DateChooserView} */ function() {
  return this._prevMonthButton;
}},
/** @export */
nextMonthButton: {
get: /** @this {org.apache.flex.html.beads.DateChooserView} */ function() {
  return this._nextMonthButton;
}},
/** @export */
dayButtons: {
get: /** @this {org.apache.flex.html.beads.DateChooserView} */ function() {
  return this._dayButtons;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.DateChooserView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DateChooserView', qName: 'org.apache.flex.html.beads.DateChooserView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.DateChooserView', org.apache.flex.html.beads.DateChooserView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.DateChooserView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.DateChooserView'},
        'prevMonthButton': { type: 'DateHeaderButton', declaredBy: 'org.apache.flex.html.beads.DateChooserView'},
        'nextMonthButton': { type: 'DateHeaderButton', declaredBy: 'org.apache.flex.html.beads.DateChooserView'},
        'dayButtons': { type: 'Array', declaredBy: 'org.apache.flex.html.beads.DateChooserView'}
      };
    },
    methods: function () {
      return {
        'DateChooserView': { type: '', declaredBy: 'org.apache.flex.html.beads.DateChooserView'}
      };
    }
  };
};