/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/DataGridView.as
 * org.apache.flex.html.beads.DataGridView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.DataGridView');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.Container');
goog.require('org.apache.flex.html.DataGridButtonBar');
goog.require('org.apache.flex.html.List');
goog.require('org.apache.flex.html.beads.layouts.ButtonBarLayout');
goog.require('org.apache.flex.html.beads.models.ArraySelectionModel');
goog.require('org.apache.flex.html.beads.models.DataGridPresentationModel');
goog.require('org.apache.flex.html.supportClasses.DataGridColumn');
goog.require('org.apache.flex.html.supportClasses.ScrollingViewport');
goog.require('org.apache.flex.html.supportClasses.Viewport');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IDataGridModel');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.html.beads.DataGridView = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.DataGridView.prototype._strand;


/**
 * @private
 * @type {org.apache.flex.html.DataGridButtonBar}
 */
org.apache.flex.html.beads.DataGridView.prototype._header;


/**
 * @private
 * @type {org.apache.flex.html.Container}
 */
org.apache.flex.html.beads.DataGridView.prototype._listArea;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.html.beads.DataGridView.prototype._lists;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DataGridView.prototype.finishSetup = function(event) {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  var /** @type {org.apache.flex.html.beads.models.DataGridPresentationModel} */ presentationModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.html.beads.models.DataGridPresentationModel), org.apache.flex.html.beads.models.DataGridPresentationModel);
  if (presentationModel == null) {
    presentationModel = new org.apache.flex.html.beads.models.DataGridPresentationModel();
    this._strand.addBead(presentationModel);
  }
  var /** @type {org.apache.flex.core.IDataGridModel} */ sharedModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.IDataGridModel);
  org.apache.flex.utils.Language.as(sharedModel, org.apache.flex.events.IEventDispatcher, true).addEventListener("dataProviderChanged", org.apache.flex.utils.Language.closure(this.handleDataProviderChanged, this, 'handleDataProviderChanged'));
  var /** @type {Array} */ columnLabels = new Array();
  var /** @type {Array} */ buttonWidths = new Array();
  for (var /** @type {number} */ i = 0; i < sharedModel.columns.length; i++) {
    var /** @type {org.apache.flex.html.supportClasses.DataGridColumn} */ dgc = org.apache.flex.utils.Language.as(sharedModel.columns[i], org.apache.flex.html.supportClasses.DataGridColumn);
    columnLabels.push(dgc.label);
    if (!isNaN(dgc.columnWidth))
      buttonWidths.push(dgc.columnWidth);
  }
  var /** @type {org.apache.flex.html.beads.layouts.ButtonBarLayout} */ bblayout = new org.apache.flex.html.beads.layouts.ButtonBarLayout();
  if (buttonWidths.length == sharedModel.columns.length) {
    bblayout.buttonWidths = buttonWidths;
  }
  var /** @type {org.apache.flex.html.beads.models.ArraySelectionModel} */ buttonBarModel = new org.apache.flex.html.beads.models.ArraySelectionModel();
  buttonBarModel.dataProvider = columnLabels;
  this._header.addBead(buttonBarModel);
  this._header.addBead(bblayout);
  this._header.addBead(new org.apache.flex.html.supportClasses.Viewport());
  host.addElement(this._header);
  host.addElement(this._listArea);
  if (host.isHeightSizedToContent() || host.isWidthSizedToContent()) {
    host.addEventListener("sizeChanged", org.apache.flex.utils.Language.closure(this.handleSizeChanges, this, 'handleSizeChanges'));
  } else {
    this.handleDataProviderChanged(event);
  }
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DataGridView.prototype.handleSizeChanges = function(event) {
  var /** @type {number} */ useWidth = this._listArea.width;
  var /** @type {number} */ useHeight = this._listArea.height;
  if (this.host.width > 0) {
    useWidth = this.host.width;
  }
  this._header.x = 0;
  this._header.y = 0;
  this._header.width = useWidth;
  this._header.height = 25;
  if (this.host.height > 0) {
    useHeight = this.host.height - this._header.height;
  }
  this._listArea.x = 0;
  this._listArea.y = 26;
  this._listArea.width = useWidth;
  this._listArea.height = useHeight;
  var /** @type {org.apache.flex.core.IDataGridModel} */ sharedModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.IDataGridModel);
  if (this._lists != null && this._lists.length > 0) {
    var /** @type {number} */ xpos = 0;
    var /** @type {number} */ listWidth = this.host.width / this._lists.length;
    for (var /** @type {number} */ i = 0; i < this._lists.length; i++) {
      var /** @type {org.apache.flex.html.List} */ list = org.apache.flex.utils.Language.as(this._lists[i], org.apache.flex.html.List);
      list.x = xpos;
      list.y = 0;
      var /** @type {org.apache.flex.html.supportClasses.DataGridColumn} */ dataGridColumn = org.apache.flex.utils.Language.as(sharedModel.columns[i], org.apache.flex.html.supportClasses.DataGridColumn);
      var /** @type {number} */ colWidth = dataGridColumn.columnWidth;
      if (!isNaN(colWidth))
        list.width = colWidth;
      else
        list.width = listWidth;
      xpos += list.width;
    }
  }
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DataGridView.prototype.handleDataProviderChanged = function(event) {
  var /** @type {org.apache.flex.core.IDataGridModel} */ sharedModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.IDataGridModel);
  if (this._lists == null || this._lists.length == 0) {
    this.createLists();
  }
  for (var /** @type {number} */ i = 0; i < this._lists.length; i++) {
    var /** @type {org.apache.flex.html.List} */ list = org.apache.flex.utils.Language.as(this._lists[i], org.apache.flex.html.List);
    var /** @type {org.apache.flex.core.ISelectionModel} */ listModel = org.apache.flex.utils.Language.as(list.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.ISelectionModel);
    listModel.dataProvider = sharedModel.dataProvider;
  }
  this.handleSizeChanges(event);
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DataGridView.prototype.handleColumnListChange = function(event) {
  var /** @type {org.apache.flex.core.IDataGridModel} */ sharedModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.IDataGridModel);
  var /** @type {org.apache.flex.html.List} */ list = org.apache.flex.utils.Language.as(event.target, org.apache.flex.html.List);
  sharedModel.selectedIndex = list.selectedIndex;
  for (var /** @type {number} */ i = 0; i < this._lists.length; i++) {
    if (list != this._lists[i]) {
      var /** @type {org.apache.flex.html.List} */ otherList = org.apache.flex.utils.Language.as(this._lists[i], org.apache.flex.html.List);
      otherList.selectedIndex = list.selectedIndex;
    }
  }
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event('change'));
};


/**
 * @asprivate
 * @private
 */
org.apache.flex.html.beads.DataGridView.prototype.createLists = function() {
  var /** @type {org.apache.flex.core.IDataGridModel} */ sharedModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.IDataGridModel);
  var /** @type {org.apache.flex.html.beads.models.DataGridPresentationModel} */ presentationModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.html.beads.models.DataGridPresentationModel), org.apache.flex.html.beads.models.DataGridPresentationModel);
  var /** @type {number} */ listWidth = this.host.width / sharedModel.columns.length;
  this._lists = new Array();
  for (var /** @type {number} */ i = 0; i < sharedModel.columns.length; i++) {
    var /** @type {org.apache.flex.html.supportClasses.DataGridColumn} */ dataGridColumn = org.apache.flex.utils.Language.as(sharedModel.columns[i], org.apache.flex.html.supportClasses.DataGridColumn);
    var /** @type {org.apache.flex.html.List} */ list = new org.apache.flex.html.List();
    list.id = "dataGridColumn" + String(i);
    list.className = "DataGridColumn";
    list.addBead(sharedModel);
    list.itemRenderer = dataGridColumn.itemRenderer;
    list.labelField = dataGridColumn.dataField;
    list.addEventListener('change', org.apache.flex.utils.Language.closure(this.handleColumnListChange, this, 'handleColumnListChange'));
    list.addBead(presentationModel);
    var /** @type {number} */ colWidth = dataGridColumn.columnWidth;
    if (!isNaN(colWidth))
      list.width = colWidth;
    else
      list.width = listWidth;
    this._listArea.addElement(list);
    this._lists.push(list);
  }
  this._listArea.dispatchEvent(new org.apache.flex.events.Event("layoutNeeded"));
};


Object.defineProperties(org.apache.flex.html.beads.DataGridView.prototype, /** @lends {org.apache.flex.html.beads.DataGridView.prototype} */ {
/** @export */
getColumnLists: {
get: /** @this {org.apache.flex.html.beads.DataGridView} */ function() {
  return this._lists;
}},
/** @export */
host: {
get: /** @this {org.apache.flex.html.beads.DataGridView} */ function() {
  return org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase);
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.DataGridView} */ function(value) {
  this._strand = value;
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(value, org.apache.flex.core.UIBase);
  host.addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.handleSizeChanges, this, 'handleSizeChanges'));
  host.addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.handleSizeChanges, this, 'handleSizeChanges'));
  this._header = new org.apache.flex.html.DataGridButtonBar();
  this._header.id = "dataGridHeader";
  var /** @type {org.apache.flex.html.supportClasses.ScrollingViewport} */ scrollPort = new org.apache.flex.html.supportClasses.ScrollingViewport();
  this._listArea = new org.apache.flex.html.Container();
  this._listArea.id = "dataGridListArea";
  this._listArea.className = "DataGridListArea";
  this._listArea.addBead(scrollPort);
  this.finishSetup(null);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.DataGridView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DataGridView', qName: 'org.apache.flex.html.beads.DataGridView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.DataGridView', org.apache.flex.html.beads.DataGridView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.DataGridView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'getColumnLists': { type: 'Array', declaredBy: 'org.apache.flex.html.beads.DataGridView'},
        'host': { type: 'IUIBase', declaredBy: 'org.apache.flex.html.beads.DataGridView'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.DataGridView'}
      };
    },
    methods: function () {
      return {
        'DataGridView': { type: '', declaredBy: 'org.apache.flex.html.beads.DataGridView'}
      };
    }
  };
};