/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/DataGridLinesBead.as
 * org.apache.flex.html.beads.DataGridLinesBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.DataGridLinesBead');

goog.require('org.apache.flex.collections.ArrayList');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.graphics.SolidColorStroke');
goog.require('org.apache.flex.html.beads.models.DataGridPresentationModel');
goog.require('org.apache.flex.html.supportClasses.DataGridColumn');
goog.require('org.apache.flex.svg.CompoundGraphic');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.core.IDataGridModel');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IParentIUIBase');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 */
org.apache.flex.html.beads.DataGridLinesBead = function() {
  var /** @type {org.apache.flex.graphics.SolidColorStroke} */ lineStroke = new org.apache.flex.graphics.SolidColorStroke();
  lineStroke.color = 0x333333;
  lineStroke.alpha = 1.0;
  lineStroke.weight = 1;
  this.stroke = lineStroke;
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.DataGridLinesBead.prototype._strand;


/**
 * @private
 * @type {org.apache.flex.graphics.IStroke}
 */
org.apache.flex.html.beads.DataGridLinesBead.prototype._stroke;


/**
 * @private
 * @type {org.apache.flex.svg.CompoundGraphic}
 */
org.apache.flex.html.beads.DataGridLinesBead.prototype._overlay;


/**
 * @private
 * @type {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.beads.DataGridLinesBead.prototype._area;


/**
 * Invoked when all of the beads have been added to the DataGrid. This
 * function seeks the Container that parents the lists that are the DataGrid's
 * columns. An overlay GraphicContainer is added to this Container so that the
 * grid lines will scroll with the rows.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DataGridLinesBead.prototype.handleBeadsAdded = function(event) {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  var /** @type {number} */ n = host.numElements;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.core.UIBase} */ child = org.apache.flex.utils.Language.as(host.getElementAt(i), org.apache.flex.core.UIBase);
    if (child.id == "dataGridListArea") {
      this._area = child;
      this._area.addElement(this._overlay);
      break;
    }
  }
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("sizeChanged", org.apache.flex.utils.Language.closure(this.drawLines, this, 'drawLines'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.drawLines, this, 'drawLines'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.drawLines, this, 'drawLines'));
  var /** @type {org.apache.flex.core.IBeadModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.IBeadModel);
  org.apache.flex.utils.Language.as(model, org.apache.flex.events.IEventDispatcher, true).addEventListener("dataProviderChanged", org.apache.flex.utils.Language.closure(this.drawLines, this, 'drawLines'));
};


/**
 * This event handler is invoked whenever something happens to the DataGrid. This
 * function draws the lines either using a default stroke or the one specified by
 * the stroke property.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DataGridLinesBead.prototype.drawLines = function(event) {
  var /** @type {org.apache.flex.core.IDataGridModel} */ sharedModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.IDataGridModel);
  var /** @type {org.apache.flex.html.beads.models.DataGridPresentationModel} */ presentationModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.html.beads.models.DataGridPresentationModel), org.apache.flex.html.beads.models.DataGridPresentationModel);
  var /** @type {org.apache.flex.core.ILayoutHost} */ layoutParent = org.apache.flex.utils.Language.as(this._area.getBeadByType(org.apache.flex.core.ILayoutHost), org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = org.apache.flex.utils.Language.as(layoutParent.contentView, org.apache.flex.core.IParentIUIBase);
  var /** @type {Array} */ columns = sharedModel.columns;
  var /** @type {org.apache.flex.collections.ArrayList} */ arrayList = org.apache.flex.utils.Language.as(sharedModel.dataProvider, org.apache.flex.collections.ArrayList);
  var /** @type {number} */ rowHeight = presentationModel.rowHeight;
  var /** @type {number} */ totalHeight = arrayList.length * rowHeight;
  var /** @type {number} */ columnWidth = this._area.width / columns.length;
  var /** @type {org.apache.flex.graphics.SolidColor} */ lineFill = new org.apache.flex.graphics.SolidColor();
  var /** @type {number} */ weight = 1;
  lineFill.color = org.apache.flex.utils.Language.as(this.stroke, org.apache.flex.graphics.SolidColorStroke).color;
  lineFill.alpha = org.apache.flex.utils.Language.as(this.stroke, org.apache.flex.graphics.SolidColorStroke).alpha;
  weight = org.apache.flex.utils.Language.as(this.stroke, org.apache.flex.graphics.SolidColorStroke).weight;
  this._overlay.fill = lineFill;
  columnWidth = org.apache.flex.utils.Language.as(columns[0], org.apache.flex.html.supportClasses.DataGridColumn).columnWidth;
  var /** @type {number} */ xpos = isNaN(columnWidth) ? this._area.width / columns.length : columnWidth;
  this._overlay.clear();
  for (var /** @type {number} */ i = 1; i < columns.length; i++) {
    this._overlay.drawRect(xpos, 0, weight, totalHeight);
    columnWidth = org.apache.flex.utils.Language.as(columns[i], org.apache.flex.html.supportClasses.DataGridColumn).columnWidth;
    xpos += isNaN(columnWidth) ? this._area.width / columns.length : columnWidth;
  }
  var /** @type {number} */ n = arrayList.length;
  for (i = 1; i < n + 1; i++) {
    this._overlay.drawRect(0, i * rowHeight, this._area.width, weight);
  }
};


Object.defineProperties(org.apache.flex.html.beads.DataGridLinesBead.prototype, /** @lends {org.apache.flex.html.beads.DataGridLinesBead.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.DataGridLinesBead} */ function(value) {
  this._strand = value;
  this._overlay = new org.apache.flex.svg.CompoundGraphic();
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("beadsAdded", org.apache.flex.utils.Language.closure(this.handleBeadsAdded, this, 'handleBeadsAdded'));
}},
/** @export */
stroke: {
get: /** @this {org.apache.flex.html.beads.DataGridLinesBead} */ function() {
  return this._stroke;
},
set: /** @this {org.apache.flex.html.beads.DataGridLinesBead} */ function(value) {
  this._stroke = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.DataGridLinesBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DataGridLinesBead', qName: 'org.apache.flex.html.beads.DataGridLinesBead'}], interfaces: [org.apache.flex.core.IBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.DataGridLinesBead', org.apache.flex.html.beads.DataGridLinesBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.DataGridLinesBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.DataGridLinesBead'},
        'stroke': { type: 'IStroke', declaredBy: 'org.apache.flex.html.beads.DataGridLinesBead'}
      };
    },
    methods: function () {
      return {
        'DataGridLinesBead': { type: '', declaredBy: 'org.apache.flex.html.beads.DataGridLinesBead'}
      };
    }
  };
};