/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/accessories/NumericOnlyTextInputBead.as
 * org.apache.flex.html.accessories.NumericOnlyTextInputBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.accessories.NumericOnlyTextInputBead');

goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 */
org.apache.flex.html.accessories.NumericOnlyTextInputBead = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.accessories.NumericOnlyTextInputBead.prototype._strand;


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.accessories.NumericOnlyTextInputBead.prototype._decimalSeparator = ".";


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.accessories.NumericOnlyTextInputBead.prototype._maxChars = 0;


/**
 * @private
 * @param {goog.events.BrowserEvent} event
 */
org.apache.flex.html.accessories.NumericOnlyTextInputBead.prototype.validateInput = function(event) {
  var /** @type {number} */ code = event.charCode;
  if (event.keyCode == 8 || event.keyCode == 46)
    return;
  if (event.keyCode == 9 || event.keyCode == 13)
    return;
  if (event.keyCode == 37 || event.keyCode == 39)
    return;
  var /** @type {string} */ key = String.fromCharCode(code);
  var /** @type {RegExp} */ regex = /[0-9]|\./;
  if (!regex.test(key)) {
    event["returnValue"] = false;
    if (org.apache.flex.utils.Language.closure(event.preventDefault, event, 'preventDefault'))
      event.preventDefault();
    return;
  }
  var /** @type {number} */ cursorStart = Number(event.target.selectionStart);
  var /** @type {number} */ cursorEnd = Number(event.target.selectionEnd);
  var /** @type {string} */ left = org.apache.flex.utils.Language.string(event.target.value.substring(0, cursorStart));
  var /** @type {string} */ right = org.apache.flex.utils.Language.string(event.target.value.substr(cursorEnd));
  var /** @type {string} */ complete = left + key + right;
  if (isNaN(parseFloat(complete))) {
    event["returnValue"] = false;
    if (org.apache.flex.utils.Language.closure(event.preventDefault, event, 'preventDefault'))
      event.preventDefault();
  }
};


Object.defineProperties(org.apache.flex.html.accessories.NumericOnlyTextInputBead.prototype, /** @lends {org.apache.flex.html.accessories.NumericOnlyTextInputBead.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.accessories.NumericOnlyTextInputBead} */ function(value) {
  this._strand = value;
  
  org.apache.flex.utils.Language.as(value, org.apache.flex.events.IEventDispatcher, true).addEventListener("keypress", org.apache.flex.utils.Language.closure(this.validateInput, this, 'validateInput'));
}},
/** @export */
decimalSeparator: {
get: /** @this {org.apache.flex.html.accessories.NumericOnlyTextInputBead} */ function() {
  return this._decimalSeparator;
},
set: /** @this {org.apache.flex.html.accessories.NumericOnlyTextInputBead} */ function(value) {
  if (this._decimalSeparator != value) {
    this._decimalSeparator = value;
  }
}},
/** @export */
maxChars: {
get: /** @this {org.apache.flex.html.accessories.NumericOnlyTextInputBead} */ function() {
  return this._maxChars;
},
set: /** @this {org.apache.flex.html.accessories.NumericOnlyTextInputBead} */ function(value) {
  if (this._maxChars != value) {
    this._maxChars = value;
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.accessories.NumericOnlyTextInputBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'NumericOnlyTextInputBead', qName: 'org.apache.flex.html.accessories.NumericOnlyTextInputBead'}], interfaces: [org.apache.flex.core.IBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.accessories.NumericOnlyTextInputBead', org.apache.flex.html.accessories.NumericOnlyTextInputBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.accessories.NumericOnlyTextInputBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.accessories.NumericOnlyTextInputBead'},
        'decimalSeparator': { type: 'String', declaredBy: 'org.apache.flex.html.accessories.NumericOnlyTextInputBead'},
        'maxChars': { type: 'int', declaredBy: 'org.apache.flex.html.accessories.NumericOnlyTextInputBead'}
      };
    },
    methods: function () {
      return {
        'NumericOnlyTextInputBead': { type: '', declaredBy: 'org.apache.flex.html.accessories.NumericOnlyTextInputBead'}
      };
    }
  };
};