/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/TextInput.as
 * org.apache.flex.html.TextInput
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.TextInput');

goog.require('goog.events');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.TextInput = function() {
  org.apache.flex.html.TextInput.base(this, 'constructor');
  
};
goog.inherits(org.apache.flex.html.TextInput, org.apache.flex.core.UIBase);


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.TextInput.prototype.inSetter;


/**
 *  dispatch change event in response to a textChange event
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.TextInput.prototype.textChangeHandler = function(event) {
  if (!this.inSetter)
    this.dispatchEvent(new org.apache.flex.events.Event(org.apache.flex.events.Event.CHANGE));
};


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.TextInput.prototype.createElement = function() {
  this.element = document.createElement('input');
  this.element.setAttribute('type', 'input');
  this.element.className = 'TextInput';
  this.typeNames = 'TextInput';
  goog.events.listen(this.element, 'input', org.apache.flex.utils.Language.closure(this.textChangeHandler, this, 'textChangeHandler'));
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  return this.element;
};


Object.defineProperties(org.apache.flex.html.TextInput.prototype, /** @lends {org.apache.flex.html.TextInput.prototype} */ {
/** @export */
text: {
get: /** @this {org.apache.flex.html.TextInput} */ function() {
  
  return this.element.value;
},
set: /** @this {org.apache.flex.html.TextInput} */ function(value) {
  
  this.element.value = value;
  this.dispatchEvent(new org.apache.flex.events.Event('textChange'));
}},
/** @export */
html: {
get: /** @this {org.apache.flex.html.TextInput} */ function() {
  
  return this.element.value;
},
set: /** @this {org.apache.flex.html.TextInput} */ function(value) {
  
  this.element.value = value;
  this.dispatchEvent(new org.apache.flex.events.Event('textChange'));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.TextInput.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'TextInput', qName: 'org.apache.flex.html.TextInput'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.TextInput', org.apache.flex.html.TextInput);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.TextInput.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'text': { type: 'String', declaredBy: 'org.apache.flex.html.TextInput'},
        'html': { type: 'String', declaredBy: 'org.apache.flex.html.TextInput'}
      };
    },
    methods: function () {
      return {
        'TextInput': { type: '', declaredBy: 'org.apache.flex.html.TextInput'},
        'textChangeHandler': { type: 'void', declaredBy: 'org.apache.flex.html.TextInput'}
      };
    },
    metadata: function () { return [ ]; }
  };
};