/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/SimpleList.as
 * org.apache.flex.html.SimpleList
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.SimpleList');

goog.require('goog.events');
goog.require('org.apache.flex.html.List');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.List}
 */
org.apache.flex.html.SimpleList = function() {
  org.apache.flex.html.SimpleList.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.SimpleList, org.apache.flex.html.List);


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @flexjsignorecoercion HTMLSelectElement
 * @protected
 * @override
 */
org.apache.flex.html.SimpleList.prototype.createElement = function() {
  this.element = document.createElement('select');
  this.element.size = 5;
  goog.events.listen(this.element, 'change', org.apache.flex.utils.Language.closure(this.changeHandler, this, 'changeHandler'));
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.className = 'SimpleList';
  return this.element;
};


/**
 * @flexjsignorecoercion HTMLSelectElement
 * @protected
 * @param {Event} event
 */
org.apache.flex.html.SimpleList.prototype.changeHandler = function(event) {
  this.model.selectedIndex = this.element.selectedIndex;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.SimpleList.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SimpleList', qName: 'org.apache.flex.html.SimpleList'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.SimpleList', org.apache.flex.html.SimpleList);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.SimpleList.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'SimpleList': { type: '', declaredBy: 'org.apache.flex.html.SimpleList'}
      };
    }
  };
};