/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/Label.as
 * org.apache.flex.html.Label
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.Label');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.Label = function() {
  org.apache.flex.html.Label.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.Label, org.apache.flex.core.UIBase);


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.Label.prototype._selectable;


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.Label.prototype.createElement = function() {
  this.element = document.createElement('span');
  this.positioner = this.element;
  this.element.flexjs_wrapper = this;
  this.element.style.whiteSpace = "nowrap";
  if (!this.selectable) {
    this.element.style.cursor = "default";
    this.element.style.pointerEvents = "none";
  }
  this.className = "Label";
  this.typeNames = "Label";
  return this.element;
};


Object.defineProperties(org.apache.flex.html.Label.prototype, /** @lends {org.apache.flex.html.Label.prototype} */ {
/** @export */
text: {
get: /** @this {org.apache.flex.html.Label} */ function() {
  
  return this.element.innerHTML;
},
set: /** @this {org.apache.flex.html.Label} */ function(value) {
  
  this.element.innerHTML = value;
  this.dispatchEvent('textChange');
}},
/** @export */
html: {
get: /** @this {org.apache.flex.html.Label} */ function() {
  
  return this.element.innerHTML;
},
set: /** @this {org.apache.flex.html.Label} */ function(value) {
  
  this.element.innerHTML = value;
  this.dispatchEvent('textChange');
}},
/** @export */
selectable: {
get: /** @this {org.apache.flex.html.Label} */ function() {
  return this._selectable;
},
set: /** @this {org.apache.flex.html.Label} */ function(value) {
  if (value != this._selectable) {
    this._selectable = value;
    if (this.element) {
      this.element.style.cursor = this._selectable ? "auto" : "default";
      this.element.style.pointerEvents = this._selectable ? "auto" : "none";
    }
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.Label.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Label', qName: 'org.apache.flex.html.Label'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.Label', org.apache.flex.html.Label);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.Label.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'text': { type: 'String', declaredBy: 'org.apache.flex.html.Label', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'textChange'}]}]; }},
        'html': { type: 'String', declaredBy: 'org.apache.flex.html.Label', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'htmlChange'}]}]; }},
        'selectable': { type: 'Boolean', declaredBy: 'org.apache.flex.html.Label'}
      };
    },
    methods: function () {
      return {
        'Label': { type: '', declaredBy: 'org.apache.flex.html.Label'}
      };
    }
  };
};