/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/DropDownList.as
 * org.apache.flex.html.DropDownList
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.DropDownList');

goog.require('goog.events');
goog.require('org.apache.flex.html.Button');
goog.require('org.apache.flex.html.beads.models.ArraySelectionModel');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.Button}
 */
org.apache.flex.html.DropDownList = function() {
  org.apache.flex.html.DropDownList.base(this, 'constructor');
  this.model = new org.apache.flex.html.beads.models.ArraySelectionModel();
};
goog.inherits(org.apache.flex.html.DropDownList, org.apache.flex.html.Button);


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @flexjsignorecoercion HTMLSelectElement
 * @protected
 * @override
 */
org.apache.flex.html.DropDownList.prototype.createElement = function() {
  this.element = document.createElement('select');
  this.element.size = 1;
  goog.events.listen(this.element, 'change', org.apache.flex.utils.Language.closure(this.changeHandler, this, 'changeHandler'));
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  return this.element;
};


/**
 * @flexjsignorecoercion HTMLSelectElement
 * @protected
 * @param {Event} event
 */
org.apache.flex.html.DropDownList.prototype.changeHandler = function(event) {
  this.model.selectedIndex = this.element.selectedIndex;
};


Object.defineProperties(org.apache.flex.html.DropDownList.prototype, /** @lends {org.apache.flex.html.DropDownList.prototype} */ {
/** @export */
dataProvider: {
get: /** @this {org.apache.flex.html.DropDownList} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).dataProvider;
},
set: /** @this {org.apache.flex.html.DropDownList} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).dataProvider = value;
  var /** @type {HTMLOptionsCollection} */ dp;
  var /** @type {number} */ i;
  var /** @type {number} */ n;
  var /** @type {HTMLOptionElement} */ opt;
  var /** @type {HTMLSelectElement} */ dd = this.element;
  this.model.dataProvider = value;
  dp = dd.options;
  n = dp.length;
  for (i = 0; i < n; i++) {
    dd.remove(0);
  }
  var /** @type {string} */ lf = this.labelField;
  n = Number(value.length);
  for (i = 0; i < n; i++) {
    opt = document.createElement('option');
    if (lf)
      opt.text = org.apache.flex.utils.Language.string(value[i][lf]);
    else
      opt.text = org.apache.flex.utils.Language.string(value[i]);
    dd.add(opt, null);
  }
}},
/** @export */
selectedIndex: {
get: /** @this {org.apache.flex.html.DropDownList} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedIndex;
},
set: /** @this {org.apache.flex.html.DropDownList} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedIndex = value;
  this.element.selectedIndex = org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedIndex;
}},
/** @export */
selectedItem: {
get: /** @this {org.apache.flex.html.DropDownList} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedItem;
},
set: /** @this {org.apache.flex.html.DropDownList} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedItem = value;
  this.element.selectedIndex = org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedIndex;
}},
/** @export */
labelField: {
get: /** @this {org.apache.flex.html.DropDownList} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).labelField;
},
set: /** @this {org.apache.flex.html.DropDownList} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).labelField = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.DropDownList.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DropDownList', qName: 'org.apache.flex.html.DropDownList'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.DropDownList', org.apache.flex.html.DropDownList);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.DropDownList.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'dataProvider': { type: 'Object', declaredBy: 'org.apache.flex.html.DropDownList'},
        'selectedIndex': { type: 'int', declaredBy: 'org.apache.flex.html.DropDownList', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'change'}]}]; }},
        'selectedItem': { type: 'Object', declaredBy: 'org.apache.flex.html.DropDownList', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'change'}]}]; }},
        'labelField': { type: 'String', declaredBy: 'org.apache.flex.html.DropDownList'}
      };
    },
    methods: function () {
      return {
        'DropDownList': { type: '', declaredBy: 'org.apache.flex.html.DropDownList'}
      };
    },
    metadata: function () { return [ ]; }
  };
};