/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/DateField.as
 * org.apache.flex.html.DateField
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.DateField');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDateChooserModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.DateField = function() {
  org.apache.flex.html.DateField.base(this, 'constructor');
  this.className = "DateField";
};
goog.inherits(org.apache.flex.html.DateField, org.apache.flex.core.UIBase);


/**
 * The method called when added to a parent. The DateField class uses
 * this opportunity to install additional beads.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.html.DateField.prototype.addedToParent = function() {
  var /** @type {*} */ klass = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iFormatBead");
  var /** @type {org.apache.flex.core.IBead} */ bead = org.apache.flex.utils.Language.as(new klass(), org.apache.flex.core.IBead);
  if (bead) {
    this.addBead(bead);
  }
  org.apache.flex.html.DateField.base(this, 'addedToParent');
};


Object.defineProperties(org.apache.flex.html.DateField.prototype, /** @lends {org.apache.flex.html.DateField.prototype} */ {
/** @export */
selectedDate: {
get: /** @this {org.apache.flex.html.DateField} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IDateChooserModel, true).selectedDate;
},
set: /** @this {org.apache.flex.html.DateField} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IDateChooserModel, true).selectedDate = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.DateField.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DateField', qName: 'org.apache.flex.html.DateField'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.DateField', org.apache.flex.html.DateField);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.DateField.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'selectedDate': { type: 'Date', declaredBy: 'org.apache.flex.html.DateField'}
      };
    },
    methods: function () {
      return {
        'DateField': { type: '', declaredBy: 'org.apache.flex.html.DateField'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.html.DateField'}
      };
    },
    metadata: function () { return [ ]; }
  };
};