/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/ComboBox.as
 * org.apache.flex.html.ComboBox
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.ComboBox');

goog.require('goog.events');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.IComboBoxModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.ComboBox = function() {
  org.apache.flex.html.ComboBox.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.ComboBox, org.apache.flex.core.UIBase);


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.ComboBox.prototype.createElement = function() {
  var /** @type {Object} */ button;
  var /** @type {Object} */ input;
  this.element = document.createElement('div');
  input = document.createElement('input');
  input.style.position = 'absolute';
  input.style.width = '80px';
  this.element.appendChild(input);
  button = document.createElement('div');
  button.style.position = 'absolute';
  button.style.top = '0px';
  button.style.right = '0px';
  button.style.background = '#bbb';
  button.style.width = '16px';
  button.style.height = '20px';
  button.style.margin = '0';
  button.style.border = 'solid #609 1px';
  goog.events.listen(button, 'click', org.apache.flex.utils.Language.closure(this.buttonClicked, this, 'buttonClicked'));
  this.element.appendChild(button);
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  goog.events.listen(document, 'click', org.apache.flex.utils.Language.closure(this.dismissPopup, this, 'dismissPopup'));
  input.flexjs_wrapper = this;
  return this.element;
};


/**
 * @private
 * @type {HTMLElement}
 */
org.apache.flex.html.ComboBox.prototype.popup;


/**
 * @asparam event The event.
 * @flexjsignorecoercion HTMLSelectElement
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.ComboBox.prototype.selectChanged = function(event) {
  var /** @type {HTMLSelectElement} */ select;
  select = event.currentTarget;
  this.selectedItem = select.options[select.selectedIndex].value;
  this.popup.parentNode.removeChild(this.popup);
  this.popup = null;
  this.dispatchEvent(event);
};


/**
 * @asparam event The event.
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.ComboBox.prototype.dismissPopup = function(event) {
  if (this.popup) {
    this.popup.parentNode.removeChild(this.popup);
    this.popup = null;
  }
};


/**
 * @export
 * @asparam {Object} event The event.
 * @flexjsignorecoercion HTMLInputElement
 * @flexjsignorecoercion HTMLElement
 * @flexjsignorecoercion HTMLSelectElement
 * @flexjsignorecoercion HTMLOptionElement
 * @flexjsignorecoercion Array
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.ComboBox.prototype.buttonClicked = function(event) {
  var /** @type {Array} */ dp;
  var /** @type {number} */ i;
  var /** @type {HTMLInputElement} */ input;
  var /** @type {number} */ left;
  var /** @type {number} */ n;
  var /** @type {HTMLOptionElement} */ opt;
  var /** @type {HTMLElement} */ pn;
  var /** @type {HTMLElement} */ popup;
  var /** @type {HTMLSelectElement} */ select;
  var /** @type {number} */ si;
  var /** @type {number} */ top;
  var /** @type {number} */ width;
  event.stopPropagation();
  if (popup) {
    this.dismissPopup(null);
    return;
  }
  input = this.element.childNodes.item(0);
  pn = this.element;
  top = pn.offsetTop + input.offsetHeight;
  left = pn.offsetLeft;
  width = pn.offsetWidth;
  popup = document.createElement('div');
  popup.className = 'popup';
  popup.id = 'test';
  popup.style.position = 'absolute';
  popup.style.top = top.toString() + 'px';
  popup.style.left = left.toString() + 'px';
  popup.style.width = width.toString() + 'px';
  popup.style.margin = '0px auto';
  popup.style.padding = '0px';
  popup.style.zIndex = '10000';
  select = document.createElement('select');
  select.style.width = width.toString() + 'px';
  goog.events.listen(select, 'change', org.apache.flex.utils.Language.closure(this.selectChanged, this, 'selectChanged'));
  dp = this.dataProvider;
  n = dp.length;
  for (i = 0; i < n; i++) {
    opt = document.createElement('option');
    opt.text = org.apache.flex.utils.Language.string(dp[i]);
    select.add(opt, null);
  }
  select.size = n;
  si = this.selectedIndex;
  if (si < 0) {
    select.value = null;
  } else {
    select.value = org.apache.flex.utils.Language.string(dp[si]);
  }
  this.popup = popup;
  popup.appendChild(select);
  document.body.appendChild(popup);
};


Object.defineProperties(org.apache.flex.html.ComboBox.prototype, /** @lends {org.apache.flex.html.ComboBox.prototype} */ {
/** @export */
dataProvider: {
get: /** @this {org.apache.flex.html.ComboBox} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IComboBoxModel, true).dataProvider;
},
set: /** @this {org.apache.flex.html.ComboBox} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IComboBoxModel, true).dataProvider = value;
}},
/** @export */
selectedIndex: {
get: /** @this {org.apache.flex.html.ComboBox} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IComboBoxModel, true).selectedIndex;
},
set: /** @this {org.apache.flex.html.ComboBox} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IComboBoxModel, true).selectedIndex = value;
}},
/** @export */
selectedItem: {
get: /** @this {org.apache.flex.html.ComboBox} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IComboBoxModel, true).selectedItem;
},
set: /** @this {org.apache.flex.html.ComboBox} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IComboBoxModel, true).selectedItem = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.ComboBox.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ComboBox', qName: 'org.apache.flex.html.ComboBox'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.ComboBox', org.apache.flex.html.ComboBox);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.ComboBox.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'dataProvider': { type: 'Object', declaredBy: 'org.apache.flex.html.ComboBox'},
        'selectedIndex': { type: 'int', declaredBy: 'org.apache.flex.html.ComboBox'},
        'selectedItem': { type: 'Object', declaredBy: 'org.apache.flex.html.ComboBox'}
      };
    },
    methods: function () {
      return {
        'ComboBox': { type: '', declaredBy: 'org.apache.flex.html.ComboBox'}
      };
    },
    metadata: function () { return [ ]; }
  };
};