/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/Alert.as
 * org.apache.flex.html.Alert
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.Alert');

goog.require('goog.events');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.Container');
goog.require('org.apache.flex.html.Label');
goog.require('org.apache.flex.html.TextButton');
goog.require('org.apache.flex.html.TitleBar');
goog.require('org.apache.flex.core.IAlertModel');
goog.require('org.apache.flex.core.IPopUp');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 * @implements {org.apache.flex.core.IPopUp}
 */
org.apache.flex.html.Alert = function() {
  org.apache.flex.html.Alert.base(this, 'constructor');
  this.className = "Alert";
};
goog.inherits(org.apache.flex.html.Alert, org.apache.flex.core.UIBase);


/**
 * @export
 * @const
 * @type {number}
 */
org.apache.flex.html.Alert.YES = 0x000001;


/**
 * @export
 * @const
 * @type {number}
 */
org.apache.flex.html.Alert.NO = 0x000002;


/**
 * @export
 * @const
 * @type {number}
 */
org.apache.flex.html.Alert.OK = 0x000004;


/**
 * @export
 * @const
 * @type {number}
 */
org.apache.flex.html.Alert.CANCEL = 0x000008;


/**
 * @private
 * @type {org.apache.flex.html.TitleBar}
 */
org.apache.flex.html.Alert.prototype.titleBar;


/**
 * @private
 * @type {org.apache.flex.html.Label}
 */
org.apache.flex.html.Alert.prototype.label;


/**
 * @private
 * @type {org.apache.flex.html.Container}
 */
org.apache.flex.html.Alert.prototype.buttonArea;


/**
 * @override
 * @protected
 * @override
 */
org.apache.flex.html.Alert.prototype.createElement = function() {
  org.apache.flex.html.Alert.base(this, 'createElement');
  this.element.className = 'Alert';
  this.titleBar = new org.apache.flex.html.TitleBar();
  this.addElement(this.titleBar);
  this.titleBar.element.id = 'titleBar';
  this.label = new org.apache.flex.html.Label();
  this.addElement(this.label);
  this.label.element.id = 'message';
  this.buttonArea = new org.apache.flex.html.Container();
  this.addElement(this.buttonArea);
  this.buttonArea.element.id = 'buttonArea';
  return this.element;
};


/**
 *  This static method is a convenience function to quickly create and display an Alert. The
 *  text and parent paramters are required, the others will default.
 * 
 *  @asparam String text The message content of the Alert.
 *  @asparam Object parent The object that hosts the pop-up.
 *  @asparam String title An optional title for the Alert.
 *  @asparam uint flags Identifies which buttons to display in the alert.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} text
 * @param {Object} parent
 * @param {string=} title
 * @param {number=} flags
 */
org.apache.flex.html.Alert.show = function(text, parent, title, flags) {
  title = typeof title !== 'undefined' ? title : "";
  flags = typeof flags !== 'undefined' ? flags : Alert.OK;
  var /** @type {org.apache.flex.html.Alert} */ alert = new org.apache.flex.html.Alert();
  alert.message = text;
  alert.title = title;
  alert.flags = flags;
  alert.show(parent);
  alert.positioner.style.position = 'relative';
  alert.positioner.style.width = '200px';
  alert.positioner.style.margin = 'auto';
  alert.positioner.style.top = '100px';
};


/**
 *  Shows the Alert anchored to the given parent object which is usally a root component such
 *  as a UIView..
 * 
 *  @asparam Object parent The object that hosts the pop-up.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} parent
 */
org.apache.flex.html.Alert.prototype.show = function(parent) {
  parent.addElement(this);
};


/**
 * @asparam event The event object.
 * @flexjsignorecoercion HTMLElement
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.Alert.prototype.dismissAlert = function(event) {
  var /** @type {HTMLElement} */ htmlElement = this.element;
  htmlElement.parentElement.removeChild(this.element);
};


Object.defineProperties(org.apache.flex.html.Alert.prototype, /** @lends {org.apache.flex.html.Alert.prototype} */ {
/** @export */
title: {
get: /** @this {org.apache.flex.html.Alert} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IAlertModel, true).title;
},
set: /** @this {org.apache.flex.html.Alert} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IAlertModel, true).title = value;
}},
/** @export */
message: {
get: /** @this {org.apache.flex.html.Alert} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IAlertModel, true).message;
},
set: /** @this {org.apache.flex.html.Alert} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IAlertModel, true).message = value;
}},
/** @export */
flags: {
get: /** @this {org.apache.flex.html.Alert} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IAlertModel, true).flags;
},
set: /** @this {org.apache.flex.html.Alert} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IAlertModel, true).flags = value;
  if (this.flags & org.apache.flex.html.Alert.OK) {
    var /** @type {org.apache.flex.html.TextButton} */ ok = new org.apache.flex.html.TextButton();
    this.buttonArea.addElement(ok);
    ok.text = 'OK';
    goog.events.listen(ok.element, 'click', org.apache.flex.utils.Language.closure(this.dismissAlert, this, 'dismissAlert'));
  }
  if (this.flags & org.apache.flex.html.Alert.CANCEL) {
    var /** @type {org.apache.flex.html.TextButton} */ cancel = new org.apache.flex.html.TextButton();
    this.buttonArea.addElement(cancel);
    cancel.text = 'Cancel';
    goog.events.listen(cancel.element, 'click', org.apache.flex.utils.Language.closure(this.dismissAlert, this, 'dismissAlert'));
  }
  if (this.flags & org.apache.flex.html.Alert.YES) {
    var /** @type {org.apache.flex.html.TextButton} */ yes = new org.apache.flex.html.TextButton();
    this.buttonArea.addElement(yes);
    yes.text = 'YES';
    goog.events.listen(yes.element, 'click', org.apache.flex.utils.Language.closure(this.dismissAlert, this, 'dismissAlert'));
  }
  if (this.flags & org.apache.flex.html.Alert.NO) {
    var /** @type {org.apache.flex.html.TextButton} */ nob = new org.apache.flex.html.TextButton();
    this.buttonArea.addElement(nob);
    nob.text = 'NO';
    goog.events.listen(nob.element, 'click', org.apache.flex.utils.Language.closure(this.dismissAlert, this, 'dismissAlert'));
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.Alert.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Alert', qName: 'org.apache.flex.html.Alert'}], interfaces: [org.apache.flex.core.IPopUp] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.Alert', org.apache.flex.html.Alert);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.Alert.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'title': { type: 'String', declaredBy: 'org.apache.flex.html.Alert'},
        'message': { type: 'String', declaredBy: 'org.apache.flex.html.Alert'},
        'flags': { type: 'uint', declaredBy: 'org.apache.flex.html.Alert'}
      };
    },
    methods: function () {
      return {
        'Alert': { type: '', declaredBy: 'org.apache.flex.html.Alert'},
        'show': { type: 'void', declaredBy: 'org.apache.flex.html.Alert'}
      };
    }
  };
};