/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/svg/CompoundGraphic.as
 * org.apache.flex.svg.CompoundGraphic
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.svg.CompoundGraphic');

goog.require('org.apache.flex.graphics.PathBuilder');
goog.require('org.apache.flex.svg.GraphicShape');
goog.require('org.apache.flex.svg.Text');
goog.require('org.apache.flex.graphics.ICompoundGraphic');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.svg.GraphicShape}
 * @implements {org.apache.flex.graphics.ICompoundGraphic}
 */
org.apache.flex.svg.CompoundGraphic = function() {
  org.apache.flex.svg.CompoundGraphic.base(this, 'constructor');
};
goog.inherits(org.apache.flex.svg.CompoundGraphic, org.apache.flex.svg.GraphicShape);


/**
 * @private
 * @type {org.apache.flex.graphics.IFill}
 */
org.apache.flex.svg.CompoundGraphic.prototype._textFill;


/**
 * @private
 * @type {org.apache.flex.graphics.IStroke}
 */
org.apache.flex.svg.CompoundGraphic.prototype._textStroke;


/**
 *  Removes all of the drawn elements of the container.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0.3
 * @export
 */
org.apache.flex.svg.CompoundGraphic.prototype.removeAllElements = function() {
  this.clear();
};


/**
 *  Clears all of the drawn path data.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7.0
 * @export
 */
org.apache.flex.svg.CompoundGraphic.prototype.clear = function() {
  
  var /** @type {HTMLElement} */ svg = this.element;
  while (svg.lastChild) {
    svg.removeChild(svg.lastChild);
  }
};


/**
 *  Draw the rectangle.
 *  @asparam x The x position of the top-left corner of the rectangle.
 *  @asparam y The y position of the top-left corner.
 *  @asparam width The width of the rectangle.
 *  @asparam height The height of the rectangle.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0.3
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 */
org.apache.flex.svg.CompoundGraphic.prototype.drawRect = function(x, y, width, height) {
  
  this.drawRoundRect(x, y, width, height, NaN);
};


/**
 *  Draws a rounded rectangle.
 *  Note: The radius values are different than the Flash API of the same name. Flash uses diameter instead of radius.
 *  @asparam x The x position of the top-left corner of the rectangle.
 *  @asparam y The y position of the top-left corner.
 *  @asparam width The width of the rectangle.
 *  @asparam height The height of the rectangle.
 *  @asparam radiusX The horizontal radius of the rounded corners (in pixels).
 *  @asparam radiusY The vertical radius of the rounded corners (in pixels). Optional; if no value is specified, the default value matches that provided for the <code>radiusX</code> parameter.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0.3
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} radiusX
 * @param {number=} radiusY
 */
org.apache.flex.svg.CompoundGraphic.prototype.drawRoundRect = function(x, y, width, height, radiusX, radiusY) {
  radiusY = typeof radiusY !== 'undefined' ? radiusY : NaN;
  
  if (isNaN(radiusY))
    radiusY = radiusX;
  var /** @type {string} */ style = this.getStyleStr();
  var /** @type {Object} */ rect = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
  rect.flexjs_wrapper = this;
  rect.style.left = x;
  rect.style.top = y;
  rect.setAttribute('style', style);
  rect.setAttribute('x', x);
  rect.setAttribute('y', y);
  rect.setAttribute('width', width);
  rect.setAttribute('height', height);
  if (!isNaN(radiusX)) {
    rect.setAttribute('rx', radiusX);
    rect.setAttribute('ry', radiusY);
  }
  this.element.appendChild(rect);
};


/**
 *  Draw the ellipse.
 *  @asparam x The x position of the top-left corner of the bounding box of the ellipse.
 *  @asparam y The y position of the top-left corner of the bounding box of the ellipse.
 *  @asparam width The width of the ellipse.
 *  @asparam height The height of the ellipse.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0.3
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 */
org.apache.flex.svg.CompoundGraphic.prototype.drawEllipse = function(x, y, width, height) {
  
  var /** @type {string} */ style = this.getStyleStr();
  var /** @type {Object} */ ellipse = document.createElementNS('http://www.w3.org/2000/svg', 'ellipse');
  ellipse.flexjs_wrapper = this;
  ellipse.style.left = x;
  ellipse.style.top = y;
  ellipse.setAttribute('style', style);
  ellipse.setAttribute('cx', x + width / 2);
  ellipse.setAttribute('cy', y + height / 2);
  ellipse.setAttribute('rx', width / 2);
  ellipse.setAttribute('ry', height / 2);
  this.element.appendChild(ellipse);
};


/**
 *  Draw the circle.
 *  @asparam x The x location of the center of the circle
 *  @asparam y The y location of the center of the circle.
 *  @asparam radius The radius of the circle.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} radius
 */
org.apache.flex.svg.CompoundGraphic.prototype.drawCircle = function(x, y, radius) {
  
  var /** @type {string} */ style = this.getStyleStr();
  var /** @type {Object} */ circle = document.createElementNS('http://www.w3.org/2000/svg', 'ellipse');
  circle.flexjs_wrapper = this;
  circle.style.left = x;
  circle.style.top = y;
  circle.setAttribute('style', style);
  circle.setAttribute('cx', x);
  circle.setAttribute('cy', y);
  circle.setAttribute('rx', radius);
  circle.setAttribute('ry', radius);
  this.element.appendChild(circle);
};


/**
 *  Draw the path.
 *  @asparam data A PathBuilder object containing a vector of drawing commands.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @export
 * @param {org.apache.flex.graphics.PathBuilder} data
 */
org.apache.flex.svg.CompoundGraphic.prototype.drawPathCommands = function(data) {
  this.drawStringPath(data.getPathString());
};


/**
 *  Draw the path.
 *  @asparam data A string containing a compact represention of the path segments.
 *  The value is a space-delimited string describing each path segment. Each
 *  segment entry has a single character which denotes the segment type and
 *  two or more segment parameters.
 *
 *  If the segment command is upper-case, the parameters are absolute values.
 *  If the segment command is lower-case, the parameters are relative values.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @export
 * @param {string} data
 */
org.apache.flex.svg.CompoundGraphic.prototype.drawStringPath = function(data) {
  
  var /** @type {string} */ style = this.getStyleStr();
  var /** @type {Object} */ path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
  path.flexjs_wrapper = this;
  path.style.left = 0;
  path.style.top = 0;
  path.setAttribute('style', style);
  path.setAttribute('d', data);
  this.element.appendChild(path);
};


/**
 * @export
 */
org.apache.flex.svg.CompoundGraphic.prototype.drawLine = function() {
};


/**
 * @export
 */
org.apache.flex.svg.CompoundGraphic.prototype.drawPolygon = function() {
};


/**
 * Draws a rounded rectangle using the size of a radius to draw the rounded corners. 
 * You must set the line style, fill, or both 
 * on the Graphics object before 
 * you call the <code>drawRoundRectComplex()</code> method 
 * by calling the <code>linestyle()</code>, 
 * <code>lineGradientStyle()</code>, <code>beginFill()</code>, 
 * <code>beginGradientFill()</code>, or 
 * <code>beginBitmapFill()</code> method.
 * 
 * @asparam graphics The Graphics object that draws the rounded rectangle.
 *
 * @asparam x The horizontal position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam y The vertical position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam width The width of the round rectangle, in pixels.
 * 
 * @asparam height The height of the round rectangle, in pixels.
 * 
 * @asparam topLeftRadius The radius of the upper-left corner, in pixels.
 * 
 * @asparam topRightRadius The radius of the upper-right corner, in pixels.
 * 
 * @asparam bottomLeftRadius The radius of the bottom-left corner, in pixels.
 * 
 * @asparam bottomRightRadius The radius of the bottom-right corner, in pixels.
 *
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} topLeftRadius
 * @param {number} topRightRadius
 * @param {number} bottomLeftRadius
 * @param {number} bottomRightRadius
 */
org.apache.flex.svg.CompoundGraphic.prototype.drawRoundRectComplex = function(x, y, width, height, topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius) {
  
  var /** @type {org.apache.flex.graphics.PathBuilder} */ builder = new org.apache.flex.graphics.PathBuilder();
  builder.drawRoundRectComplex(x, y, width, height, topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius);
  this.drawStringPath(builder.getPathString());
};


/**
 * Draws a rounded rectangle using the size of individual x and y radii to 
 * draw the rounded corners. 
 * You must set the line style, fill, or both 
 * on the Graphics object before 
 * you call the <code>drawRoundRectComplex2()</code> method 
 * by calling the <code>linestyle()</code>, 
 * <code>lineGradientStyle()</code>, <code>beginFill()</code>, 
 * <code>beginGradientFill()</code>, or 
 * <code>beginBitmapFill()</code> method.
 * 
 * @asparam graphics The Graphics object that draws the rounded rectangle.
 *
 * @asparam x The horizontal position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam y The vertical position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam width The width of the round rectangle, in pixels.
 * 
 * @asparam height The height of the round rectangle, in pixels.
 * 
 * @asparam radiusX The default radiusX to use, if corner-specific values are not specified.
 * This value must be specified.
 * 
 * @asparam radiusY The default radiusY to use, if corner-specific values are not specified. 
 * If 0, the value of radiusX is used.
 * 
 * @asparam topLeftRadiusX The x radius of the upper-left corner, in pixels. If NaN, 
 * the value of radiusX is used.
 * 
 * @asparam topLeftRadiusY The y radius of the upper-left corner, in pixels. If NaN,
 * the value of topLeftRadiusX is used.
 * 
 * @asparam topRightRadiusX The x radius of the upper-right corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam topRightRadiusY The y radius of the upper-right corner, in pixels. If NaN,
 * the value of topRightRadiusX is used.
 * 
 * @asparam bottomLeftRadiusX The x radius of the bottom-left corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam bottomLeftRadiusY The y radius of the bottom-left corner, in pixels. If NaN,
 * the value of bottomLeftRadiusX is used.
 * 
 * @asparam bottomRightRadiusX The x radius of the bottom-right corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam bottomRightRadiusY The y radius of the bottom-right corner, in pixels. If NaN,
 * the value of bottomRightRadiusX is used.
 * 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} radiusX
 * @param {number} radiusY
 * @param {number} topLeftRadiusX
 * @param {number} topLeftRadiusY
 * @param {number} topRightRadiusX
 * @param {number} topRightRadiusY
 * @param {number} bottomLeftRadiusX
 * @param {number} bottomLeftRadiusY
 * @param {number} bottomRightRadiusX
 * @param {number} bottomRightRadiusY
 */
org.apache.flex.svg.CompoundGraphic.prototype.drawRoundRectComplex2 = function(x, y, width, height, radiusX, radiusY, topLeftRadiusX, topLeftRadiusY, topRightRadiusX, topRightRadiusY, bottomLeftRadiusX, bottomLeftRadiusY, bottomRightRadiusX, bottomRightRadiusY) {
  var /** @type {org.apache.flex.graphics.PathBuilder} */ builder = new org.apache.flex.graphics.PathBuilder();
  builder.drawRoundRectComplex2(x, y, width, height, radiusX, radiusY, topLeftRadiusX, topLeftRadiusY, topRightRadiusX, topRightRadiusY, bottomLeftRadiusX, bottomLeftRadiusY, bottomRightRadiusX, bottomRightRadiusY);
  
  this.drawStringPath(builder.getPathString());
};


/**
 *  Draw a string of characters.
 *  @asparam value The string to draw.
 *  @asparam x The x location of the center of the circle
 *  @asparam y The y location of the center of the circle.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 *  @flexjsignorecoercion Text
 *  @flexjsignorecoercion Node
 * @export
 * @param {string} value
 * @param {number} x
 * @param {number} y
 * @return {Object}
 */
org.apache.flex.svg.CompoundGraphic.prototype.drawText = function(value, x, y) {
  
  var /** @type {string} */ style = this.getTxtStyleStr();
  var /** @type {Object} */ text = document.createElementNS('http://www.w3.org/2000/svg', 'text');
  text.flexjs_wrapper = this;
  text.style.left = x;
  text.style.top = y;
  text.setAttribute('style', style);
  text.setAttribute('x', x);
  text.setAttribute('y', y + 15);
  var /** @type {org.apache.flex.svg.Text} */ textNode = org.apache.flex.utils.Language.as(document.createTextNode(value), org.apache.flex.svg.Text);
  text.appendChild(textNode);
  this.element.appendChild(text);
  return text;
};


/**
 * @asreturn {string} The style attribute.
 * @export
 * @return {string}
 */
org.apache.flex.svg.CompoundGraphic.prototype.getTxtStyleStr = function() {
  var /** @type {string} */ fillStr;
  if (this.textFill) {
    fillStr = this.textFill.addFillAttrib(this);
  } else {
    fillStr = 'fill:none';
  }
  var /** @type {string} */ strokeStr;
  if (this.textStroke) {
    strokeStr = this.textStroke.addStrokeAttrib(this);
  } else {
    strokeStr = 'stroke:none';
  }
  return fillStr + ';' + strokeStr;
};


Object.defineProperties(org.apache.flex.svg.CompoundGraphic.prototype, /** @lends {org.apache.flex.svg.CompoundGraphic.prototype} */ {
/** @export */
textFill: {
get: /** @this {org.apache.flex.svg.CompoundGraphic} */ function() {
  return this._textFill;
},
set: /** @this {org.apache.flex.svg.CompoundGraphic} */ function(value) {
  this._textFill = value;
}},
/** @export */
textStroke: {
get: /** @this {org.apache.flex.svg.CompoundGraphic} */ function() {
  return this._textStroke;
},
set: /** @this {org.apache.flex.svg.CompoundGraphic} */ function(value) {
  this._textStroke = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.svg.CompoundGraphic.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'CompoundGraphic', qName: 'org.apache.flex.svg.CompoundGraphic'}], interfaces: [org.apache.flex.graphics.ICompoundGraphic] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.svg.CompoundGraphic', org.apache.flex.svg.CompoundGraphic);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.svg.CompoundGraphic.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'textFill': { type: 'IFill', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'textStroke': { type: 'IStroke', declaredBy: 'org.apache.flex.svg.CompoundGraphic'}
      };
    },
    methods: function () {
      return {
        'removeAllElements': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'clear': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'drawRect': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'drawRoundRect': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'drawEllipse': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'drawCircle': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'drawPathCommands': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'drawStringPath': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'drawLine': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'drawPolygon': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'drawRoundRectComplex': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'drawRoundRectComplex2': { type: 'void', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'drawText': { type: 'Object', declaredBy: 'org.apache.flex.svg.CompoundGraphic'},
        'getTxtStyleStr': { type: 'String', declaredBy: 'org.apache.flex.svg.CompoundGraphic'}
      };
    }
  };
};