/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/maps/google/GoogleMap.as
 * org.apache.flex.maps.google.GoogleMap
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.maps.google.GoogleMap');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.maps.google.beads.GoogleMapView');
goog.require('org.apache.flex.maps.google.models.MapModel');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.maps.google.GoogleMap = function() {
  org.apache.flex.maps.google.GoogleMap.base(this, 'constructor');
  this.className = "Map";
  var /** @type {org.apache.flex.core.IBeadModel} */ model = org.apache.flex.utils.Language.as(this.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.IBeadModel);
  if (model == null) {
    model = new org.apache.flex.maps.google.models.MapModel();
    this.addBead(model);
  }
};
goog.inherits(org.apache.flex.maps.google.GoogleMap, org.apache.flex.core.UIBase);


/**
 * @export
 * @param {number} centerLat
 * @param {number} centerLong
 * @param {number} zoom
 */
org.apache.flex.maps.google.GoogleMap.prototype.loadMap = function(centerLat, centerLong, zoom) {
  org.apache.flex.utils.Language.as(this.view, org.apache.flex.maps.google.beads.GoogleMapView, true).mapit(centerLat, centerLong, zoom);
};


/**
 * @export
 * @param {number} zoomLevel
 */
org.apache.flex.maps.google.GoogleMap.prototype.setZoom = function(zoomLevel) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.maps.google.models.MapModel, true).zoom = zoomLevel;
};


/**
 * @export
 * @param {string} address
 */
org.apache.flex.maps.google.GoogleMap.prototype.centerOnAddress = function(address) {
  org.apache.flex.utils.Language.as(this.view, org.apache.flex.maps.google.beads.GoogleMapView, true).centerOnAddress(address);
};


/**
 * @export
 * @param {google.maps.LatLng} location
 */
org.apache.flex.maps.google.GoogleMap.prototype.setCenter = function(location) {
  org.apache.flex.utils.Language.as(this.view, org.apache.flex.maps.google.beads.GoogleMapView, true).setCenter(location);
};


/**
 * @export
 */
org.apache.flex.maps.google.GoogleMap.prototype.markCurrentLocation = function() {
  org.apache.flex.utils.Language.as(this.view, org.apache.flex.maps.google.beads.GoogleMapView, true).markCurrentLocation();
};


/**
 * @export
 * @param {string} address
 */
org.apache.flex.maps.google.GoogleMap.prototype.markAddress = function(address) {
  org.apache.flex.utils.Language.as(this.view, org.apache.flex.maps.google.beads.GoogleMapView, true).markAddress(address);
};


/**
 * @export
 * @param {google.maps.LatLng} location
 * @return {google.maps.Marker}
 */
org.apache.flex.maps.google.GoogleMap.prototype.createMarker = function(location) {
  return org.apache.flex.utils.Language.as(this.view, org.apache.flex.maps.google.beads.GoogleMapView, true).createMarker(location);
};


/**
 * @export
 * @param {string} placeName
 */
org.apache.flex.maps.google.GoogleMap.prototype.nearbySearch = function(placeName) {
  org.apache.flex.utils.Language.as(this.view, org.apache.flex.maps.google.beads.GoogleMapView, true).nearbySearch(placeName);
};


/**
 * @export
 */
org.apache.flex.maps.google.GoogleMap.prototype.clearSearchResults = function() {
  org.apache.flex.utils.Language.as(this.view, org.apache.flex.maps.google.beads.GoogleMapView, true).clearSearchResults();
};


Object.defineProperties(org.apache.flex.maps.google.GoogleMap.prototype, /** @lends {org.apache.flex.maps.google.GoogleMap.prototype} */ {
/** @export */
token: {
get: /** @this {org.apache.flex.maps.google.GoogleMap} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.maps.google.models.MapModel, true).token;
},
set: /** @this {org.apache.flex.maps.google.GoogleMap} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.maps.google.models.MapModel, true).token = value;
}},
/** @export */
selectedMarker: {
get: /** @this {org.apache.flex.maps.google.GoogleMap} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.maps.google.models.MapModel, true).selectedMarker;
}},
/** @export */
searchResults: {
get: /** @this {org.apache.flex.maps.google.GoogleMap} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.maps.google.models.MapModel, true).searchResults;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.maps.google.GoogleMap.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'GoogleMap', qName: 'org.apache.flex.maps.google.GoogleMap'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.maps.google.GoogleMap', org.apache.flex.maps.google.GoogleMap);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.maps.google.GoogleMap.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'token': { type: 'String', declaredBy: 'org.apache.flex.maps.google.GoogleMap'},
        'selectedMarker': { type: 'Marker', declaredBy: 'org.apache.flex.maps.google.GoogleMap'},
        'searchResults': { type: 'Array', declaredBy: 'org.apache.flex.maps.google.GoogleMap'}
      };
    },
    methods: function () {
      return {
        'GoogleMap': { type: '', declaredBy: 'org.apache.flex.maps.google.GoogleMap'},
        'loadMap': { type: 'void', declaredBy: 'org.apache.flex.maps.google.GoogleMap'},
        'setZoom': { type: 'void', declaredBy: 'org.apache.flex.maps.google.GoogleMap'},
        'centerOnAddress': { type: 'void', declaredBy: 'org.apache.flex.maps.google.GoogleMap'},
        'setCenter': { type: 'void', declaredBy: 'org.apache.flex.maps.google.GoogleMap'},
        'markCurrentLocation': { type: 'void', declaredBy: 'org.apache.flex.maps.google.GoogleMap'},
        'markAddress': { type: 'void', declaredBy: 'org.apache.flex.maps.google.GoogleMap'},
        'createMarker': { type: 'Marker', declaredBy: 'org.apache.flex.maps.google.GoogleMap'},
        'nearbySearch': { type: 'void', declaredBy: 'org.apache.flex.maps.google.GoogleMap'},
        'clearSearchResults': { type: 'void', declaredBy: 'org.apache.flex.maps.google.GoogleMap'}
      };
    },
    metadata: function () { return [ ]; }
  };
};