/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from google/maps/Marker.as
 * google.maps.Marker
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('google.maps.Marker');



/**
 * @asparam opt_opts [(Object|google.maps.MarkerOptions|null|undefined)] 
 * @see [google_maps_api_v3_11]
 * @constructor
 * @extends {google.maps.MVCObject}
 * @param {Object=} opt_opts
 */
google.maps.Marker = function(opt_opts) {
  opt_opts = typeof opt_opts !== 'undefined' ? opt_opts : null;
  google.maps.Marker.base(this, 'constructor');
  this._options = opt_opts;
};
goog.inherits(google.maps.Marker, google.maps.MVCObject);


/**
 * @private
 * @type {Object}
 */
google.maps.Marker.prototype._options;


/**
 * @private
 * @type {google.maps.Animation}
 */
google.maps.Marker.prototype._animation;


/**
 * @private
 * @type {google.maps.LatLng}
 */
google.maps.Marker.prototype._position;


/**
 * @private
 * @type {Object}
 */
google.maps.Marker.prototype._icon;


/**
 * @private
 * @type {Object}
 */
google.maps.Marker.prototype._shape;


/**
 * @private
 * @type {Object}
 */
google.maps.Marker.prototype._shadow;


/**
 * @private
 * @type {string}
 */
google.maps.Marker.prototype._title;


/**
 * @private
 * @type {boolean}
 */
google.maps.Marker.prototype._draggable;


/**
 * @private
 * @type {number}
 */
google.maps.Marker.prototype._zIndex;


/**
 * @private
 * @type {boolean}
 */
google.maps.Marker.prototype._visible;


/**
 * @private
 * @type {string}
 */
google.maps.Marker.prototype._cursor;


/**
 * @private
 * @type {boolean}
 */
google.maps.Marker.prototype._flat;


/**
 * @private
 * @type {Object}
 */
google.maps.Marker.prototype._map;


/**
 * @private
 * @type {boolean}
 */
google.maps.Marker.prototype._clickable;


/**
 * @export
 * @type {Object}
 */
google.maps.Marker.MAX_ZINDEX;


/**
 * @asparam animation [(google.maps.Animation|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {google.maps.Animation} animation
 * @return {Object}
 */
google.maps.Marker.prototype.setAnimation = function(animation) {
  _animation : animation;;
return undefined;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLng|null)} 
 * @export
 * @return {google.maps.LatLng}
 */
google.maps.Marker.prototype.getPosition = function() {
return this._position;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.Icon|google.maps.Symbol|null|string)} 
 * @export
 * @return {Object}
 */
google.maps.Marker.prototype.getIcon = function() {
return this._icon;
};


/**
 * @asparam shape [(google.maps.MarkerShape|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} shape
 * @return {Object}
 */
google.maps.Marker.prototype.setShape = function(shape) {
this._shape = shape;
return undefined;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.Icon|google.maps.Symbol|null|string)} 
 * @export
 * @return {Object}
 */
google.maps.Marker.prototype.getShadow = function() {
return this._shadow;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {string} 
 * @export
 * @return {string}
 */
google.maps.Marker.prototype.getTitle = function() {
return this._title;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @return {boolean}
 */
google.maps.Marker.prototype.getDraggable = function() {
return this._draggable;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.MarkerShape|null)} 
 * @export
 * @return {Object}
 */
google.maps.Marker.prototype.getShape = function() {
return this._shape;
};


/**
 * @asparam zIndex [number] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {number} zIndex
 * @return {Object}
 */
google.maps.Marker.prototype.setZIndex = function(zIndex) {
this._zIndex = zIndex;
return undefined;
};


/**
 * @asparam flag [(boolean|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {boolean} flag
 * @return {Object}
 */
google.maps.Marker.prototype.setDraggable = function(flag) {
this._draggable = flag;
return undefined;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.Animation|null)} 
 * @export
 * @return {google.maps.Animation}
 */
google.maps.Marker.prototype.getAnimation = function() {
return this._animation;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @return {number}
 */
google.maps.Marker.prototype.getZIndex = function() {
return this._zIndex;
};


/**
 * @asparam visible [boolean] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {boolean} visible
 * @return {Object}
 */
google.maps.Marker.prototype.setVisible = function(visible) {
this._visible = visible;
return undefined;
};


/**
 * @asparam cursor [string] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {string} cursor
 * @return {Object}
 */
google.maps.Marker.prototype.setCursor = function(cursor) {
this._cursor = cursor;
return undefined;
};


/**
 * @asparam latlng [(google.maps.LatLng|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {google.maps.LatLng} latlng
 * @return {Object}
 */
google.maps.Marker.prototype.setPosition = function(latlng) {
this._position = latlng;
return undefined;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @return {boolean}
 */
google.maps.Marker.prototype.getFlat = function() {
return this._flat;
};


/**
 * @asparam map [(google.maps.Map|google.maps.StreetViewPanorama|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} map
 * @return {Object}
 */
google.maps.Marker.prototype.setMap = function(map) {
this._map = map;
return undefined;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.Map|google.maps.StreetViewPanorama|null)} 
 * @export
 * @return {Object}
 */
google.maps.Marker.prototype.getMap = function() {
return this._map;
};


/**
 * @asparam flag [boolean] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {boolean} flag
 * @return {Object}
 */
google.maps.Marker.prototype.setClickable = function(flag) {
return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @return {boolean}
 */
google.maps.Marker.prototype.getVisible = function() {
return this._visible;
};


/**
 * @asparam shadow [(google.maps.Icon|google.maps.Symbol|null|string)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} shadow
 * @return {Object}
 */
google.maps.Marker.prototype.setShadow = function(shadow) {
this._shadow = shadow;
return undefined;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {string} 
 * @export
 * @return {string}
 */
google.maps.Marker.prototype.getCursor = function() {
return this._cursor;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @return {boolean}
 */
google.maps.Marker.prototype.getClickable = function() {
return this._clickable;
};


/**
 * @asparam flag [boolean] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {boolean} flag
 * @return {Object}
 */
google.maps.Marker.prototype.setFlat = function(flag) {
this._flat = flag;
return undefined;
};


/**
 * @asparam title [string] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {string} title
 * @return {Object}
 */
google.maps.Marker.prototype.setTitle = function(title) {
this._title = title;
return undefined;
};


/**
 * @asparam options [(Object|google.maps.MarkerOptions|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} options
 * @return {Object}
 */
google.maps.Marker.prototype.setOptions = function(options) {
this._options = options;
return undefined;
};


/**
 * @asparam icon [(google.maps.Icon|google.maps.Symbol|null|string)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} icon
 * @return {Object}
 */
google.maps.Marker.prototype.setIcon = function(icon) {
this._icon = icon;
return undefined;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
google.maps.Marker.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Marker', qName: 'google.maps.Marker'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('google.maps.Marker', google.maps.Marker);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
google.maps.Marker.prototype.FLEXJS_REFLECTION_INFO = function () {
return {
  variables: function () {
    return {
    };
  },
  accessors: function () {
    return {
    };
  },
  methods: function () {
    return {
      'Marker': { type: '', declaredBy: 'google.maps.Marker'},
      'setAnimation': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'getPosition': { type: 'google.maps.LatLng', declaredBy: 'google.maps.Marker'},
      'getIcon': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'setShape': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'getShadow': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'getTitle': { type: 'String', declaredBy: 'google.maps.Marker'},
      'getDraggable': { type: 'Boolean', declaredBy: 'google.maps.Marker'},
      'getShape': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'setZIndex': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'setDraggable': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'getAnimation': { type: 'google.maps.Animation', declaredBy: 'google.maps.Marker'},
      'getZIndex': { type: 'Number', declaredBy: 'google.maps.Marker'},
      'setVisible': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'setCursor': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'setPosition': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'getFlat': { type: 'Boolean', declaredBy: 'google.maps.Marker'},
      'setMap': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'getMap': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'setClickable': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'getVisible': { type: 'Boolean', declaredBy: 'google.maps.Marker'},
      'setShadow': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'getCursor': { type: 'String', declaredBy: 'google.maps.Marker'},
      'getClickable': { type: 'Boolean', declaredBy: 'google.maps.Marker'},
      'setFlat': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'setTitle': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'setOptions': { type: 'Object', declaredBy: 'google.maps.Marker'},
      'setIcon': { type: 'Object', declaredBy: 'google.maps.Marker'}
    };
  }
};
};