/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/graphics/Rect.as
 * org.apache.flex.createjs.graphics.Rect
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.graphics.Rect');

goog.require('org.apache.flex.createjs.graphics.GraphicShape');
goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.graphics.SolidColorStroke');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.createjs.graphics.GraphicShape}
 */
org.apache.flex.createjs.graphics.Rect = function() {
  org.apache.flex.createjs.graphics.Rect.base(this, 'constructor');
};
goog.inherits(org.apache.flex.createjs.graphics.Rect, org.apache.flex.createjs.graphics.GraphicShape);


/**
 * @asprivate
 * @flexjsignorecoercion createjs.Shape
 * @protected
 * @override
 */
org.apache.flex.createjs.graphics.Rect.prototype.redrawShape = function() {
  if (isNaN(this.width) || isNaN(this.height))
    return;
  var /** @type {string} */ fillColor = null;
  var /** @type {number} */ fillAlpha = 1.0;
  if (this.fill != null) {
    fillAlpha = org.apache.flex.utils.Language.as(this.fill, org.apache.flex.graphics.SolidColor).alpha;
    fillColor = this.convertColorToString(org.apache.flex.utils.Language.as(this.fill, org.apache.flex.graphics.SolidColor).color, fillAlpha);
  }
  var /** @type {string} */ strokeColor = null;
  var /** @type {number} */ strokeWeight = 0;
  var /** @type {number} */ strokeAlpha = 1.0;
  if (this.stroke != null) {
    strokeWeight = org.apache.flex.utils.Language.as(this.stroke, org.apache.flex.graphics.SolidColorStroke).weight;
    strokeAlpha = org.apache.flex.utils.Language.as(this.stroke, org.apache.flex.graphics.SolidColorStroke).alpha;
    strokeColor = this.convertColorToString(org.apache.flex.utils.Language.as(this.stroke, org.apache.flex.graphics.SolidColorStroke).color, strokeAlpha);
  }
  var /** @type {createjs.Shape} */ rect = this.element;
  rect.graphics.setStrokeStyle(strokeWeight);
  rect.graphics.beginStroke(strokeColor);
  rect.graphics.beginFill(fillColor);
  rect.graphics.rect(0, 0, this.width, this.height);
  var /** @type {createjs.Stage} */ stage = rect.getStage();
  if (stage)
    stage.update();
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.graphics.Rect.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Rect', qName: 'org.apache.flex.createjs.graphics.Rect'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.graphics.Rect', org.apache.flex.createjs.graphics.Rect);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.graphics.Rect.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
      };
    }
  };
};