/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/utils/UIDUtil.as
 * org.apache.flex.utils.UIDUtil
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.utils.UIDUtil');

goog.require('org.apache.flex.utils.BinaryData');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 */
org.apache.flex.utils.UIDUtil = function() {
};


/**
 * @private
 * @const
 * @type {Array}
 */
org.apache.flex.utils.UIDUtil.ALPHA_CHAR_CODES = [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70];


/**
 * @private
 * @const
 * @type {number}
 */
org.apache.flex.utils.UIDUtil.DASH = 45;


/**
 * @private
 * @const
 * @type {org.apache.flex.utils.BinaryData}
 */
org.apache.flex.utils.UIDUtil.UIDBuffer = new org.apache.flex.utils.BinaryData();


/**
 *  Generates a UID (unique identifier) based on ActionScript's
 *  pseudo-random number generator and the current time.
 *
 *  <p>The UID has the form
 *  <code>"XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX"</code>
 *  where X is a hexadecimal digit (0-9, A-F).</p>
 *
 *  <p>This UID will not be truly globally unique; but it is the best
 *  we can do without player support for UID generation.</p>
 *
 *  @asreturn The newly-generated UID.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 *  @productversion FlexJS 0.0
 * @export
 * @return {string}
 */
org.apache.flex.utils.UIDUtil.createUID = function() {
  var /** @type {number} */ i;
  var /** @type {number} */ j;
  org.apache.flex.utils.UIDUtil.UIDBuffer.position = 0;
  for (i = 0; i < 8; i++) {
    org.apache.flex.utils.UIDUtil.UIDBuffer.writeByte(org.apache.flex.utils.UIDUtil.ALPHA_CHAR_CODES[org.apache.flex.utils.Language._int(Math.random() * 16)]);
  }
  for (i = 0; i < 3; i++) {
    org.apache.flex.utils.UIDUtil.UIDBuffer.writeByte(org.apache.flex.utils.UIDUtil.DASH);
    for (j = 0; j < 4; j++) {
      org.apache.flex.utils.UIDUtil.UIDBuffer.writeByte(org.apache.flex.utils.UIDUtil.ALPHA_CHAR_CODES[org.apache.flex.utils.Language._int(Math.random() * 16)]);
    }
  }
  org.apache.flex.utils.UIDUtil.UIDBuffer.writeByte(org.apache.flex.utils.UIDUtil.DASH);
  var /** @type {number} */ time = new Date().getTime();
  var /** @type {string} */ timeString = time.toString(16).toUpperCase();
  for (i = 8; i > timeString.length; i--)
    org.apache.flex.utils.UIDUtil.UIDBuffer.writeByte(48);
  org.apache.flex.utils.UIDUtil.UIDBuffer.writeUTFBytes(timeString);
  for (i = 0; i < 4; i++) {
    org.apache.flex.utils.UIDUtil.UIDBuffer.writeByte(org.apache.flex.utils.UIDUtil.ALPHA_CHAR_CODES[org.apache.flex.utils.Language._int(Math.random() * 16)]);
  }
  org.apache.flex.utils.UIDUtil.UIDBuffer.position = 0;
  return org.apache.flex.utils.UIDUtil.UIDBuffer.readUTFBytes(org.apache.flex.utils.UIDUtil.UIDBuffer.length);
};


/**
 * Converts a 128-bit UID encoded as a ByteArray to a String representation.
 * The format matches that generated by createUID. If a suitable ByteArray
 * is not provided, null is returned.
 * 
 * @asparam ba ByteArray 16 bytes in length representing a 128-bit UID.
 * 
 * @asreturn String representation of the UID, or null if an invalid
 * ByteArray is provided.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.utils.BinaryData} ba
 * @return {string}
 */
org.apache.flex.utils.UIDUtil.fromBinary = function(ba) {
  if (ba != null && ba.length >= 16 && ba.bytesAvailable >= 16) {
    org.apache.flex.utils.UIDUtil.UIDBuffer.position = 0;
    var /** @type {number} */ index = 0;
    for (var /** @type {number} */ i = 0; i < 16; i++) {
      if (i == 4 || i == 6 || i == 8 || i == 10)
        org.apache.flex.utils.UIDUtil.UIDBuffer.writeByte(org.apache.flex.utils.UIDUtil.DASH);
      var /** @type {number} */ b = ba.readByte();
      org.apache.flex.utils.UIDUtil.UIDBuffer.writeByte(org.apache.flex.utils.UIDUtil.ALPHA_CHAR_CODES[(b & 0xF0) >>> 4]);
      org.apache.flex.utils.UIDUtil.UIDBuffer.writeByte(org.apache.flex.utils.UIDUtil.ALPHA_CHAR_CODES[(b & 0x0F)]);
    }
    return org.apache.flex.utils.UIDUtil.UIDBuffer.readUTFBytes(org.apache.flex.utils.UIDUtil.UIDBuffer.length);
  }
  return null;
};


/**
 * A utility method to check whether a String value represents a 
 * correctly formatted UID value. UID values are expected to be 
 * in the format generated by createUID(), implying that only
 * capitalized A-F characters in addition to 0-9 digits are
 * supported.
 * 
 * @asparam uid The value to test whether it is formatted as a UID.
 * 
 * @asreturn Returns true if the value is formatted as a UID.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} uid
 * @return {boolean}
 */
org.apache.flex.utils.UIDUtil.isUID = function(uid) {
  if (uid != null && uid.length == 36) {
    for (var /** @type {number} */ i = 0; i < 36; i++) {
      var /** @type {number} */ c = uid.charCodeAt(i);
      if (i == 8 || i == 13 || i == 18 || i == 23) {
        if (c != org.apache.flex.utils.UIDUtil.DASH) {
          return false;
        }
      } else if (c < 48 || c > 70 || (c > 57 && c < 65)) {
        return false;
      }
    }
    return true;
  }
  return false;
};


/**
 * Converts a UID formatted String to a BinaryData. The UID must be in the
 * format generated by createUID, otherwise null is returned.
 * 
 * @asparam String representing a 128-bit UID
 * 
 * @asreturn ByteArray 16 bytes in length representing the 128-bits of the
 * UID or null if the uid could not be converted.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} uid
 * @return {org.apache.flex.utils.BinaryData}
 */
org.apache.flex.utils.UIDUtil.toBinary = function(uid) {
  if (org.apache.flex.utils.UIDUtil.isUID(uid)) {
    var /** @type {org.apache.flex.utils.BinaryData} */ result = new org.apache.flex.utils.BinaryData();
    for (var /** @type {number} */ i = 0; i < uid.length; i++) {
      var /** @type {string} */ c = uid.charAt(i);
      if (c == "-")
        continue;
      var /** @type {number} */ h1 = org.apache.flex.utils.UIDUtil.getDigit(c);
      i++;
      var /** @type {number} */ h2 = org.apache.flex.utils.UIDUtil.getDigit(uid.charAt(i));
      result.writeByte(((h1 << 4) | h2) & 0xFF);
    }
    result.position = 0;
    return result;
  }
  return null;
};


/**
 * Returns the decimal representation of a hex digit.
 * @asprivate
 * @private
 * @param {string} hex
 * @return {number}
 */
org.apache.flex.utils.UIDUtil.getDigit = function(hex) {
  return parseInt(hex, 16);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.utils.UIDUtil.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'UIDUtil', qName: 'org.apache.flex.utils.UIDUtil'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.utils.UIDUtil', org.apache.flex.utils.UIDUtil);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.utils.UIDUtil.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
      };
    }
  };
};