/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/events/ValueChangeEvent.as
 * org.apache.flex.events.ValueChangeEvent
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.events.ValueChangeEvent');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.Event}
 * @param {string} type
 * @param {boolean=} bubbles
 * @param {boolean=} cancelable
 * @param {Object=} oldValue
 * @param {Object=} newValue
 */
org.apache.flex.events.ValueChangeEvent = function(type, bubbles, cancelable, oldValue, newValue) {
  bubbles = typeof bubbles !== 'undefined' ? bubbles : false;
  cancelable = typeof cancelable !== 'undefined' ? cancelable : false;
  oldValue = typeof oldValue !== 'undefined' ? oldValue : null;
  newValue = typeof newValue !== 'undefined' ? newValue : null;
  org.apache.flex.events.ValueChangeEvent.base(this, 'constructor', type, bubbles, cancelable);
  this.oldValue = oldValue;
  this.newValue = newValue;
};
goog.inherits(org.apache.flex.events.ValueChangeEvent, org.apache.flex.events.Event);


/**
 * @export
 * @type {Object}
 */
org.apache.flex.events.ValueChangeEvent.prototype.oldValue;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.events.ValueChangeEvent.prototype.newValue;


/**
 * @export
 * @type {string}
 */
org.apache.flex.events.ValueChangeEvent.prototype.propertyName;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.events.ValueChangeEvent.prototype.source;


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.ValueChangeEvent.VALUE_CHANGE = "valueChange";


/**
 *  A convenience method to create an instance of the ValueChangeEvent.
 * 
 *  @asparam source The source of the object.
 *  @asparam name The name of the event.
 *  @asparam oldValue The value before it was changed.
 *  @asparam newValue The value after it was changed.
 *  @asreturn An instance of the ValueChangeEvent.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} source
 * @param {string} name
 * @param {Object} oldValue
 * @param {Object} newValue
 * @return {org.apache.flex.events.ValueChangeEvent}
 */
org.apache.flex.events.ValueChangeEvent.createUpdateEvent = function(source, name, oldValue, newValue) {
  var /** @type {org.apache.flex.events.ValueChangeEvent} */ event = new org.apache.flex.events.ValueChangeEvent(org.apache.flex.events.ValueChangeEvent.VALUE_CHANGE, false, false, oldValue, newValue);
  event.propertyName = name;
  event.source = source;
  return event;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.events.ValueChangeEvent.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ValueChangeEvent', qName: 'org.apache.flex.events.ValueChangeEvent'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.events.ValueChangeEvent', org.apache.flex.events.ValueChangeEvent);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.events.ValueChangeEvent.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'oldValue': { type: 'Object'},
        'newValue': { type: 'Object'},
        'propertyName': { type: 'String'},
        'source': { type: 'Object'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'ValueChangeEvent': { type: '', declaredBy: 'org.apache.flex.events.ValueChangeEvent'}
      };
    }
  };
};