/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/events/Event.as
 * org.apache.flex.events.Event
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.events.Event');

goog.require('goog.events.Event');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {goog.events.Event}
 * @param {string} type
 * @param {boolean=} bubbles
 * @param {boolean=} cancelable
 */
org.apache.flex.events.Event = function(type, bubbles, cancelable) {
  bubbles = typeof bubbles !== 'undefined' ? bubbles : false;
  cancelable = typeof cancelable !== 'undefined' ? cancelable : false;
  org.apache.flex.events.Event.base(this, 'constructor', type);
  this.bubbles = true;
  this.cancelable = true;
};
goog.inherits(org.apache.flex.events.Event, goog.events.Event);


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.Event.CHANGE = "change";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.Event.COMPLETE = "complete";


/**
 * @export
 * @type {boolean}
 */
org.apache.flex.events.Event.prototype.bubbles;


/**
 * @export
 * @type {boolean}
 */
org.apache.flex.events.Event.prototype.cancelable;


/**
 * Google Closure doesn't seem to support stopImmediatePropagation, but
 * actually the HTMLElementWrapper fireListener override sends a
 * BrowserEvent in most/all cases where folks need stopImmediatePropagation
 * so we put this in here for compile time since it will exist in
 * the BrowserEvent that does get sent around.
 * @export
 */
org.apache.flex.events.Event.prototype.stopImmediatePropagation = function() {
  throw new Error("stopImmediatePropagation");
};


/**
 * @export
 * @return {org.apache.flex.events.Event}
 */
org.apache.flex.events.Event.prototype.cloneEvent = function() {
  return new org.apache.flex.events.Event(this.type, this.bubbles, this.cancelable);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.events.Event.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Event', qName: 'org.apache.flex.events.Event'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.events.Event', org.apache.flex.events.Event);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.events.Event.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'bubbles': { type: 'Boolean'},
        'cancelable': { type: 'Boolean'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Event': { type: '', declaredBy: 'org.apache.flex.events.Event'},
        'stopImmediatePropagation': { type: 'void', declaredBy: 'org.apache.flex.events.Event'},
        'cloneEvent': { type: 'org.apache.flex.events.Event', declaredBy: 'org.apache.flex.events.Event'}
      };
    }
  };
};