/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/ItemRendererClassFactory.as
 * org.apache.flex.core.ItemRendererClassFactory
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.ItemRendererClassFactory');

goog.require('org.apache.flex.core.ClassFactory');
goog.require('org.apache.flex.core.Strand');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.utils.MXMLDataInterpreter');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.core.IItemRendererClassFactory');
goog.require('org.apache.flex.core.IItemRendererProvider');
goog.require('org.apache.flex.core.IParent');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.Strand}
 * @implements {org.apache.flex.core.IItemRendererClassFactory}
 * @implements {org.apache.flex.core.IDocument}
 * @implements {org.apache.flex.core.IBead}
 */
org.apache.flex.core.ItemRendererClassFactory = function() {
  
  this.createFunction = org.apache.flex.utils.Language.closure(this.createFromMXMLContent, this, 'createFromMXMLContent');
  org.apache.flex.core.ItemRendererClassFactory.base(this, 'constructor');
};
goog.inherits(org.apache.flex.core.ItemRendererClassFactory, org.apache.flex.core.Strand);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.core.ItemRendererClassFactory.prototype._strand;


/**
 * @export
 * @type {Array}
 */
org.apache.flex.core.ItemRendererClassFactory.prototype.mxmlContent;


/**
 *  @copy org.apache.flex.core.IItemRendererClassFactory#createItemRenderer()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.core.IItemRendererParent} parent
 * @return {org.apache.flex.core.IItemRenderer}
 */
org.apache.flex.core.ItemRendererClassFactory.prototype.createItemRenderer = function(parent) {
  return this.createFunction(parent);
};


/**
 * @export
 * @type {Function}
 */
org.apache.flex.core.ItemRendererClassFactory.prototype.createFunction;


/**
 *  Creates an instance of an item renderer from child MXML tags.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @param {org.apache.flex.core.IItemRendererParent} parent
 * @return {org.apache.flex.core.IItemRenderer}
 */
org.apache.flex.core.ItemRendererClassFactory.prototype.createFromMXMLContent = function(parent) {
  return org.apache.flex.utils.MXMLDataInterpreter.generateMXMLArray(this.document, org.apache.flex.utils.Language.as(parent, org.apache.flex.core.IParent), this.MXMLDescriptor)[0];
};


/**
 * @export
 * @type {org.apache.flex.core.IFactory}
 */
org.apache.flex.core.ItemRendererClassFactory.prototype.itemRendererFactory;


/**
 *  Creates an instance of an item renderer from itemRendererFactory.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.core.IItemRendererParent} parent
 * @return {org.apache.flex.core.IItemRenderer}
 */
org.apache.flex.core.ItemRendererClassFactory.prototype.createFromClass = function(parent) {
  var /** @type {org.apache.flex.core.IItemRenderer} */ renderer = this.itemRendererFactory.newInstance();
  renderer.itemRendererParent = parent;
  return renderer;
};


/**
 * @private
 * @type {Object}
 */
org.apache.flex.core.ItemRendererClassFactory.prototype.document;


/**
 *  @copy org.apache.flex.core.IDocument#setDocument()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.core.ItemRendererClassFactory.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


Object.defineProperties(org.apache.flex.core.ItemRendererClassFactory.prototype, /** @lends {org.apache.flex.core.ItemRendererClassFactory.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.core.ItemRendererClassFactory} */ function(value) {
  this._strand = value;
  if (org.apache.flex.utils.Language.is(this._strand, org.apache.flex.core.IItemRendererProvider) && org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IItemRendererProvider).hasItemRenderer) {
    this.itemRendererFactory = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IItemRendererProvider).itemRenderer;
    this.createFunction = org.apache.flex.utils.Language.closure(this.createFromClass, this, 'createFromClass');
  } else {
    var /** @type {Object} */ itemRendererClass = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this._strand, "iItemRenderer");
    if (itemRendererClass) {
      this.itemRendererFactory = new org.apache.flex.core.ClassFactory(itemRendererClass);
      this.createFunction = org.apache.flex.utils.Language.closure(this.createFromClass, this, 'createFromClass');
    }
  }
}},
/** @export */
MXMLDescriptor: {
get: /** @this {org.apache.flex.core.ItemRendererClassFactory} */ function() {
  return null;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.ItemRendererClassFactory.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ItemRendererClassFactory', qName: 'org.apache.flex.core.ItemRendererClassFactory'}], interfaces: [org.apache.flex.core.IItemRendererClassFactory, org.apache.flex.core.IDocument, org.apache.flex.core.IBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.ItemRendererClassFactory', org.apache.flex.core.ItemRendererClassFactory);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.ItemRendererClassFactory.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'mxmlContent': { type: 'Array'},
        'createFunction': { type: 'Function'},
        'itemRendererFactory': { type: 'IFactory'}
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.core.ItemRendererClassFactory'},
        'MXMLDescriptor': { type: 'Array', declaredBy: 'org.apache.flex.core.ItemRendererClassFactory'}
      };
    },
    methods: function () {
      return {
        'ItemRendererClassFactory': { type: '', declaredBy: 'org.apache.flex.core.ItemRendererClassFactory'},
        'createItemRenderer': { type: 'IItemRenderer', declaredBy: 'org.apache.flex.core.ItemRendererClassFactory'},
        'createFromClass': { type: 'IItemRenderer', declaredBy: 'org.apache.flex.core.ItemRendererClassFactory'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.core.ItemRendererClassFactory'}
      };
    },
    metadata: function () { return [ ]; }
  };
};