/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/ClassFactory.as
 * org.apache.flex.core.ClassFactory
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.ClassFactory');

goog.require('org.apache.flex.core.IFactory');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 * @implements {org.apache.flex.core.IFactory}
 * @param {Object=} generator
 */
org.apache.flex.core.ClassFactory = function(generator) {
  generator = typeof generator !== 'undefined' ? generator : null;
  this.generator = generator;
};


/**
 * @export
 * @type {Object}
 */
org.apache.flex.core.ClassFactory.prototype.generator;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.core.ClassFactory.prototype.properties;


/**
 *  @copy score.IFactory#newInstance()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {*}
 */
org.apache.flex.core.ClassFactory.prototype.newInstance = function() {
  var /** @type {*} */ obj = new this.generator();
  if (this.properties) {
    for (var /** @type {string} */ prop in this.properties) {
      obj[prop] = this.properties[prop];
    }
  }
  return obj;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.ClassFactory.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ClassFactory', qName: 'org.apache.flex.core.ClassFactory'}], interfaces: [org.apache.flex.core.IFactory] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.ClassFactory', org.apache.flex.core.ClassFactory);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.ClassFactory.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'generator': { type: 'Class'},
        'properties': { type: 'Object'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'ClassFactory': { type: '', declaredBy: 'org.apache.flex.core.ClassFactory'},
        'newInstance': { type: '*', declaredBy: 'org.apache.flex.core.ClassFactory'}
      };
    }
  };
};