/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/collections/ArrayList.as
 * org.apache.flex.collections.ArrayList
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.collections.ArrayList');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.collections.IArrayList');
goog.require('org.apache.flex.collections.ICollection');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.collections.ICollection}
 * @implements {org.apache.flex.collections.IArrayList}
 * @param {Array=} initialSource
 */
org.apache.flex.collections.ArrayList = function(initialSource) {
  initialSource = typeof initialSource !== 'undefined' ? initialSource : null;
  org.apache.flex.collections.ArrayList.base(this, 'constructor');
  if (initialSource)
    this._source = initialSource;
  else
    this._source = [];
};
goog.inherits(org.apache.flex.collections.ArrayList, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {string}
 */
org.apache.flex.collections.ArrayList.prototype._id;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.collections.ArrayList.prototype._strand;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.collections.ArrayList.prototype._source;


/**
 * Returns a copy of the source array.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @return {Array}
 */
org.apache.flex.collections.ArrayList.prototype.toArray = function() {
  return this._source.concat();
};


/**
 *  Fetches an item from the collection
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.flex.collections.ArrayList.prototype.getItemAt = function(index) {
  return this._source[index];
};


/**
 *  Fetches an item from the collection given an index.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} item
 * @return {number}
 */
org.apache.flex.collections.ArrayList.prototype.getItemIndex = function(item) {
  for (var /** @type {number} */ index = 0; index < this._source.length; index++) {
    if (item == this._source[index]) {
      return index;
    }
  }
  return -1;
};


/**
 *  Adds an item to the end of the array.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} item
 */
org.apache.flex.collections.ArrayList.prototype.addItem = function(item) {
  this.addItemAt(item, this.length);
};


/**
 *  Inserts an item to a specific location within the array.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} item
 * @param {number} index
 */
org.apache.flex.collections.ArrayList.prototype.addItemAt = function(item, index) {
  
/**
 * @const
 * @type {number}
 */
var spliceUpperBound = this.length;
  if (index < spliceUpperBound && index > 0) {
    this.source.splice(index, 0, item);
  } else if (index == spliceUpperBound) {
    this.source.push(item);
  } else if (index == 0) {
    this.source.unshift(item);
  } else {
    return;
  }
  this.dispatchEvent(new org.apache.flex.events.Event("itemAdded"));
};


/**
 *  Replaces the item at the given index with a new item and
 *  returns the old item.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} item
 * @param {number} index
 * @return {Object}
 */
org.apache.flex.collections.ArrayList.prototype.setItemAt = function(item, index) {
  
/**
 * @const
 * @type {number}
 */
var spliceUpperBound = this.length;
  var /** @type {Object} */ oldItem;
  if (index >= 0 && index < spliceUpperBound) {
    oldItem = this.source[index];
    this.source[index] = item;
    this.dispatchEvent(new org.apache.flex.events.Event("itemUpdated"));
  } else {
  }
  return oldItem;
};


/**
 *  Removed an item from the array and returns it.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} item
 * @return {boolean}
 */
org.apache.flex.collections.ArrayList.prototype.removeItem = function(item) {
  var /** @type {number} */ index = this.getItemIndex(item);
  var /** @type {boolean} */ result = index >= 0;
  if (result) {
    this.removeItemAt(index);
  }
  return result;
};


/**
 *  Removes an item from a specific location within the array and
 *  returns it.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.flex.collections.ArrayList.prototype.removeItemAt = function(index) {
  
/**
 * @const
 * @type {number}
 */
var spliceUpperBound = this.length - 1;
  var /** @type {Object} */ removed;
  if (index > 0 && index < spliceUpperBound) {
    removed = this.source.splice(index, 1)[0];
  } else if (index == spliceUpperBound) {
    removed = this.source.pop();
  } else if (index == 0) {
    removed = this.source.shift();
  } else {
    return null;
  }
  this.dispatchEvent(new org.apache.flex.events.Event("itemRemoved"));
  return removed;
};


/**
 *  Removes all of the items from the array.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.collections.ArrayList.prototype.removeAll = function() {
  if (this.length > 0) {
    this.source.splice(0, this.length);
    this.dispatchEvent(new org.apache.flex.events.Event("itemRemoved"));
  }
};


/**
 *  Signals that an item in the array has been updated.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} item
 */
org.apache.flex.collections.ArrayList.prototype.itemUpdated = function(item) {
  var /** @type {number} */ index = this.getItemIndex(item);
  if (index >= 0) {
    this.dispatchEvent(new org.apache.flex.events.Event("itemUpdated"));
  }
};


/**
 *  Signals that an item in the array has been updated.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} index
 */
org.apache.flex.collections.ArrayList.prototype.itemUpdatedAt = function(index) {
  this.dispatchEvent(new org.apache.flex.events.Event("itemUpdated"));
};


Object.defineProperties(org.apache.flex.collections.ArrayList.prototype, /** @lends {org.apache.flex.collections.ArrayList.prototype} */ {
/** @export */
id: {
get: /** @this {org.apache.flex.collections.ArrayList} */ function() {
  return this._id;
},
set: /** @this {org.apache.flex.collections.ArrayList} */ function(value) {
  if (this._id != value) {
    this._id = value;
    this.dispatchEvent(new org.apache.flex.events.Event("idChanged"));
  }
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.collections.ArrayList} */ function(value) {
  this._strand = value;
  this._source = new Array();
}},
/** @export */
source: {
get: /** @this {org.apache.flex.collections.ArrayList} */ function() {
  return this._source;
},
set: /** @this {org.apache.flex.collections.ArrayList} */ function(value) {
  if (this._source != value) {
    if (value == null)
      this._source = [];
    else
      this._source = value;
    this.dispatchEvent(new org.apache.flex.events.Event("collectionChanged"));
  }
}},
/** @export */
length: {
get: /** @this {org.apache.flex.collections.ArrayList} */ function() {
  return this._source ? this._source.length : 0;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.collections.ArrayList.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ArrayList', qName: 'org.apache.flex.collections.ArrayList'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.collections.ICollection, org.apache.flex.collections.IArrayList] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.collections.ArrayList', org.apache.flex.collections.ArrayList);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.collections.ArrayList.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'id': { type: 'String', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'source': { type: 'Array', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'length': { type: 'int', declaredBy: 'org.apache.flex.collections.ArrayList'}
      };
    },
    methods: function () {
      return {
        'ArrayList': { type: '', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'toArray': { type: 'Array', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'getItemAt': { type: 'Object', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'getItemIndex': { type: 'int', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'addItem': { type: 'void', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'addItemAt': { type: 'void', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'setItemAt': { type: 'Object', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'removeItem': { type: 'Boolean', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'removeItemAt': { type: 'Object', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'removeAll': { type: 'void', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'itemUpdated': { type: 'void', declaredBy: 'org.apache.flex.collections.ArrayList'},
        'itemUpdatedAt': { type: 'void', declaredBy: 'org.apache.flex.collections.ArrayList'}
      };
    },
    metadata: function () { return [ ]; }
  };
};