/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/supportClasses/WedgeItemRenderer.as
 * org.apache.flex.charts.supportClasses.WedgeItemRenderer
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.supportClasses.WedgeItemRenderer');

goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.html.supportClasses.DataItemRenderer');
goog.require('org.apache.flex.svg.LinearGradient');
goog.require('org.apache.flex.svg.Path');
goog.require('org.apache.flex.charts.supportClasses.IWedgeItemRenderer');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.supportClasses.DataItemRenderer}
 * @implements {org.apache.flex.charts.supportClasses.IWedgeItemRenderer}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer = function() {
  org.apache.flex.charts.supportClasses.WedgeItemRenderer.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.supportClasses.WedgeItemRenderer, org.apache.flex.html.supportClasses.DataItemRenderer);


/**
 * @export
 * @override
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype.addedToParent = function() {
  org.apache.flex.charts.supportClasses.WedgeItemRenderer.base(this, 'addedToParent');
};


/**
 * @export
 * @override
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype.addBead = function(bead) {
  org.apache.flex.charts.supportClasses.WedgeItemRenderer.base(this, 'addBead', bead);
};


/**
 * @private
 * @type {org.apache.flex.charts.core.IChartSeries}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype._series;


/**
 * @private
 * @type {org.apache.flex.svg.Path}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype.filledPath;


/**
 * @private
 * @type {org.apache.flex.graphics.IFill}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype._fill;


/**
 * @private
 * @type {org.apache.flex.graphics.IStroke}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype._stroke;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype._centerX;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype._centerY;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype._startAngle;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype._arc;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype._radius;


/**
 * @asprivate
 * @private
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype.drawWedgeInternal = function() {
  if (!isNaN(this.centerX) && !isNaN(this.centerY) && !isNaN(this.startAngle) && !isNaN(this.arc) && !isNaN(this.radius)) {
    this.drawWedge(this.centerX, this.centerY, this.startAngle, this.arc, this.radius, this.radius, false);
  }
};


/**
 * @asprivate
 * 
 * Draw a wedge of a circle
 * @asparam graphics      the graphics object to draw into
 * @asparam x             the x center of the circle
 * @asparam y             the y center of the circle
 * @asparam startAngle    start angle (radians)
 * @asparam arc           sweep angle (radians)
 * @asparam radius        radius of the circle
 * @asparam yRadius       vertical radius (or radius if none given)
 * @asparam continueFlag  if true, uses a moveTo call to start drawing at the start point of the circle; else continues drawing using only lineTo and curveTo
 * 
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} startAngle
 * @param {number} arc
 * @param {number} radius
 * @param {number=} yRadius
 * @param {boolean=} continueFlag
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype.drawWedge = function(x, y, startAngle, arc, radius, yRadius, continueFlag) {
  yRadius = typeof yRadius !== 'undefined' ? yRadius : NaN;
  continueFlag = typeof continueFlag !== 'undefined' ? continueFlag : false;
  var /** @type {boolean} */ needsAdd = false;
  if (this.filledPath == null) {
    this.filledPath = new org.apache.flex.svg.Path();
    needsAdd = true;
  }
  var /** @type {number} */ x1 = x + radius * Math.cos(startAngle);
  var /** @type {number} */ y1 = y + radius * Math.sin(startAngle);
  var /** @type {number} */ x2 = x + radius * Math.cos(startAngle + arc);
  var /** @type {number} */ y2 = y + radius * Math.sin(startAngle + arc);
  var /** @type {string} */ pathString = 'M' + x + ' ' + y + ' L' + x1 + ' ' + y1 + ' A' + radius + ' ' + radius + ' 0 0 1 ' + x2 + ' ' + y2 + ' z';
  this.filledPath.fill = this.fill;
  this.filledPath.stroke = this.stroke;
  this.filledPath.x = 0;
  this.filledPath.y = 0;
  this.filledPath.data = pathString;
  if (needsAdd) {
    this.addElement(this.filledPath);
  }
};


/**
 * @private
 * @type {org.apache.flex.graphics.IFill}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype.hoverFill;


/**
 * @export
 * @override
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype.updateRenderer = function() {
  if (this.down || this.selected || this.hovered) {
    if (this.hoverFill == null) {
      if (org.apache.flex.utils.Language.is(this.fill, org.apache.flex.graphics.SolidColor)) {
        this.hoverFill = new org.apache.flex.graphics.SolidColor();
        org.apache.flex.utils.Language.as(this.hoverFill, org.apache.flex.graphics.SolidColor).color = org.apache.flex.utils.Language.as(this.fill, org.apache.flex.graphics.SolidColor).color;
        org.apache.flex.utils.Language.as(this.hoverFill, org.apache.flex.graphics.SolidColor).alpha = 0.65;
      } else if (org.apache.flex.utils.Language.is(this.fill, org.apache.flex.svg.LinearGradient)) {
        this.hoverFill = new org.apache.flex.svg.LinearGradient();
        org.apache.flex.utils.Language.as(this.hoverFill, org.apache.flex.svg.LinearGradient).entries = org.apache.flex.utils.Language.as(this.fill, org.apache.flex.svg.LinearGradient).entries;
        for (var /** @type {number} */ i = 0; i < org.apache.flex.utils.Language.as(this.hoverFill, org.apache.flex.svg.LinearGradient).entries; i++) {
          org.apache.flex.utils.Language.as(this.hoverFill, org.apache.flex.svg.LinearGradient).entries[i].alpha = 0.65;
        }
      }
    }
    this.filledPath.fill = this.hoverFill;
  } else {
    this.filledPath.fill = this.fill;
  }
  this.filledPath.drawStringPath(0, 0, this.filledPath.data);
};


Object.defineProperties(org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype, /** @lends {org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype} */ {
/** @export */
series: {
get: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function() {
  return this._series;
},
set: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function(value) {
  this._series = value;
}},
/** @export */
fill: {
get: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function() {
  return this._fill;
},
set: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function(value) {
  this._fill = value;
}},
/** @export */
stroke: {
get: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function() {
  return this._stroke;
},
set: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function(value) {
  this._stroke = value;
}},
/** @export */
data: {
get: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function() {
return org.apache.flex.utils.Language.superGetter(org.apache.flex.charts.supportClasses.WedgeItemRenderer, this, 'data');
},
set: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.charts.supportClasses.WedgeItemRenderer, this, 'data', value);
  this.drawWedgeInternal();
}},
/** @export */
centerX: {
get: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function() {
  return this._centerX;
},
set: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function(value) {
  this._centerX = value;
  this.drawWedgeInternal();
}},
/** @export */
centerY: {
get: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function() {
  return this._centerY;
},
set: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function(value) {
  this._centerY = value;
  this.drawWedgeInternal();
}},
/** @export */
startAngle: {
get: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function() {
  return this._startAngle;
},
set: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function(value) {
  this._startAngle = value;
  this.drawWedgeInternal();
}},
/** @export */
arc: {
get: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function() {
  return this._arc;
},
set: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function(value) {
  this._arc = value;
  this.drawWedgeInternal();
}},
/** @export */
radius: {
get: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function() {
  return this._radius;
},
set: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function(value) {
  this._radius = value;
  this.drawWedgeInternal();
}},
/** @export */
xField: {
get: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function() {
  return null;
},
set: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function(value) {
}},
/** @export */
yField: {
get: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function() {
  return null;
},
set: /** @this {org.apache.flex.charts.supportClasses.WedgeItemRenderer} */ function(value) {
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'WedgeItemRenderer', qName: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'}], interfaces: [org.apache.flex.charts.supportClasses.IWedgeItemRenderer] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.supportClasses.WedgeItemRenderer', org.apache.flex.charts.supportClasses.WedgeItemRenderer);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.supportClasses.WedgeItemRenderer.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'series': { type: 'IChartSeries', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'fill': { type: 'IFill', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'stroke': { type: 'IStroke', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'data': { type: 'Object', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'centerX': { type: 'Number', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'centerY': { type: 'Number', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'startAngle': { type: 'Number', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'arc': { type: 'Number', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'radius': { type: 'Number', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'xField': { type: 'String', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'yField': { type: 'String', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'}
      };
    },
    methods: function () {
      return {
        'WedgeItemRenderer': { type: '', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'addBead': { type: 'void', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'drawWedge': { type: 'void', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'},
        'updateRenderer': { type: 'void', declaredBy: 'org.apache.flex.charts.supportClasses.WedgeItemRenderer'}
      };
    }
  };
};