/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/VerticalCategoryAxisBead.as
 * org.apache.flex.charts.beads.VerticalCategoryAxisBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.VerticalCategoryAxisBead');

goog.require('org.apache.flex.charts.beads.AxisBaseBead');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.beads.models.ArraySelectionModel');
goog.require('org.apache.flex.charts.core.IChart');
goog.require('org.apache.flex.charts.core.IVerticalAxisBead');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.charts.beads.AxisBaseBead}
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.charts.core.IVerticalAxisBead}
 */
org.apache.flex.charts.beads.VerticalCategoryAxisBead = function() {
  org.apache.flex.charts.beads.VerticalCategoryAxisBead.base(this, 'constructor');
  this.placement = "left";
};
goog.inherits(org.apache.flex.charts.beads.VerticalCategoryAxisBead, org.apache.flex.charts.beads.AxisBaseBead);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.charts.beads.VerticalCategoryAxisBead.prototype._strand;


/**
 * @private
 * @type {string}
 */
org.apache.flex.charts.beads.VerticalCategoryAxisBead.prototype._categoryField;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.beads.VerticalCategoryAxisBead.prototype._axisWidth = 100;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.beads.VerticalCategoryAxisBead.prototype._gap = 20;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.charts.beads.VerticalCategoryAxisBead.prototype.handleItemsCreated = function(event) {
  var /** @type {org.apache.flex.html.beads.models.ArraySelectionModel} */ model = org.apache.flex.utils.Language.as(this.strand.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.html.beads.models.ArraySelectionModel);
  var /** @type {Array} */ items;
  if (org.apache.flex.utils.Language.is(model.dataProvider, Array))
    items = org.apache.flex.utils.Language.as(model.dataProvider, Array);
  else
    return;
  this.clearGraphics();
  var /** @type {Array} */ series = org.apache.flex.utils.Language.as(this.strand, org.apache.flex.charts.core.IChart, true).series;
  var /** @type {number} */ useHeight = org.apache.flex.utils.Language.as(this.axisGroup, org.apache.flex.core.UIBase, true).height;
  var /** @type {number} */ useWidth = org.apache.flex.utils.Language.as(this.axisGroup, org.apache.flex.core.UIBase, true).width;
  var /** @type {number} */ itemHeight = (useHeight - this.gap * (items.length - 1)) / items.length;
  var /** @type {number} */ xpos = 0;
  var /** @type {number} */ ypos = useHeight - itemHeight / 2;
  var /** @type {number} */ numTicks = items.length;
  var /** @type {number} */ tickSpacing = itemHeight + this.gap;
  for (var /** @type {number} */ i = 0; i < items.length; i++) {
    var /** @type {Object} */ label = this.addTickLabel(items[i][this.categoryField], 0, ypos, 0, itemHeight);
    label.y = ypos - label.height / 2;
    this.addTickMark(useWidth - 6, ypos, 5, 0);
    ypos -= tickSpacing;
  }
  this.drawAxisPath(useWidth - 1, 0, 0, useHeight);
  this.drawTickPath(useWidth - 6, 0);
};


Object.defineProperties(org.apache.flex.charts.beads.VerticalCategoryAxisBead.prototype, /** @lends {org.apache.flex.charts.beads.VerticalCategoryAxisBead.prototype} */ {
/** @export */
strand: {
get: /** @this {org.apache.flex.charts.beads.VerticalCategoryAxisBead} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.charts.beads.VerticalCategoryAxisBead} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.superSetter(org.apache.flex.charts.beads.VerticalCategoryAxisBead, this, 'strand', value);
  org.apache.flex.utils.Language.as(this.strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("layoutComplete", org.apache.flex.utils.Language.closure(this.handleItemsCreated, this, 'handleItemsCreated'));
}},
/** @export */
categoryField: {
get: /** @this {org.apache.flex.charts.beads.VerticalCategoryAxisBead} */ function() {
  return this._categoryField;
},
set: /** @this {org.apache.flex.charts.beads.VerticalCategoryAxisBead} */ function(value) {
  this._categoryField = value;
}},
/** @export */
axisWidth: {
get: /** @this {org.apache.flex.charts.beads.VerticalCategoryAxisBead} */ function() {
  return this._axisWidth;
},
set: /** @this {org.apache.flex.charts.beads.VerticalCategoryAxisBead} */ function(value) {
  this._axisWidth = value;
}},
/** @export */
gap: {
get: /** @this {org.apache.flex.charts.beads.VerticalCategoryAxisBead} */ function() {
  return this._gap;
},
set: /** @this {org.apache.flex.charts.beads.VerticalCategoryAxisBead} */ function(value) {
  this._gap = value;
}},
/** @export */
maximum: {
get: /** @this {org.apache.flex.charts.beads.VerticalCategoryAxisBead} */ function() {
  return Number.NaN;
}},
/** @export */
minimum: {
get: /** @this {org.apache.flex.charts.beads.VerticalCategoryAxisBead} */ function() {
  return 0;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.VerticalCategoryAxisBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'VerticalCategoryAxisBead', qName: 'org.apache.flex.charts.beads.VerticalCategoryAxisBead'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.charts.core.IVerticalAxisBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.VerticalCategoryAxisBead', org.apache.flex.charts.beads.VerticalCategoryAxisBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.VerticalCategoryAxisBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.charts.beads.VerticalCategoryAxisBead'},
        'categoryField': { type: 'String', declaredBy: 'org.apache.flex.charts.beads.VerticalCategoryAxisBead'},
        'axisWidth': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.VerticalCategoryAxisBead'},
        'gap': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.VerticalCategoryAxisBead'},
        'maximum': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.VerticalCategoryAxisBead'},
        'minimum': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.VerticalCategoryAxisBead'}
      };
    },
    methods: function () {
      return {
        'VerticalCategoryAxisBead': { type: '', declaredBy: 'org.apache.flex.charts.beads.VerticalCategoryAxisBead'}
      };
    }
  };
};