/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/DataItemRendererFactoryForSeriesData.as
 * org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.charts.core.IChart');
goog.require('org.apache.flex.charts.core.IChartDataGroup');
goog.require('org.apache.flex.charts.core.IChartItemRenderer');
goog.require('org.apache.flex.charts.core.IChartSeries');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDataProviderItemRendererMapper');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.html.beads.IListView');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IDataProviderItemRendererMapper}
 */
org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData.prototype._strand;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData.prototype.dataProviderChangeHandler = function(event) {
  var /** @type {org.apache.flex.core.ISelectionModel} */ selectionModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  var /** @type {Array} */ dp = org.apache.flex.utils.Language.as(selectionModel.dataProvider, Array);
  if (!dp)
    return;
  var /** @type {org.apache.flex.html.beads.IListView} */ listView = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.html.beads.IListView), org.apache.flex.html.beads.IListView);
  var /** @type {org.apache.flex.charts.core.IChartDataGroup} */ dataGroup = org.apache.flex.utils.Language.as(listView.dataGroup, org.apache.flex.charts.core.IChartDataGroup);
  dataGroup.removeAllElements();
  var /** @type {org.apache.flex.charts.core.IChart} */ chart = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.charts.core.IChart);
  var /** @type {Array} */ series = chart.series;
  for (var /** @type {number} */ s = 0; s < series.length; s++) {
    var /** @type {number} */ n = dp.length;
    var /** @type {org.apache.flex.charts.core.IChartSeries} */ chartSeries = org.apache.flex.utils.Language.as(series[s], org.apache.flex.charts.core.IChartSeries);
    for (var /** @type {number} */ i = 0; i < n; i++) {
      if (chartSeries.itemRenderer) {
        var /** @type {org.apache.flex.charts.core.IChartItemRenderer} */ ir = org.apache.flex.utils.Language.as(chartSeries.itemRenderer.newInstance(), org.apache.flex.charts.core.IChartItemRenderer);
        dataGroup.addElement(ir);
        ir.itemRendererParent = dataGroup;
        ir.index = i;
        ir.data = dp[i];
        ir.series = chartSeries;
      }
    }
  }
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("itemsCreated"));
};


Object.defineProperties(org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData.prototype, /** @lends {org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData.prototype} */ {
/** @export */
strand: {
get: /** @this {org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData} */ function(value) {
  this._strand = value;
  var /** @type {org.apache.flex.core.ISelectionModel} */ selectionModel = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  selectionModel.addEventListener("dataProviderChanged", org.apache.flex.utils.Language.closure(this.dataProviderChangeHandler, this, 'dataProviderChangeHandler'));
  this.dataProviderChangeHandler(null);
}},
/** @export */
itemRendererFactory: {
get: /** @this {org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData} */ function() {
  return null;
},
set: /** @this {org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData} */ function(value) {
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DataItemRendererFactoryForSeriesData', qName: 'org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IDataProviderItemRendererMapper] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData', org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData'},
        'itemRendererFactory': { type: 'IItemRendererClassFactory', declaredBy: 'org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData'}
      };
    },
    methods: function () {
      return {
        'DataItemRendererFactoryForSeriesData': { type: '', declaredBy: 'org.apache.flex.charts.beads.DataItemRendererFactoryForSeriesData'}
      };
    }
  };
};