/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/ChartView.as
 * org.apache.flex.charts.beads.ChartView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.ChartView');

goog.require('org.apache.flex.charts.supportClasses.ChartDataGroup');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.html.beads.ListView');
goog.require('org.apache.flex.utils.CSSContainerUtils');
goog.require('org.apache.flex.charts.core.IChartDataModel');
goog.require('org.apache.flex.charts.core.IHorizontalAxisBead');
goog.require('org.apache.flex.charts.core.IVerticalAxisBead');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IParent');
goog.require('org.apache.flex.core.ISelectableItemRenderer');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.beads.ListView}
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.charts.beads.ChartView = function() {
  org.apache.flex.charts.beads.ChartView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.beads.ChartView, org.apache.flex.html.beads.ListView);


/**
 * @private
 * @type {org.apache.flex.charts.core.IAxisGroup}
 */
org.apache.flex.charts.beads.ChartView.prototype._horizontalAxisGroup;


/**
 * @private
 * @type {org.apache.flex.charts.core.IAxisGroup}
 */
org.apache.flex.charts.beads.ChartView.prototype._verticalAxisGroup;


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.flex.charts.beads.ChartView.prototype.completeSetup = function() {
  if (this.border) {
    org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IParent, true).removeElement(this.border);
  }
  org.apache.flex.charts.beads.ChartView.base(this, 'completeSetup');
};


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.flex.charts.beads.ChartView.prototype.dataProviderChangeHandler = function(event) {
  if (this.verticalAxisGroup) {
    this.verticalAxisGroup.removeAllElements();
  }
  if (this.horizontalAxisGroup) {
    this.horizontalAxisGroup.removeAllElements();
  }
  this.dataGroup.removeAllElements();
};


/**
 * ChartView overrides performLayout so that the exact area of the ChartDataGroup can
 * be calculated so the chart's layout algorithm knows precisely the dimensions of 
 * chart for its item renderers.
 * @protected
 * @override
 */
org.apache.flex.charts.beads.ChartView.prototype.layoutViewBeforeContentLayout = function() {
  var /** @type {org.apache.flex.geom.Rectangle} */ metrics = org.apache.flex.utils.CSSContainerUtils.getBorderAndPaddingMetrics(this._strand);
  var /** @type {number} */ widthAdjustment = 0;
  var /** @type {number} */ heightAdjustment = 0;
  var /** @type {org.apache.flex.charts.core.IVerticalAxisBead} */ vaxis = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.charts.core.IVerticalAxisBead), org.apache.flex.charts.core.IVerticalAxisBead);
  var /** @type {org.apache.flex.charts.core.IHorizontalAxisBead} */ haxis = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.charts.core.IHorizontalAxisBead), org.apache.flex.charts.core.IHorizontalAxisBead);
  if (vaxis) {
    widthAdjustment = vaxis.axisWidth;
  }
  if (haxis) {
    heightAdjustment = haxis.axisHeight;
  }
  var /** @type {number} */ strandWidth = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).width;
  var /** @type {number} */ strandHeight = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).height;
  this.viewport.setPosition(widthAdjustment + metrics.left, metrics.top);
  this.viewport.layoutViewportBeforeContentLayout(strandWidth - widthAdjustment - metrics.right - metrics.left, strandHeight - heightAdjustment - metrics.bottom - metrics.top);
  if (this.verticalAxisGroup) {
    org.apache.flex.utils.Language.as(this.verticalAxisGroup, org.apache.flex.core.UIBase, true).x = metrics.left;
    org.apache.flex.utils.Language.as(this.verticalAxisGroup, org.apache.flex.core.UIBase, true).y = metrics.top;
    org.apache.flex.utils.Language.as(this.verticalAxisGroup, org.apache.flex.core.UIBase, true).width = widthAdjustment;
    org.apache.flex.utils.Language.as(this.verticalAxisGroup, org.apache.flex.core.UIBase, true).height = strandHeight - heightAdjustment - metrics.bottom - metrics.top;
  }
  if (this.horizontalAxisGroup) {
    org.apache.flex.utils.Language.as(this.horizontalAxisGroup, org.apache.flex.core.UIBase, true).x = widthAdjustment + metrics.left;
    org.apache.flex.utils.Language.as(this.horizontalAxisGroup, org.apache.flex.core.UIBase, true).y = strandHeight - heightAdjustment - metrics.bottom;
    org.apache.flex.utils.Language.as(this.horizontalAxisGroup, org.apache.flex.core.UIBase, true).width = strandWidth - widthAdjustment - metrics.left - metrics.right;
    org.apache.flex.utils.Language.as(this.horizontalAxisGroup, org.apache.flex.core.UIBase, true).height = heightAdjustment;
  }
};


/**
 * @protected
 * @type {org.apache.flex.charts.core.IChartSeries}
 */
org.apache.flex.charts.beads.ChartView.prototype.lastSelectedSeries;


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.flex.charts.beads.ChartView.prototype.selectionChangeHandler = function(event) {
  var /** @type {org.apache.flex.charts.core.IChartDataModel} */ model = org.apache.flex.utils.Language.as(event.currentTarget, org.apache.flex.charts.core.IChartDataModel);
  var /** @type {org.apache.flex.charts.supportClasses.ChartDataGroup} */ chartDataGroup = org.apache.flex.utils.Language.as(this.dataGroup, org.apache.flex.charts.supportClasses.ChartDataGroup);
  var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ ir = null;
  if (this.lastSelectedIndex != -1) {
    ir = org.apache.flex.utils.Language.as(chartDataGroup.getItemRendererForSeriesAtIndex(this.lastSelectedSeries, this.lastSelectedIndex), org.apache.flex.core.ISelectableItemRenderer);
    ir.selected = false;
  }
  if (model.selectedIndex != -1) {
    ir = org.apache.flex.utils.Language.as(chartDataGroup.getItemRendererForSeriesAtIndex(model.selectedSeries, model.selectedIndex), org.apache.flex.core.ISelectableItemRenderer);
    ir.selected = true;
  }
  this.lastSelectedIndex = model.selectedIndex;
  this.lastSelectedSeries = model.selectedSeries;
};


/**
 * @protected
 * @type {org.apache.flex.charts.core.IChartSeries}
 */
org.apache.flex.charts.beads.ChartView.prototype.lastRollOverSeries;


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.flex.charts.beads.ChartView.prototype.rollOverIndexChangeHandler = function(event) {
  var /** @type {org.apache.flex.charts.core.IChartDataModel} */ model = org.apache.flex.utils.Language.as(event.currentTarget, org.apache.flex.charts.core.IChartDataModel);
  var /** @type {org.apache.flex.charts.supportClasses.ChartDataGroup} */ chartDataGroup = org.apache.flex.utils.Language.as(this.dataGroup, org.apache.flex.charts.supportClasses.ChartDataGroup);
  var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ ir = null;
  if (this.lastRollOverIndex != -1) {
    ir = org.apache.flex.utils.Language.as(chartDataGroup.getItemRendererForSeriesAtIndex(this.lastRollOverSeries, this.lastRollOverIndex), org.apache.flex.core.ISelectableItemRenderer);
    ir.hovered = false;
  }
  if (model.rollOverIndex != -1) {
    ir = org.apache.flex.utils.Language.as(chartDataGroup.getItemRendererForSeriesAtIndex(model.rollOverSeries, model.rollOverIndex), org.apache.flex.core.ISelectableItemRenderer);
    ir.hovered = true;
  }
  this.lastRollOverIndex = model.rollOverIndex;
  this.lastRollOverSeries = model.rollOverSeries;
};


Object.defineProperties(org.apache.flex.charts.beads.ChartView.prototype, /** @lends {org.apache.flex.charts.beads.ChartView.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.charts.beads.ChartView} */ function(value) {
  this._strand = value;
  var /** @type {org.apache.flex.charts.core.IChartDataModel} */ listModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.charts.core.IChartDataModel), org.apache.flex.charts.core.IChartDataModel);
  listModel.addEventListener("dataProviderChanged", org.apache.flex.utils.Language.closure(this.dataProviderChangeHandler, this, 'dataProviderChangeHandler'));
  var /** @type {org.apache.flex.charts.core.IHorizontalAxisBead} */ haxis = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.charts.core.IHorizontalAxisBead), org.apache.flex.charts.core.IHorizontalAxisBead);
  if (haxis && this._horizontalAxisGroup == null) {
    var /** @type {Object} */ m1 = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this._strand, "iHorizontalAxisGroup");
    this._horizontalAxisGroup = new m1();
    haxis.axisGroup = this._horizontalAxisGroup;
    org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IParent, true).addElement(this._horizontalAxisGroup, false);
  }
  var /** @type {org.apache.flex.charts.core.IVerticalAxisBead} */ vaxis = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.charts.core.IVerticalAxisBead), org.apache.flex.charts.core.IVerticalAxisBead);
  if (vaxis && this._verticalAxisGroup == null) {
    var /** @type {Object} */ m2 = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this._strand, "iVerticalAxisGroup");
    this._verticalAxisGroup = new m2();
    vaxis.axisGroup = this._verticalAxisGroup;
    org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IParent, true).addElement(this._verticalAxisGroup, false);
  }
  org.apache.flex.utils.Language.superSetter(org.apache.flex.charts.beads.ChartView, this, 'strand', value);
}},
/** @export */
horizontalAxisGroup: {
get: /** @this {org.apache.flex.charts.beads.ChartView} */ function() {
  return this._horizontalAxisGroup;
}},
/** @export */
verticalAxisGroup: {
get: /** @this {org.apache.flex.charts.beads.ChartView} */ function() {
  return this._verticalAxisGroup;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.ChartView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ChartView', qName: 'org.apache.flex.charts.beads.ChartView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.ChartView', org.apache.flex.charts.beads.ChartView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.ChartView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.charts.beads.ChartView'},
        'horizontalAxisGroup': { type: 'IAxisGroup', declaredBy: 'org.apache.flex.charts.beads.ChartView'},
        'verticalAxisGroup': { type: 'IAxisGroup', declaredBy: 'org.apache.flex.charts.beads.ChartView'}
      };
    },
    methods: function () {
      return {
        'ChartView': { type: '', declaredBy: 'org.apache.flex.charts.beads.ChartView'}
      };
    }
  };
};